﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Linq;
using System.Windows.Forms;
using System.IO;
using LayoutEditor.Controls;

namespace LayoutEditor.Forms.Dialogs
{
    /// <summary>
    /// 派生元再設定ダイアログ
    /// </summary>
    public partial class RestoreDerivativeSourceDlg : LayoutEditor.Forms.Dialogs.LEBaseDlg
    {

        //----------------------------------------------------------

        public IEnumerable<string> TargetFilePathSet
        {
            get
            {
                foreach (ListViewItem item in _lvwFiles.Items)
                {
                    if (item.Checked)
                    {
                        yield return item.Tag as string;
                    }
                }
            }
        }

        public string NewBasePartsName
        {
            get
            {
                return _cmbNewName.SelectedItemData as string;
            }
        }

        //----------------------------------------------------------

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public RestoreDerivativeSourceDlg()
        {
            InitializeComponent();
        }

        //----------------------------------------------------------

        /// <summary>
        /// 初期化します。
        /// </summary>
        public void Initialize(string currentName, IEnumerable<string> allBasePartsName, IEnumerable<string> partsFilePathSet)
        {
            _lblCurrentName.Text = currentName;
            _chdMain.Text = StringResMgr.Get("PARTS_PALLET_TARGET_SAMEBASE");

            // newName候補の初期化
            _cmbNewName.SelectedIndexChanged += Event_cmbNewName_SelectedIndexChanged;
            _cmbNewName.Items.Add(new UIListControlItem(StringResMgr.Get("PARTS_PALLET_RESET_BASE"), string.Empty));
            foreach (var basePartsName in allBasePartsName)
            {
                var newItem = new UIListControlItem(
                    basePartsName == currentName ? basePartsName + " [*]" : basePartsName, basePartsName);
                _cmbNewName.Items.Add(newItem);
            }

            _cmbNewName.SetSelectedByData(currentName);
            _cmbNewName.ExpandDropDownWidth();

            foreach (var partsFilePath in partsFilePathSet)
            {
                ListViewItem newItem = new ListViewItem(string.Format("{0}", Path.GetFileName(partsFilePath)));
                newItem.Tag = partsFilePath;
                _lvwFiles.Items.Add(newItem);
            }
            _lvwFiles.Items[0].Checked = true;
        }

        /// <summary>
        /// UIを更新
        /// </summary>
        public void UpdateProperty_()
        {
            _btnOK.Enabled =
                _lblCurrentName.Text != this.NewBasePartsName &&
                this.TargetFilePathSet.Count() > 0;

            _lblNotice.Visible = string.IsNullOrEmpty(NewBasePartsName);
        }

        //----------------------------------------------------------

        void Event_cmbNewName_SelectedIndexChanged(object sender, EventArgs e)
        {
            UpdateProperty_();
        }

        /// <summary>
        /// テキスト変更
        /// </summary>
        private void Event_tbxNewName_TextChanged(object sender, EventArgs e)
        {
            UpdateProperty_();
        }

        /// <summary>
        /// アイテムチェック変更
        /// </summary>
        private void Event_lvwFiles_ItemChecked(object sender, ItemCheckedEventArgs e)
        {
            UpdateProperty_();
        }

        /// <summary>
        /// OK
        /// </summary>
        private void Event_btnOK_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.OK;
        }

        /// <summary>
        /// キャンセル
        /// </summary>
        private void Event_btnCancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
        }
    }
}
