﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using LayoutEditor.Forms.Dialogs;
using LECore.Structures;

namespace LayoutEditor.Forms.Dialogs
{
    public partial class SetDelivativePartsDlg : LEBaseDlg
    {
        //----------------------------------------------------------
        // プロパティ
        //----------------------------------------------------------

        public string PartsName { get { return _tbxName.Text; } }
        public string Descriptions { get { return _tbxDescriptions.Text; } }

        //----------------------------------------------------------
        // コンストラクタ
        //----------------------------------------------------------

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public SetDelivativePartsDlg()
        {
            InitializeComponent();
            UpdateProperty();
        }

        /// <summary>
        /// 初期化します。
        /// </summary>
        public void Initialize(IDerivativePartsSettings derivativePartsSettings)
        {
            this._tbxName.Text = derivativePartsSettings.Name;
            this._tbxDescriptions.Text = derivativePartsSettings.Descriptions;
        }

        private void UpdateProperty()
        {
            _btnOK.Enabled = !string.IsNullOrEmpty(_tbxName.Text);
        }

        //----------------------------------------------------------
        // イベントハンドラ
        //----------------------------------------------------------

        private void Event_BtnOK_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.OK;
        }

        private void Event_BtnCancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
        }

        private void Event_TbxName_TextChanged(object sender, EventArgs e)
        {
            UpdateProperty();
        }
    }
}
