﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Diagnostics;
using System.Windows.Forms;


namespace LayoutEditor.Forms
{
    using Structures;
    using Structures.SerializableObject;

    using LECore;
    using LECore.Structures;
    using LECore.Structures.Core;

    using LECore.Util;
    using LECore.Manipulator;

    using AppSetting = LayoutEditor.Structures.SerializableObject.AppSetting;
    using RendererType = LayoutEditor.Structures.SerializableObject.AppSetting.RendererType;

    /// <summary>
    /// EnviromentSettingDlg の概要の説明です。
    /// </summary>
    public class EnviromentSettingDlg : Form
    {
        #region デザイナ変数

        private System.Windows.Forms.Button _btnOK;
        private System.Windows.Forms.Button _btnCancel;
        private System.Windows.Forms.CheckBox _chkDrawSafeFrame;
        private System.Windows.Forms.TextBox _tbxSafeFrameL;
        private System.Windows.Forms.TextBox _tbxSafeFrameB;
        private System.Windows.Forms.TextBox _tbxSafeFrameR;
        private System.Windows.Forms.GroupBox groupBox1;
        private System.Windows.Forms.Label _lblSafeFrameT;
        private System.Windows.Forms.Label _lblSafeFrameB;
        private System.Windows.Forms.Label _lblSafeFrameL;
        private System.Windows.Forms.Label _lblSafeFrameR;
        private System.Windows.Forms.TextBox _tbxSafeFrameT;
        private LayoutEditor.Controls.ColorEditPanel _ctlSafeFrameColor;
        private GroupBox _grpPreview;
        private CheckBox _chkDrawHiddenPanesAsNull;
        private CheckBox _chkConvertTextboxControlCode;
        private GroupBox _grpRenderingMode;
        private LayoutEditor.Controls.UIRadioButton _radGDIMode;
        private LayoutEditor.Controls.UIRadioButton _radDirectXMode;
        private ComboBox _cmbTarget;
        private Label _lblTarget;
        private GroupBox _grpPane;
        private CheckBox _chkConveyTransparency;
        private GroupBox _grpGamma;
        private CheckBox _chkGamma;
        private CheckBox _chkGammaColorParams;
        private PictureBox _imgNotifyGammaColor;
        private Controls.DockContentToolTip _ttpMain;
        private IContainer components;
        private PictureBox _imgNotifyGamma;
        private CheckBox _chkGammaSRGBFetch;
        private CheckBox _chkGammaSRGBWrite;
        private GroupBox _grpPerspective;
        private Label _lblFar;
        private Label _lblNear;
        private Label _lblFOV;
        private CheckBox _chkDepthWriteTestEnabled;
        private LayoutEditor.Controls.FloatTextBox _tbxFar;
        private LayoutEditor.Controls.FloatTextBox _tbxNear;
        private LayoutEditor.Controls.FloatTextBox _tbxFOV;
        private PictureBox _imgNotifyPers;
        private CheckBox _chkIsPerspectiveDefault;
        private PictureBox _imgNotifyOmitNoKeyAll;
        private CheckBox _chkOmitNoKeyAll;
        private GroupBox _grpFrameRate;
        private CheckBox _chkIs30Fps;
        private PictureBox _imgNotifyFrameRate;
        private PictureBox _imgNotifyGammaTex;
        private GroupBox _grpWarningWindow;
        private CheckBox _chkAllDispWarningWindow;
        private GroupBox _grpHierarchyWindow;
        private CheckBox _chkHierarchyWindowPaneControl;
        private System.Windows.Forms.Label _lblFrameColor;
        #endregion デザイナ変数

        #region デザイナコード
        private void InitializeComponent()
        {
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(EnviromentSettingDlg));
            this._btnOK = new System.Windows.Forms.Button();
            this._btnCancel = new System.Windows.Forms.Button();
            this.groupBox1 = new System.Windows.Forms.GroupBox();
            this._lblFrameColor = new System.Windows.Forms.Label();
            this._ctlSafeFrameColor = new LayoutEditor.Controls.ColorEditPanel();
            this._chkDrawSafeFrame = new System.Windows.Forms.CheckBox();
            this._tbxSafeFrameT = new System.Windows.Forms.TextBox();
            this._lblSafeFrameT = new System.Windows.Forms.Label();
            this._lblSafeFrameB = new System.Windows.Forms.Label();
            this._lblSafeFrameL = new System.Windows.Forms.Label();
            this._lblSafeFrameR = new System.Windows.Forms.Label();
            this._tbxSafeFrameL = new System.Windows.Forms.TextBox();
            this._tbxSafeFrameB = new System.Windows.Forms.TextBox();
            this._tbxSafeFrameR = new System.Windows.Forms.TextBox();
            this._grpPreview = new System.Windows.Forms.GroupBox();
            this._imgNotifyOmitNoKeyAll = new System.Windows.Forms.PictureBox();
            this._chkOmitNoKeyAll = new System.Windows.Forms.CheckBox();
            this._cmbTarget = new System.Windows.Forms.ComboBox();
            this._chkConvertTextboxControlCode = new System.Windows.Forms.CheckBox();
            this._chkDrawHiddenPanesAsNull = new System.Windows.Forms.CheckBox();
            this._lblTarget = new System.Windows.Forms.Label();
            this._grpRenderingMode = new System.Windows.Forms.GroupBox();
            this._radGDIMode = new LayoutEditor.Controls.UIRadioButton();
            this._radDirectXMode = new LayoutEditor.Controls.UIRadioButton();
            this._grpPane = new System.Windows.Forms.GroupBox();
            this._chkConveyTransparency = new System.Windows.Forms.CheckBox();
            this._grpGamma = new System.Windows.Forms.GroupBox();
            this._imgNotifyGammaTex = new System.Windows.Forms.PictureBox();
            this._chkGammaSRGBFetch = new System.Windows.Forms.CheckBox();
            this._chkGammaSRGBWrite = new System.Windows.Forms.CheckBox();
            this._imgNotifyGamma = new System.Windows.Forms.PictureBox();
            this._imgNotifyGammaColor = new System.Windows.Forms.PictureBox();
            this._chkGammaColorParams = new System.Windows.Forms.CheckBox();
            this._chkGamma = new System.Windows.Forms.CheckBox();
            this._ttpMain = new LayoutEditor.Controls.DockContentToolTip(this.components);
            this._imgNotifyPers = new System.Windows.Forms.PictureBox();
            this._chkDepthWriteTestEnabled = new System.Windows.Forms.CheckBox();
            this._imgNotifyFrameRate = new System.Windows.Forms.PictureBox();
            this._grpPerspective = new System.Windows.Forms.GroupBox();
            this._chkIsPerspectiveDefault = new System.Windows.Forms.CheckBox();
            this._tbxFar = new LayoutEditor.Controls.FloatTextBox();
            this._tbxNear = new LayoutEditor.Controls.FloatTextBox();
            this._tbxFOV = new LayoutEditor.Controls.FloatTextBox();
            this._lblFar = new System.Windows.Forms.Label();
            this._lblNear = new System.Windows.Forms.Label();
            this._lblFOV = new System.Windows.Forms.Label();
            this._grpFrameRate = new System.Windows.Forms.GroupBox();
            this._chkIs30Fps = new System.Windows.Forms.CheckBox();
            this._grpWarningWindow = new System.Windows.Forms.GroupBox();
            this._chkAllDispWarningWindow = new System.Windows.Forms.CheckBox();
            this._grpHierarchyWindow = new System.Windows.Forms.GroupBox();
            this._chkHierarchyWindowPaneControl = new System.Windows.Forms.CheckBox();
            this.groupBox1.SuspendLayout();
            this._grpPreview.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this._imgNotifyOmitNoKeyAll)).BeginInit();
            this._grpRenderingMode.SuspendLayout();
            this._grpPane.SuspendLayout();
            this._grpGamma.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this._imgNotifyGammaTex)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this._imgNotifyGamma)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this._imgNotifyGammaColor)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this._imgNotifyPers)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this._imgNotifyFrameRate)).BeginInit();
            this._grpPerspective.SuspendLayout();
            this._grpFrameRate.SuspendLayout();
            this._grpWarningWindow.SuspendLayout();
            this._grpHierarchyWindow.SuspendLayout();
            this.SuspendLayout();
            //
            // _btnOK
            //
            resources.ApplyResources(this._btnOK, "_btnOK");
            this._btnOK.Name = "_btnOK";
            this._btnOK.Click += new System.EventHandler(this.Event_BtnOK_Click);
            //
            // _btnCancel
            //
            resources.ApplyResources(this._btnCancel, "_btnCancel");
            this._btnCancel.Name = "_btnCancel";
            this._btnCancel.Click += new System.EventHandler(this.Event_BtnCancel_Click);
            //
            // groupBox1
            //
            this.groupBox1.Controls.Add(this._lblFrameColor);
            this.groupBox1.Controls.Add(this._ctlSafeFrameColor);
            this.groupBox1.Controls.Add(this._chkDrawSafeFrame);
            this.groupBox1.Controls.Add(this._tbxSafeFrameT);
            this.groupBox1.Controls.Add(this._lblSafeFrameT);
            this.groupBox1.Controls.Add(this._lblSafeFrameB);
            this.groupBox1.Controls.Add(this._lblSafeFrameL);
            this.groupBox1.Controls.Add(this._lblSafeFrameR);
            this.groupBox1.Controls.Add(this._tbxSafeFrameL);
            this.groupBox1.Controls.Add(this._tbxSafeFrameB);
            this.groupBox1.Controls.Add(this._tbxSafeFrameR);
            resources.ApplyResources(this.groupBox1, "groupBox1");
            this.groupBox1.Name = "groupBox1";
            this.groupBox1.TabStop = false;
            //
            // _lblFrameColor
            //
            resources.ApplyResources(this._lblFrameColor, "_lblFrameColor");
            this._lblFrameColor.Name = "_lblFrameColor";
            //
            // _ctlSafeFrameColor
            //
            this._ctlSafeFrameColor.AllowDrop = true;
            resources.ApplyResources(this._ctlSafeFrameColor, "_ctlSafeFrameColor");
            this._ctlSafeFrameColor.Name = "_ctlSafeFrameColor";
            this._ctlSafeFrameColor.Tag = "";
            this._ctlSafeFrameColor.UseAnimationMark = false;
            //
            // _chkDrawSafeFrame
            //
            resources.ApplyResources(this._chkDrawSafeFrame, "_chkDrawSafeFrame");
            this._chkDrawSafeFrame.Name = "_chkDrawSafeFrame";
            //
            // _tbxSafeFrameT
            //
            resources.ApplyResources(this._tbxSafeFrameT, "_tbxSafeFrameT");
            this._tbxSafeFrameT.Name = "_tbxSafeFrameT";
            this._tbxSafeFrameT.KeyDown += new System.Windows.Forms.KeyEventHandler(this.Event_TbxSafeFrame_KeyDown);
            this._tbxSafeFrameT.Validating += new System.ComponentModel.CancelEventHandler(this.Event_TbxSafeFrame_Validating);
            //
            // _lblSafeFrameT
            //
            resources.ApplyResources(this._lblSafeFrameT, "_lblSafeFrameT");
            this._lblSafeFrameT.Name = "_lblSafeFrameT";
            //
            // _lblSafeFrameB
            //
            resources.ApplyResources(this._lblSafeFrameB, "_lblSafeFrameB");
            this._lblSafeFrameB.Name = "_lblSafeFrameB";
            //
            // _lblSafeFrameL
            //
            resources.ApplyResources(this._lblSafeFrameL, "_lblSafeFrameL");
            this._lblSafeFrameL.Name = "_lblSafeFrameL";
            //
            // _lblSafeFrameR
            //
            resources.ApplyResources(this._lblSafeFrameR, "_lblSafeFrameR");
            this._lblSafeFrameR.Name = "_lblSafeFrameR";
            //
            // _tbxSafeFrameL
            //
            resources.ApplyResources(this._tbxSafeFrameL, "_tbxSafeFrameL");
            this._tbxSafeFrameL.Name = "_tbxSafeFrameL";
            this._tbxSafeFrameL.KeyDown += new System.Windows.Forms.KeyEventHandler(this.Event_TbxSafeFrame_KeyDown);
            this._tbxSafeFrameL.Validating += new System.ComponentModel.CancelEventHandler(this.Event_TbxSafeFrame_Validating);
            //
            // _tbxSafeFrameB
            //
            resources.ApplyResources(this._tbxSafeFrameB, "_tbxSafeFrameB");
            this._tbxSafeFrameB.Name = "_tbxSafeFrameB";
            this._tbxSafeFrameB.KeyDown += new System.Windows.Forms.KeyEventHandler(this.Event_TbxSafeFrame_KeyDown);
            this._tbxSafeFrameB.Validating += new System.ComponentModel.CancelEventHandler(this.Event_TbxSafeFrame_Validating);
            //
            // _tbxSafeFrameR
            //
            resources.ApplyResources(this._tbxSafeFrameR, "_tbxSafeFrameR");
            this._tbxSafeFrameR.Name = "_tbxSafeFrameR";
            this._tbxSafeFrameR.KeyDown += new System.Windows.Forms.KeyEventHandler(this.Event_TbxSafeFrame_KeyDown);
            this._tbxSafeFrameR.Validating += new System.ComponentModel.CancelEventHandler(this.Event_TbxSafeFrame_Validating);
            //
            // _grpPreview
            //
            this._grpPreview.Controls.Add(this._imgNotifyOmitNoKeyAll);
            this._grpPreview.Controls.Add(this._chkOmitNoKeyAll);
            this._grpPreview.Controls.Add(this._cmbTarget);
            this._grpPreview.Controls.Add(this._chkConvertTextboxControlCode);
            this._grpPreview.Controls.Add(this._chkDrawHiddenPanesAsNull);
            this._grpPreview.Controls.Add(this._lblTarget);
            resources.ApplyResources(this._grpPreview, "_grpPreview");
            this._grpPreview.Name = "_grpPreview";
            this._grpPreview.TabStop = false;
            //
            // _imgNotifyOmitNoKeyAll
            //
            resources.ApplyResources(this._imgNotifyOmitNoKeyAll, "_imgNotifyOmitNoKeyAll");
            this._imgNotifyOmitNoKeyAll.Name = "_imgNotifyOmitNoKeyAll";
            this._imgNotifyOmitNoKeyAll.TabStop = false;
            this._ttpMain.SetToolTip(this._imgNotifyOmitNoKeyAll, resources.GetString("_imgNotifyOmitNoKeyAll.ToolTip"));
            //
            // _chkOmitNoKeyAll
            //
            resources.ApplyResources(this._chkOmitNoKeyAll, "_chkOmitNoKeyAll");
            this._chkOmitNoKeyAll.Name = "_chkOmitNoKeyAll";
            this._chkOmitNoKeyAll.UseVisualStyleBackColor = true;
            //
            // _cmbTarget
            //
            this._cmbTarget.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this._cmbTarget.FormattingEnabled = true;
            this._cmbTarget.Items.AddRange(new object[] {
            resources.GetString("_cmbTarget.Items"),
            resources.GetString("_cmbTarget.Items1"),
            resources.GetString("_cmbTarget.Items2")});
            resources.ApplyResources(this._cmbTarget, "_cmbTarget");
            this._cmbTarget.Name = "_cmbTarget";
            //
            // _chkConvertTextboxControlCode
            //
            resources.ApplyResources(this._chkConvertTextboxControlCode, "_chkConvertTextboxControlCode");
            this._chkConvertTextboxControlCode.Name = "_chkConvertTextboxControlCode";
            this._chkConvertTextboxControlCode.UseVisualStyleBackColor = true;
            //
            // _chkDrawHiddenPanesAsNull
            //
            resources.ApplyResources(this._chkDrawHiddenPanesAsNull, "_chkDrawHiddenPanesAsNull");
            this._chkDrawHiddenPanesAsNull.Name = "_chkDrawHiddenPanesAsNull";
            this._chkDrawHiddenPanesAsNull.UseVisualStyleBackColor = true;
            //
            // _lblTarget
            //
            resources.ApplyResources(this._lblTarget, "_lblTarget");
            this._lblTarget.Name = "_lblTarget";
            //
            // _grpRenderingMode
            //
            this._grpRenderingMode.Controls.Add(this._radGDIMode);
            this._grpRenderingMode.Controls.Add(this._radDirectXMode);
            resources.ApplyResources(this._grpRenderingMode, "_grpRenderingMode");
            this._grpRenderingMode.Name = "_grpRenderingMode";
            this._grpRenderingMode.TabStop = false;
            //
            // _radGDIMode
            //
            this._radGDIMode.Checked = true;
            resources.ApplyResources(this._radGDIMode, "_radGDIMode");
            this._radGDIMode.Name = "_radGDIMode";
            this._radGDIMode.TabStop = true;
            //
            // _radDirectXMode
            //
            this._radDirectXMode.Checked = true;
            resources.ApplyResources(this._radDirectXMode, "_radDirectXMode");
            this._radDirectXMode.Name = "_radDirectXMode";
            this._radDirectXMode.TabStop = true;
            //
            // _grpPane
            //
            this._grpPane.Controls.Add(this._chkConveyTransparency);
            resources.ApplyResources(this._grpPane, "_grpPane");
            this._grpPane.Name = "_grpPane";
            this._grpPane.TabStop = false;
            //
            // _chkConveyTransparency
            //
            resources.ApplyResources(this._chkConveyTransparency, "_chkConveyTransparency");
            this._chkConveyTransparency.Name = "_chkConveyTransparency";
            this._chkConveyTransparency.UseVisualStyleBackColor = true;
            //
            // _grpGamma
            //
            this._grpGamma.Controls.Add(this._imgNotifyGammaTex);
            this._grpGamma.Controls.Add(this._chkGammaSRGBFetch);
            this._grpGamma.Controls.Add(this._chkGammaSRGBWrite);
            this._grpGamma.Controls.Add(this._imgNotifyGamma);
            this._grpGamma.Controls.Add(this._imgNotifyGammaColor);
            this._grpGamma.Controls.Add(this._chkGammaColorParams);
            this._grpGamma.Controls.Add(this._chkGamma);
            resources.ApplyResources(this._grpGamma, "_grpGamma");
            this._grpGamma.Name = "_grpGamma";
            this._grpGamma.TabStop = false;
            //
            // _imgNotifyGammaTex
            //
            resources.ApplyResources(this._imgNotifyGammaTex, "_imgNotifyGammaTex");
            this._imgNotifyGammaTex.Name = "_imgNotifyGammaTex";
            this._imgNotifyGammaTex.TabStop = false;
            this._ttpMain.SetToolTip(this._imgNotifyGammaTex, resources.GetString("_imgNotifyGammaTex.ToolTip"));
            //
            // _chkGammaSRGBFetch
            //
            resources.ApplyResources(this._chkGammaSRGBFetch, "_chkGammaSRGBFetch");
            this._chkGammaSRGBFetch.Name = "_chkGammaSRGBFetch";
            this._chkGammaSRGBFetch.UseVisualStyleBackColor = true;
            //
            // _chkGammaSRGBWrite
            //
            resources.ApplyResources(this._chkGammaSRGBWrite, "_chkGammaSRGBWrite");
            this._chkGammaSRGBWrite.Name = "_chkGammaSRGBWrite";
            this._chkGammaSRGBWrite.UseVisualStyleBackColor = true;
            //
            // _imgNotifyGamma
            //
            resources.ApplyResources(this._imgNotifyGamma, "_imgNotifyGamma");
            this._imgNotifyGamma.Name = "_imgNotifyGamma";
            this._imgNotifyGamma.TabStop = false;
            this._ttpMain.SetToolTip(this._imgNotifyGamma, resources.GetString("_imgNotifyGamma.ToolTip"));
            //
            // _imgNotifyGammaColor
            //
            resources.ApplyResources(this._imgNotifyGammaColor, "_imgNotifyGammaColor");
            this._imgNotifyGammaColor.Name = "_imgNotifyGammaColor";
            this._imgNotifyGammaColor.TabStop = false;
            this._ttpMain.SetToolTip(this._imgNotifyGammaColor, resources.GetString("_imgNotifyGammaColor.ToolTip"));
            //
            // _chkGammaColorParams
            //
            resources.ApplyResources(this._chkGammaColorParams, "_chkGammaColorParams");
            this._chkGammaColorParams.Name = "_chkGammaColorParams";
            this._chkGammaColorParams.UseVisualStyleBackColor = true;
            //
            // _chkGamma
            //
            resources.ApplyResources(this._chkGamma, "_chkGamma");
            this._chkGamma.Name = "_chkGamma";
            this._chkGamma.UseVisualStyleBackColor = true;
            this._chkGamma.CheckedChanged += new System.EventHandler(this.Event_chkGamma_CheckedChanged);
            //
            // _ttpMain
            //
            this._ttpMain.AutoPopDelay = 15000;
            this._ttpMain.InitialDelay = 500;
            this._ttpMain.ReshowDelay = 100;
            //
            // _imgNotifyPers
            //
            resources.ApplyResources(this._imgNotifyPers, "_imgNotifyPers");
            this._imgNotifyPers.Name = "_imgNotifyPers";
            this._imgNotifyPers.TabStop = false;
            this._ttpMain.SetToolTip(this._imgNotifyPers, resources.GetString("_imgNotifyPers.ToolTip"));
            //
            // _chkDepthWriteTestEnabled
            //
            resources.ApplyResources(this._chkDepthWriteTestEnabled, "_chkDepthWriteTestEnabled");
            this._chkDepthWriteTestEnabled.Name = "_chkDepthWriteTestEnabled";
            this._ttpMain.SetToolTip(this._chkDepthWriteTestEnabled, resources.GetString("_chkDepthWriteTestEnabled.ToolTip"));
            this._chkDepthWriteTestEnabled.UseVisualStyleBackColor = true;
            //
            // _imgNotifyFrameRate
            //
            resources.ApplyResources(this._imgNotifyFrameRate, "_imgNotifyFrameRate");
            this._imgNotifyFrameRate.Name = "_imgNotifyFrameRate";
            this._imgNotifyFrameRate.TabStop = false;
            this._ttpMain.SetToolTip(this._imgNotifyFrameRate, resources.GetString("_imgNotifyFrameRate.ToolTip"));
            //
            // _grpPerspective
            //
            this._grpPerspective.Controls.Add(this._chkIsPerspectiveDefault);
            this._grpPerspective.Controls.Add(this._imgNotifyPers);
            this._grpPerspective.Controls.Add(this._tbxFar);
            this._grpPerspective.Controls.Add(this._tbxNear);
            this._grpPerspective.Controls.Add(this._tbxFOV);
            this._grpPerspective.Controls.Add(this._chkDepthWriteTestEnabled);
            this._grpPerspective.Controls.Add(this._lblFar);
            this._grpPerspective.Controls.Add(this._lblNear);
            this._grpPerspective.Controls.Add(this._lblFOV);
            resources.ApplyResources(this._grpPerspective, "_grpPerspective");
            this._grpPerspective.Name = "_grpPerspective";
            this._grpPerspective.TabStop = false;
            //
            // _chkIsPerspectiveDefault
            //
            resources.ApplyResources(this._chkIsPerspectiveDefault, "_chkIsPerspectiveDefault");
            this._chkIsPerspectiveDefault.Name = "_chkIsPerspectiveDefault";
            this._chkIsPerspectiveDefault.UseVisualStyleBackColor = true;
            //
            // _tbxFar
            //
            this._tbxFar.Format = "f2";
            resources.ApplyResources(this._tbxFar, "_tbxFar");
            this._tbxFar.Name = "_tbxFar";
            //
            // _tbxNear
            //
            this._tbxNear.Format = "f2";
            resources.ApplyResources(this._tbxNear, "_tbxNear");
            this._tbxNear.Name = "_tbxNear";
            //
            // _tbxFOV
            //
            this._tbxFOV.Format = "f2";
            resources.ApplyResources(this._tbxFOV, "_tbxFOV");
            this._tbxFOV.Name = "_tbxFOV";
            //
            // _lblFar
            //
            resources.ApplyResources(this._lblFar, "_lblFar");
            this._lblFar.Name = "_lblFar";
            //
            // _lblNear
            //
            resources.ApplyResources(this._lblNear, "_lblNear");
            this._lblNear.Name = "_lblNear";
            //
            // _lblFOV
            //
            resources.ApplyResources(this._lblFOV, "_lblFOV");
            this._lblFOV.Name = "_lblFOV";
            //
            // _grpFrameRate
            //
            this._grpFrameRate.Controls.Add(this._imgNotifyFrameRate);
            this._grpFrameRate.Controls.Add(this._chkIs30Fps);
            resources.ApplyResources(this._grpFrameRate, "_grpFrameRate");
            this._grpFrameRate.Name = "_grpFrameRate";
            this._grpFrameRate.TabStop = false;
            //
            // _chkIs30Fps
            //
            resources.ApplyResources(this._chkIs30Fps, "_chkIs30Fps");
            this._chkIs30Fps.Name = "_chkIs30Fps";
            this._chkIs30Fps.UseVisualStyleBackColor = true;
            //
            // _grpWarningWindow
            //
            this._grpWarningWindow.Controls.Add(this._chkAllDispWarningWindow);
            resources.ApplyResources(this._grpWarningWindow, "_grpWarningWindow");
            this._grpWarningWindow.Name = "_grpWarningWindow";
            this._grpWarningWindow.TabStop = false;
            //
            // _chkAllDispWarningWindow
            //
            resources.ApplyResources(this._chkAllDispWarningWindow, "_chkAllDispWarningWindow");
            this._chkAllDispWarningWindow.Name = "_chkAllDispWarningWindow";
            this._chkAllDispWarningWindow.UseVisualStyleBackColor = true;
            //
            // _grpHierarchyWindow
            //
            this._grpHierarchyWindow.Controls.Add(this._chkHierarchyWindowPaneControl);
            resources.ApplyResources(this._grpHierarchyWindow, "_grpHierarchyWindow");
            this._grpHierarchyWindow.Name = "_grpHierarchyWindow";
            this._grpHierarchyWindow.TabStop = false;
            //
            // _chkHierarchyWindowPaneControl
            //
            resources.ApplyResources(this._chkHierarchyWindowPaneControl, "_chkHierarchyWindowPaneControl");
            this._chkHierarchyWindowPaneControl.Name = "_chkHierarchyWindowPaneControl";
            this._chkHierarchyWindowPaneControl.UseVisualStyleBackColor = true;
            //
            // EnviromentSettingDlg
            //
            resources.ApplyResources(this, "$this");
            this.Controls.Add(this._grpHierarchyWindow);
            this.Controls.Add(this._grpWarningWindow);
            this.Controls.Add(this._grpFrameRate);
            this.Controls.Add(this._grpPerspective);
            this.Controls.Add(this._grpGamma);
            this.Controls.Add(this._grpPane);
            this.Controls.Add(this._grpRenderingMode);
            this.Controls.Add(this._grpPreview);
            this.Controls.Add(this.groupBox1);
            this.Controls.Add(this._btnOK);
            this.Controls.Add(this._btnCancel);
            this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
            this.MaximizeBox = false;
            this.MinimizeBox = false;
            this.Name = "EnviromentSettingDlg";
            this.VisibleChanged += new System.EventHandler(this.EnviromentSettingDlg_VisibleChanged);
            this.groupBox1.ResumeLayout(false);
            this.groupBox1.PerformLayout();
            this._grpPreview.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this._imgNotifyOmitNoKeyAll)).EndInit();
            this._grpRenderingMode.ResumeLayout(false);
            this._grpPane.ResumeLayout(false);
            this._grpGamma.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this._imgNotifyGammaTex)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this._imgNotifyGamma)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this._imgNotifyGammaColor)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this._imgNotifyPers)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this._imgNotifyFrameRate)).EndInit();
            this._grpPerspective.ResumeLayout(false);
            this._grpPerspective.PerformLayout();
            this._grpFrameRate.ResumeLayout(false);
            this._grpWarningWindow.ResumeLayout(false);
            this._grpHierarchyWindow.ResumeLayout(false);
            this.ResumeLayout(false);

        }
        #endregion デザイナコード


       #region フィールド
        AppSetting _targetAppSetting = new AppSetting();
       #endregion フィールド


        #region プロパティ
        /// <summary>
        /// 操作対象を設定します。
        /// </summary>
        public AppSetting AppSetting
        {
            set
            {
                _targetAppSetting = value;
            }
        }
        #endregion プロパティ

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public EnviromentSettingDlg()
        {
            InitializeComponent();

            // 描画モード
            _radGDIMode.Tag = RendererType.GDI;
            _radDirectXMode.Tag = RendererType.D3D;
        }

        /// <summary>
        /// GUIの状態を操作対象に設定します。
        /// </summary>
        public void CopyParamaters()
        {
            // 安全フレーム関連の設定
            SafeFrame safeFrame =
                new SafeFrame( Convert.ToInt32( _tbxSafeFrameL.Text ),
                               Convert.ToInt32( _tbxSafeFrameR.Text ),
                               Convert.ToInt32( _tbxSafeFrameT.Text ),
                               Convert.ToInt32( _tbxSafeFrameB.Text ),
                               _chkDrawSafeFrame.Checked,
                               _ctlSafeFrameColor.Color.ToSystemColor() );
            _targetAppSetting.SafeFrame = safeFrame;

            // 座標系の設定
            if( _radGDIMode.Checked )
            {
                _targetAppSetting.RendererKind = (AppSetting.RendererType)_radGDIMode.Tag;
            }

            if( _radDirectXMode.Checked )
            {
                _targetAppSetting.RendererKind = (AppSetting.RendererType)_radDirectXMode.Tag;
            }

            // プレビュー関連
            _targetAppSetting.DrawHiddenPanesAsNull = _chkDrawHiddenPanesAsNull.Checked;
            _targetAppSetting.ConvertTextboxControlCode = _chkConvertTextboxControlCode.Checked;
            _targetAppSetting.TargetScreenKind = TargetScreen;
            _targetAppSetting.ProjectSettings.PreviewConverterOptionOmitNoKeyAllEnabled = _chkOmitNoKeyAll.Checked;

            // パースペクティブ関係
            _targetAppSetting.ProjectSettings.PerspectiveFOV = _tbxFOV.Value;
            _targetAppSetting.ProjectSettings.PerspectiveNear = _tbxNear.Value;
            _targetAppSetting.ProjectSettings.PerspectiveFar = _tbxFar.Value;
            _targetAppSetting.ProjectSettings.IsPerspectiveDefault = _chkIsPerspectiveDefault.Checked;
            _targetAppSetting.ProjectSettings.DepthTestEnabled = _chkDepthWriteTestEnabled.Checked;

            _targetAppSetting.ProjectSettings.Is30Fps = _chkIs30Fps.Checked;

            // ペイン関連
            _targetAppSetting.ConveyTransparencyInfluenceOfNull = _chkConveyTransparency.Checked;

            // ガンマ関係
            _targetAppSetting.ProjectSettings.SRGBWriteEnabled = _chkGammaSRGBWrite.Checked;
            _targetAppSetting.ProjectSettings.DegammaTextureConversionEnabled = _chkGamma.Checked;
            _targetAppSetting.ProjectSettings.DegammaParameterConversionEnabled = !_chkGammaColorParams.Checked;

            // 警告ウインドウ
            if (_chkAllDispWarningWindow.Checked)
                _targetAppSetting.IgnoreSimilarMessage.Remove(MessageReportDlg.MessageTypes.AnimConvert);
            else
                _targetAppSetting.IgnoreSimilarMessage.Add(MessageReportDlg.MessageTypes.AnimConvert);

            // 親子階層ウインドウ
            _targetAppSetting.HierarchyWindowPaneControl = _chkHierarchyWindowPaneControl.Checked;

            _targetAppSetting.RaiseModifyEvent();
        }

        /// <summary>
        ///
        /// </summary>
        private AppSetting.TargetScreen TargetScreen
        {
            get
            {
                switch( _cmbTarget.SelectedIndex )
                {
                case 0: return AppSetting.TargetScreen.Auto;
                case 1: return AppSetting.TargetScreen.Upper;
                case 2: return AppSetting.TargetScreen.Lower;
                }
                Debug.Assert( false);
                return AppSetting.TargetScreen.Upper;
            }
            set
            {
                switch (value)
                {
                    case AppSetting.TargetScreen.Auto: _cmbTarget.SelectedIndex = 0; break;
                    case AppSetting.TargetScreen.Upper: _cmbTarget.SelectedIndex = 1; break;
                    case AppSetting.TargetScreen.Lower: _cmbTarget.SelectedIndex = 2; break;
                    default: Debug.Assert(false); break;
                }
            }
        }

        #region イベントハンドラ

        /// <summary>
        /// 表示状態変更ハンドラ
        /// 表示時には、操作対象の状態をGUIに設定します。
        /// </summary>
        private void EnviromentSettingDlg_VisibleChanged( object sender, System.EventArgs e )
        {
            if( this.Visible )
            {
                // 安全フレームについて
                SafeFrame sf = _targetAppSetting.SafeFrame;

                _tbxSafeFrameL.Tag = sf.LeftWidth;
                _tbxSafeFrameR.Tag = sf.RightWidth;
                _tbxSafeFrameT.Tag = sf.TopWidth;
                _tbxSafeFrameB.Tag = sf.BottomWidth;

                _tbxSafeFrameL.Text = sf.LeftWidth.ToString();
                _tbxSafeFrameR.Text = sf.RightWidth.ToString();
                _tbxSafeFrameT.Text = sf.TopWidth.ToString();
                _tbxSafeFrameB.Text = sf.BottomWidth.ToString();

                _chkDrawSafeFrame.Checked = sf.Visible;

                _ctlSafeFrameColor.Color = new FloatColor(_targetAppSetting.SafeFrame.RGBAColor.AsColor);

                // プレビューについて
                _chkDrawHiddenPanesAsNull.Checked = _targetAppSetting.DrawHiddenPanesAsNull;
                _chkConvertTextboxControlCode.Checked = _targetAppSetting.ConvertTextboxControlCode;
                _chkOmitNoKeyAll.Checked = _targetAppSetting.ProjectSettings.PreviewConverterOptionOmitNoKeyAllEnabled;

                TargetScreen = _targetAppSetting.TargetScreenKind;

                _cmbTarget.Visible = LayoutEditorCore.PlatformDetail.MultiScreenEnabled;
                _lblTarget.Visible = _cmbTarget.Visible;

                // 描画モードについて
                _radGDIMode.Enabled = false;
                _radDirectXMode.Enabled = _targetAppSetting.IsAvailableRrendererType( (AppSetting.RendererType)_radDirectXMode.Tag );
                _radGDIMode.SetCheckedByTag( _targetAppSetting.RendererKind );
                _radDirectXMode.SetCheckedByTag( _targetAppSetting.RendererKind );

                // パースぺクティブ関係
                _tbxFOV.SetValue(_targetAppSetting.ProjectSettings.PerspectiveFOV);
                _tbxNear.SetValue(_targetAppSetting.ProjectSettings.PerspectiveNear);
                _tbxFar.SetValue(_targetAppSetting.ProjectSettings.PerspectiveFar);
                _chkIsPerspectiveDefault.Checked = _targetAppSetting.ProjectSettings.IsPerspectiveDefault;
                _chkDepthWriteTestEnabled.Checked = _targetAppSetting.ProjectSettings.DepthTestEnabled;

                _chkIs30Fps.Checked = _targetAppSetting.ProjectSettings.Is30Fps;

                // ペイン関連
                _chkConveyTransparency.Checked = _targetAppSetting.ConveyTransparencyInfluenceOfNull;

                // ガンマ関係
                _chkGamma.Checked = _targetAppSetting.ProjectSettings.DegammaTextureConversionEnabled;
                _chkGammaSRGBFetch.Checked = _targetAppSetting.ProjectSettings.DegammaTextureConversionEnabled;
                _chkGammaSRGBWrite.Checked = _targetAppSetting.ProjectSettings.SRGBWriteEnabled;

                _chkGammaColorParams.Checked = !_targetAppSetting.ProjectSettings.DegammaParameterConversionEnabled;
                _chkGammaColorParams.Enabled = _targetAppSetting.ProjectSettings.DegammaTextureConversionEnabled;

                // 警告ウインドウ
                _chkAllDispWarningWindow.Checked = !_targetAppSetting.IgnoreSimilarMessage.Contains(MessageReportDlg.MessageTypes.AnimConvert);

                // 親子階層ウインドウ
                _chkHierarchyWindowPaneControl.Checked = _targetAppSetting.HierarchyWindowPaneControl;
            }
        }

        /// <summary>
        /// OKボタンハンドラ
        /// </summary>
        private void Event_BtnOK_Click( object sender, System.EventArgs e )
        {
            DialogResult = DialogResult.OK;
        }

        /// <summary>
        /// キャンセルボタンハンドラ
        /// </summary>
        private void Event_BtnCancel_Click( object sender, System.EventArgs e )
        {
            DialogResult = DialogResult.Cancel;
        }


        /// <summary>
        /// テキストボックスの文字列を妥当性をたもって更新します。
        /// </summary>
        void UpdateTextBox_( TextBox tb )
        {
            try
            {
                int intVal = Convert.ToInt32( tb.Text );
                // 有効な値をTagに格納します。
                tb.Tag = intVal;
            }
            catch
            {
                // 変換に失敗した場合、最後に有効だった値に戻します。
                int lastValidValue = (int)tb.Tag;
                tb.Text = lastValidValue.ToString();
            }
        }

        /// <summary>
        /// 安全フレームテキストボックス検証ハンドラ
        /// </summary>
        private void Event_TbxSafeFrame_Validating( object sender, System.ComponentModel.CancelEventArgs e )
        {
            UpdateTextBox_( sender as TextBox );
        }

        /// <summary>
        /// 安全フレームテキストボックス・キーダウン・ハンドラ
        /// </summary>
        private void Event_TbxSafeFrame_KeyDown( object sender, System.Windows.Forms.KeyEventArgs e )
        {
            if( e.KeyCode == Keys.Enter )
            {
                UpdateTextBox_( sender as TextBox );
            }
        }

        /// <summary>
        /// リニア色空間チェック変更
        /// </summary>
        private void Event_chkGamma_CheckedChanged(object sender, EventArgs e)
        {
            if(_chkGamma.Checked)
            {
                _chkGammaColorParams.Checked = _chkGamma.Checked;
            }
            else
            {
                // 非リニア色空間モード時は、必ず ON にする(つまり、--degamma-parameter ガンマ変換をOFFにする)。
                _chkGammaColorParams.Checked = true;
            }

            _chkGammaColorParams.Enabled = _chkGamma.Checked;
            _chkGammaSRGBFetch.Checked = _chkGamma.Checked;
            _chkGammaSRGBWrite.Checked = _chkGamma.Checked;
        }

        #endregion イベントハンドラ
    }
}
