﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;

namespace LayoutEditor.Controls
{
    /// <summary>
    /// 整数値エディットスライダクラス。
    /// </summary>
    [ToolboxBitmap(typeof(UserControl))]
    [DefaultProperty("Value")]
    [DefaultEvent("ValueEdit")]
    public sealed class IntEditSlider : EditSlider
    {
        #region デザイナ変数

        private LayoutEditor.Controls.IntTextBox tbxValue;
        private LayoutEditor.Controls.IntTrackBar trbValue;
        private System.Windows.Forms.Label labMin;
        private System.Windows.Forms.Label labMax;
        private System.ComponentModel.Container components = null;
        #endregion

        #region デザイナコード
        /// <summary>
        /// デザイナ サポートに必要なメソッドです。このメソッドの内容を
        /// コード エディタで変更しないでください。
        /// </summary>
        private void InitializeComponent()
        {
            this.tbxValue = new LayoutEditor.Controls.IntTextBox();
            this.trbValue = new LayoutEditor.Controls.IntTrackBar();
            this.labMin = new System.Windows.Forms.Label();
            this.labMax = new System.Windows.Forms.Label();
            ((System.ComponentModel.ISupportInitialize)(this.trbValue)).BeginInit();
            this.SuspendLayout();
            //
            // tbxValue
            //
            this.tbxValue.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
            this.tbxValue.Location = new System.Drawing.Point(0, 17);
            this.tbxValue.Name = "tbxValue";
            this.tbxValue.Size = new System.Drawing.Size(64, 21);
            this.tbxValue.TabIndex = 0;
            this.tbxValue.Text = "0";
            //
            // trbValue
            //
            this.trbValue.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)
                | System.Windows.Forms.AnchorStyles.Right)));
            this.trbValue.Location = new System.Drawing.Point(72, 16);
            this.trbValue.Name = "trbValue";
            this.trbValue.Size = new System.Drawing.Size(168, 24);
            this.trbValue.TabIndex = 3;
            //
            // labMin
            //
            this.labMin.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
            this.labMin.Location = new System.Drawing.Point(72, 0);
            this.labMin.Name = "labMin";
            this.labMin.Size = new System.Drawing.Size(64, 16);
            this.labMin.TabIndex = 1;
            this.labMin.Text = "min";
            //
            // labMax
            //
            this.labMax.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.labMax.Location = new System.Drawing.Point(176, 0);
            this.labMax.Name = "labMax";
            this.labMax.Size = new System.Drawing.Size(64, 16);
            this.labMax.TabIndex = 2;
            this.labMax.Text = "max";
            this.labMax.TextAlign = System.Drawing.ContentAlignment.TopRight;
            //
            // IntEditSlider
            //
            this.Controls.Add(this.labMax);
            this.Controls.Add(this.labMin);
            this.Controls.Add(this.trbValue);
            this.Controls.Add(this.tbxValue);
            this.Name = "IntEditSlider";
            ((System.ComponentModel.ISupportInitialize)(this.trbValue)).EndInit();
            this.ResumeLayout(false);

        }
        #endregion

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public IntEditSlider()
        {
            InitializeComponent();

            // 初期設定
            trbValue.Minimum = tbxValue.MinValue;
            trbValue.Maximum = tbxValue.MaxValue;
            trbValue.SetValue(tbxValue.Value);
            labMin.Text = tbxValue.MinValue.ToString();
            labMax.Text = tbxValue.MaxValue.ToString();

            // イベント登録
            tbxValue.ValueChanged += new EventHandler(Event_TbxValue_ValueChanged);
            trbValue.ScrollChanged += new ScrollChangedEventHandler(Event_TrbValue_ScrollChanged);
        }

        /// <summary>
        /// 最小値。
        /// </summary>
        [DefaultValue(IntTextBox._defMinValue)]
        [Description("最小値。")]
        public int MinValue
        {
            get { return tbxValue.MinValue; }
            set
            {
                tbxValue.MinValue = value;
                trbValue.Minimum  = value;
                labMin.Text       = value.ToString();
            }
        }

        /// <summary>
        /// 最大値。
        /// </summary>
        [DefaultValue(IntTextBox._defMaxValue)]
        [Description("最大値。")]
        public int MaxValue
        {
            get { return tbxValue.MaxValue; }
            set
            {
                tbxValue.MaxValue = value;
                trbValue.Maximum  = value;
                labMax.Text       = value.ToString();
            }
        }

        /// <summary>
        /// 値。
        /// </summary>
        [DefaultValue(IntTextBox._defValue)]
        [Description("値。")]
        public int Value
        {
            get { return tbxValue.Value; }
            set
            {
                tbxValue.Value = value;
            }
        }

        /// <summary>
        /// テキストボックスサイズ。
        /// </summary>
        [DefaultValue(EditSlider._defTextBoxSize)]
        [Description("テキストボックスサイズ。")]
        public EditSliderTextBoxSize TextBoxSize
        {
            get { return _textBoxSize; }
            set
            {
                if (_textBoxSize != value)
                {
                    int delta = (int)value - (int)_textBoxSize;
                    _textBoxSize = value;

                    // レイアウト変更
                    tbxValue.Width += delta;
                    trbValue.Width -= delta;
                    trbValue.Left  += delta;
                    labMin.Left    += delta;
                }
            }
        }

        /// <summary>
        /// テキストボックスマージン。
        /// </summary>
        [DefaultValue(EditSlider._defTextBoxMargin)]
        [Description("テキストボックスマージン。")]
        public EditSliderTextBoxMargin TextBoxMargin
        {
            get { return _textBoxMargin; }
            set
            {
                if (_textBoxMargin != value)
                {
                    int delta = (int)value - (int)_textBoxMargin;
                    _textBoxMargin = value;

                    // レイアウト変更
                    trbValue.Width -= delta;
                    trbValue.Left  += delta;
                    labMin.Left    += delta;
                }
            }
        }

        /// <summary>
        /// テキストボックスのテキスト整列。
        /// </summary>
        [DefaultValue(HorizontalAlignment.Left)]
        [Description("テキストボックスのテキスト整列。")]
        public HorizontalAlignment TextBoxTextAlign
        {
            get { return tbxValue.TextAlign;  }
            set { tbxValue.TextAlign = value; }
        }

        /// <summary>
        /// トラックバーの小変化量。
        /// </summary>
        [DefaultValue(IntTrackBar._defSmallChange)]
        [Description("トラックバーの小変化量。")]
        public int TrackBarSmallChange
        {
            get { return trbValue.SmallChange;  }
            set { trbValue.SmallChange = value; }
        }

        /// <summary>
        /// トラックバーの大変化量。
        /// </summary>
        [DefaultValue(IntTrackBar._defLargeChange)]
        [Description("トラックバーの大変化量。")]
        public int TrackBarLargeChange
        {
            get { return trbValue.LargeChange;  }
            set { trbValue.LargeChange = value; }
        }

        /// <summary>
        /// 範囲ラベルの可視。
        /// </summary>
        [DefaultValue(true)]
        [Description("範囲ラベルの可視。")]
        public bool ShowRangeLabel
        {
            get { return _showRangeLabel; }
            set
            {
                if (_showRangeLabel != value)
                {
                    _showRangeLabel = value;

                    labMin.Visible = _showRangeLabel;
                    labMax.Visible = _showRangeLabel;
                }
            }
        }

        /// <summary>
        /// Valueプロパティ設定。
        /// </summary>
        public void SetValue(int val)
        {
            tbxValue.SetValue(val);
            trbValue.SetValue(val);
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                if (components != null)
                {
                    components.Dispose();
                }
            }
            base.Dispose(disposing);
        }

        /// <summary>
        /// イベントハンドラ。
        /// </summary>
        private void Event_TbxValue_ValueChanged(object sender, EventArgs e)
        {
            // スライダに通知
            trbValue.SetValue(tbxValue.Value);

            // イベント発行
            OnValueEdit(new ValueEditEventArgs(true));
        }

        /// <summary>
        /// イベントハンドラ。
        /// </summary>
        private void Event_TrbValue_ScrollChanged(object sender, ScrollChangedEventArgs e)
        {
            // テキストボックスに通知
            tbxValue.SetValue(trbValue.Value);

            // イベント発行
            OnValueEdit(new ValueEditEventArgs(e.EndScroll));
        }
    }
}
