﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Drawing;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using WeifenLuo.WinFormsUI.Docking;

namespace LayoutEditor.Controls
{
    /// <summary>
    /// DockPanel Suite の FloatWindow を LayoutEditor 用にカスタマイズしたもの
    /// </summary>
    internal class CustomizedFloatWindow : FloatWindow
    {
        static IntPtr SetBoundsCorePtr = typeof(Form).GetMethod("SetBoundsCore", BindingFlags.Instance | BindingFlags.NonPublic).MethodHandle.GetFunctionPointer();

        private delegate void SetBoundsCoreDelegate(int x, int y, int width, int height, System.Windows.Forms.BoundsSpecified specified);

        // FloatWindow を経由せずに Form.SetBoundsCore を呼ぶ
        private SetBoundsCoreDelegate FormSetBoundsCore;

        internal protected CustomizedFloatWindow(WeifenLuo.WinFormsUI.Docking.DockPanel dockPanel, DockPane pane)
            : base(dockPanel, pane)
        {
        }

        internal protected CustomizedFloatWindow(WeifenLuo.WinFormsUI.Docking.DockPanel dockPanel, DockPane pane, System.Drawing.Rectangle bounds)
            : base(dockPanel, pane, bounds)
        {
        }

        protected override void SetBoundsCore(int x, int y, int width, int height, System.Windows.Forms.BoundsSpecified specified)
        {
            System.Drawing.Rectangle rectWorkArea = SystemInformation.VirtualScreen;

            // デスクトップの下にはみ出すのはとめない
#if false
            if (y + height > rectWorkArea.Bottom)
                y -= (y + height) - rectWorkArea.Bottom;
#endif

            if (y < rectWorkArea.Top)
                y += rectWorkArea.Top - y;

            // FloatWindow の SetBoundsCore は呼び出さない
#if false
            base.SetBoundsCore(x, y, width, height, specified);
#else
            if (FormSetBoundsCore == null)
            {
                FormSetBoundsCore = (SetBoundsCoreDelegate)Activator.CreateInstance(typeof(SetBoundsCoreDelegate), this, SetBoundsCorePtr);
                Debug.Assert(FormSetBoundsCore != null);
            }
            FormSetBoundsCore(x, y, width, height, specified);
#endif
        }
    }

    internal class CustomizedFloatWindowFactory : WeifenLuo.WinFormsUI.Docking.DockPanelExtender.IFloatWindowFactory
    {
        public FloatWindow CreateFloatWindow(WeifenLuo.WinFormsUI.Docking.DockPanel dockPanel, DockPane pane)
        {
            return new CustomizedFloatWindow(dockPanel, pane);
        }

        public FloatWindow CreateFloatWindow(WeifenLuo.WinFormsUI.Docking.DockPanel dockPanel, DockPane pane, Rectangle bounds)
        {
            return new CustomizedFloatWindow(dockPanel, pane, bounds);
        }
    }
}
