﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.ComponentModel;
using System.Collections;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Windows.Forms;
using System.Windows.Forms.Design;

namespace LayoutEditor.Controls
{
    using Win32 = LECore.Win32;
    /// <summary>
    /// ボーダーパネルクラス。
    /// </summary>
    [ToolboxBitmap(typeof(Panel))]
    [Designer(typeof(BorderPanel.CustomDesigner))]
    public class BorderPanel : Panel
    {
        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public BorderPanel()
        {
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override CreateParams CreateParams
        {
            get
            {
                CreateParams cp = base.CreateParams;
                return cp;
            }
        }

        #region CustomDesigner
        /// <summary>
        /// カスタムデザイナクラス。
        /// </summary>
        internal class CustomDesigner : ControlDesigner
        {
            /// <summary>
            /// オーバーライド。
            /// </summary>
            protected override void PostFilterProperties(IDictionary properties)
            {
                properties.Remove("BorderStyle");

                base.PostFilterProperties(properties);
            }
        }
        #endregion

        private void InitializeComponent()
        {
            this.SuspendLayout();
            this.ResumeLayout( false );

        }
    }
}
