﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using LECore.Structures.Core;
using System.Diagnostics;
using LayoutEditor.Forms.ToolWindows;

namespace LayoutEditor.src.Controls
{
    public partial class AnimationMarkCheckBox : UserControl
        , IAnimationMarkUsable
    {
        #region イベントハンドラ

        public event EventHandler CheckedChanged
        {
            add { _chkCheckBox.CheckedChanged += value; }
            remove { _chkCheckBox.CheckedChanged -= value; }
        }

        #endregion

        #region フィールド

        private bool _useAnimationMark = false;
        private src.Controls.AnimationMark _pnlMark;
        private src.Controls.BindAnimationCheckBox _chkCheckBox;

        /// <summary>
        /// 必要なデザイナー変数です。
        /// </summary>
        private System.ComponentModel.IContainer components = null;

        #endregion

        #region プロパティ

        /// <summary>
        /// チェックボックス。
        /// </summary>
        public bool Checked
        {
            get { return _chkCheckBox.Checked; }
            set {
                _chkCheckBox.Checked = value;
            }
        }

        /// <summary>
        /// テキスト。
        /// </summary>
        [Localizable(true)]
        public string CheckBoxText
        {
            get { return _chkCheckBox.Text; }
            set { _chkCheckBox.Text = value; }
        }

        /// <summary>
        /// 背景色。
        /// </summary>
        public Color CheckBoxBackColor
        {
            get { return _chkCheckBox.BackColor; }
            set { _chkCheckBox.BackColor = value; }
        }

        #endregion

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public AnimationMarkCheckBox()
        {
            InitializeComponent();

            // AnimationMarkの持つコンテキストメニューを関連付けます
            _chkCheckBox.BindAnimationMark(_pnlMark);
        }

        /// <summary>
        /// ViewManagerへのメッセージハンドラを設定します。
        /// </summary>
        public void SetViewManagerMessageHandler(Action<ViewManagerMessage> handler)
        {
            _pnlMark.SendMessageToViewManager = handler;
        }

        /// <summary>
        /// コンテキストメニューを追加します。
        /// </summary>
        public void RegistContextMenu(string name, Image image, EventHandler handler)
        {
            _pnlMark.RegistContextMenu(name, image, handler);
        }

        /// <summary>
        /// 操作対象のアトリビュートを設定します
        /// </summary>
        public void SetTargetAttribute(IAnmAttribute attr)
        {
            Debug.Assert(attr.NumSubAttribute == 0);

            _pnlMark.SetTargetAttribute(attr);
        }
        public void SetTargetAttribute(IAnmAttribute[] attrs)
        {
            _pnlMark.ClearTargetAttribute();

            foreach (IAnmAttribute attr in attrs)
            {
                Debug.Assert(attr.NumSubAttribute == 0);

                _pnlMark.AddTargetAttribute(attr);
            }
        }

        /// <summary>
        /// アニメーションマークの色を更新します
        /// </summary>
        public void UpdateMarkColor()
        {
            _pnlMark.UpdateMarkColor();
        }

        /// <summary>
        /// コンテキストメニューを更新します
        /// </summary>
        public void UpdateContextMenu()
        {
            _pnlMark.UpdateContextMenu();
        }

        /// <summary>
        /// 使用中のリソースをすべてクリーンアップします。
        /// </summary>
        /// <param name="disposing">マネージ リソースを破棄する場合は true を指定し、その他の場合は false を指定します。</param>
        protected override void Dispose(bool disposing)
        {
            if (disposing && (components != null))
            {
                components.Dispose();
            }
            base.Dispose(disposing);
        }

        #region IAnimationMarkUsableメンバ

        /// <summary>
        /// アニメーションマークを利用するか
        /// </summary>
        public bool UseAnimationMark
        {
            get { return _useAnimationMark; }
            set
            {
                _useAnimationMark = value;
                _pnlMark.Visible = value;
                _chkCheckBox.UseContextMenu = value;
            }
        }

        /// <summary>
        /// アニメーションマークを更新します
        /// </summary>
        public void UpdateAnimationMark()
        {
            UpdateMarkColor();
            UpdateContextMenu();
        }

        #endregion

        #region コンポーネント デザイナーで生成されたコード

        /// <summary>
        /// デザイナー サポートに必要なメソッドです。このメソッドの内容を
        /// コード エディターで変更しないでください。
        /// </summary>
        private void InitializeComponent()
        {
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(AnimationMarkCheckBox));
            this._pnlMark = new LayoutEditor.src.Controls.AnimationMark();
            this._chkCheckBox = new LayoutEditor.src.Controls.BindAnimationCheckBox();
            this.SuspendLayout();
            //
            // _pnlMark
            //
            resources.ApplyResources(this._pnlMark, "_pnlMark");
            this._pnlMark.Name = "_pnlMark";
            //
            // _chkCheckBox
            //
            resources.ApplyResources(this._chkCheckBox, "_chkCheckBox");
            this._chkCheckBox.Name = "_chkCheckBox";
            this._chkCheckBox.UseAnimationMark = false;
            this._chkCheckBox.UseContextMenu = false;
            this._chkCheckBox.UseVisualStyleBackColor = true;
            //
            // AnimationMarkCheckBox
            //
            resources.ApplyResources(this, "$this");
            this.AutoScaleMode = System.Windows.Forms.AutoScaleMode.Font;
            this.Controls.Add(this._chkCheckBox);
            this.Controls.Add(this._pnlMark);
            this.Name = "AnimationMarkCheckBox";
            this.ResumeLayout(false);
            this.PerformLayout();

        }

        #endregion
    }
}
