sampler2D TexSampler0;
sampler2D TexSampler1;
sampler2D TexSampler2;

//----------------------------------------
// Detailed Combiner

struct DetailedCombinerStage
{
    int SourceRgb0;
    int SourceRgb1;
    int SourceRgb2;

    int OperandRgb0;
    int OperandRgb1;
    int OperandRgb2;

    int SourceAlpha0;
    int SourceAlpha1;
    int SourceAlpha2;

    int OperandAlpha0;
    int OperandAlpha1;
    int OperandAlpha2;

    int CombineRgb;
    int CombineAlpha;

    int ScaleRgb;
    int ScaleAlpha;

    int ConstantRegRgb;
    int ConstantRegAlpha;
    int SavePrevRgb;
    int SavePrevAlpha;

    int SourceCountRgb;
    int SourceCountAlpha;
    int dummy0;
    int dummy1;
};

uniform const DetailedCombinerStage DetailedCombiner_Stages0;
uniform const DetailedCombinerStage DetailedCombiner_Stages1;
uniform const DetailedCombinerStage DetailedCombiner_Stages2;
uniform const DetailedCombinerStage DetailedCombiner_Stages3;
uniform const DetailedCombinerStage DetailedCombiner_Stages4;
uniform const DetailedCombinerStage DetailedCombiner_Stages5;

uniform const float4 DetailedCombiner_ConstantColor0;
uniform const float4 DetailedCombiner_ConstantColor1;
uniform const float4 DetailedCombiner_ConstantColor2;
uniform const float4 DetailedCombiner_ConstantColor3;
uniform const float4 DetailedCombiner_ConstantColor4;
uniform const float4 DetailedCombiner_ConstantColor5; // J[ (nn ^CƂ͕тႤ̂Œ)
uniform const float4 DetailedCombiner_ConstantColor6; // J[ (nn ^CƂ͕тႤ̂Œ)

//uniform const int DetailedCombinerStageCount;
uniform const int DetailedCombinerTexCount;

//----------------------------------------
// Texture Combine
static const int COMBINE_REPLACE = 2;
static const int COMBINE_MODULATE = 3;
static const int COMBINE_ADD = 4;
static const int COMBINE_SUBTRACT = 5;
static const int COMBINE_EXCLUSION = 6;
static const int COMBINE_COLOR_DODGE = 7;
static const int COMBINE_COLOR_BURN = 8;
static const int COMBINE_OVERLAY = 9;
static const int COMBINE_LIGHTEN = 10;
static const int COMBINE_DARKEN = 11;

static const int COMBINE_INDIRECT = 14;
static const int COMBINE_BLEND_INDIRECT = 15;
static const int COMBINE_EACH_INDIRECT = 16;
//----------------------------------------


float4 GetDetailedCombiner_ConstantColor(const in int colorReg)
{
    if (colorReg == 0) return DetailedCombiner_ConstantColor0;
    else if (colorReg == 1) return DetailedCombiner_ConstantColor1;
    else if (colorReg == 2) return DetailedCombiner_ConstantColor2;
    else if (colorReg == 3) return DetailedCombiner_ConstantColor3;
    else if (colorReg == 4) return DetailedCombiner_ConstantColor4;
    else if (colorReg == 6) return DetailedCombiner_ConstantColor5;
    else if (colorReg == 7) return DetailedCombiner_ConstantColor6;

    return DetailedCombiner_ConstantColor0;
}

float4 GetDetailedCombinerSrc(
    const in float4 Color,
    const in float4 Tex0,
    const in float4 Tex1,
    const in float4 Tex2,
    const in float4 colorOutput,
    const in float4 colorBuffer,
    const in int constantReg,
    const in int source)
{
    // J[
    if (source == 0 && DetailedCombinerTexCount >= 1) // texture0
    {
        return tex2D(TexSampler0, float2(Tex0.x, Tex0.y));
    }
    else
    if (source == 1 && DetailedCombinerTexCount >= 2) // texture1
    {
        return tex2D(TexSampler1, float2(Tex1.x, Tex1.y));
    }
    else
    if (source == 2 && DetailedCombinerTexCount >= 3) // texture2
    {
        return tex2D(TexSampler2, float2(Tex2.x, Tex2.y));
    }
    else
    if (source == 3) // texture3 gps
    {
        return float4(1.0f, 1.0f, 1.0f, 1.0f);
    }
    else
    if (source == 4) // constant
    {
        return GetDetailedCombiner_ConstantColor(constantReg);
    }
    else
    if (source == 5) // primary
    {
        return Color;
    }
    else
    if (source == 6) // previous
    {
        return colorOutput;
    }
    else // register(buffer)
    {
        return colorBuffer;
    }
}

float4 GetDetailedCombinerOp(
    const in float4 color,
    const in int op
)
{
    if (op == 0) return color; // Rgb
    else if (op == 1) return float4(1.0f - color.x, 1.0f - color.y, 1.0f - color.z, 1.0f - color.w);    // InvRgb
    else if (op == 2) return float4(color.w, color.w, color.w, color.w);                                // Alpha
    else if (op == 3) return float4(1.0f - color.w, 1.0f - color.w, 1.0f - color.w, 1.0f - color.w);    // InvAlpha
    else if (op == 4) return float4(color.x, color.x, color.x, color.x);                                // Rrr
    else if (op == 5) return float4(1.0f - color.x, 1.0f - color.x, 1.0f - color.x, 1.0f - color.x);    // InvRrr
    else if (op == 6) return float4(color.y, color.y, color.y, color.y);                                // Ggg
    else if (op == 7) return float4(1.0f - color.y, 1.0f - color.y, 1.0f - color.y, 1.0f - color.y);    // InvGgg
    else if (op == 8) return float4(color.z, color.z, color.z, color.z);                                // Bbb
    else if (op == 9) return float4(1.0f - color.z, 1.0f - color.z, 1.0f - color.z, 1.0f - color.z);    // InvBbb
    else if (op == 10) return float4(color.x, color.x, color.x, color.x);                               // R
    else if (op == 11) return float4(1.0f - color.x, 1.0f - color.x, 1.0f - color.x, 1.0f - color.x);   // InvR
    else if (op == 12) return float4(color.y, color.y, color.y, color.y);                               // 
    else if (op == 13) return float4(1.0f - color.y, 1.0f - color.y, 1.0f - color.y, 1.0f - color.y);   // InvG
    else if (op == 14) return float4(color.z, color.z, color.z, color.z);                               // B
    else               return float4(1.0f - color.z, 1.0f - color.z, 1.0f - color.z, 1.0f - color.z);   // InvB
}

float4 GetDetailedCombinerMode(
    const in float4 source0,
    const in float4 source1,
    const in float4 source2,
    const in int mode)
{
    if (mode == 0) return source0;                                             // Replace
    else if (mode == 1) return source0 * source1;                                   // Modulate
    else if (mode == 2) return source0 + source1;                                   // Add
    else if (mode == 3) return source0 + source1 - 0.5f;                            // AddSigned
    else if (mode == 4) return (source0 * source2) + (source1 * (1.0f - source2));  // Interpolate
    else if (mode == 5) return source0 - source1;                                   // Subtract
    else if (mode == 6) return (source0 + source1) * source2;                       // AddMultDMP
    else if (mode == 7) return (source0 * source1) + source2;                       // MultAddDMP
    else                return float4(1.0f, 0.0f, 1.0f, 1.0f);
}

float4 GetDetailedCombinerScale(const in int scaleNum)
{
    if (scaleNum == 0) return float4(1.0f, 1.0f, 1.0f, 1.0f);
    else if (scaleNum == 1) return float4(2.0f, 2.0f, 2.0f, 2.0f);
    else                    return float4(4.0f, 4.0f, 4.0f, 4.0f);
}

//---------------------------------------------------------------------------
void CalcDetailedCombinerSource1(
    const in float4 Color,
    const in float4 Tex0,
    const in float4 Tex1,
    const in float4 Tex2,
    const in DetailedCombinerStage stage,
    inout float4 colorOutput,
    inout float4 colorBuffer)
{
    // obt@̓͌
    if (stage.SavePrevRgb == 1)
    {
        colorBuffer.xyz = colorOutput.xyz;
    }
    if (stage.SavePrevAlpha == 1)
    {
        colorBuffer.w = colorOutput.w;
    }

    float4 srcRgb = GetDetailedCombinerSrc(Color, Tex0, Tex1, Tex2, colorOutput, colorBuffer, stage.ConstantRegRgb, stage.SourceRgb0);
    srcRgb = GetDetailedCombinerOp(srcRgb, stage.OperandRgb0);
    srcRgb = GetDetailedCombinerMode(srcRgb, float4(0.0f, 0.0f, 0.0f, 0.0f), float4(0.0f, 0.0f, 0.0f, 0.0f), stage.CombineRgb);
    srcRgb = srcRgb * GetDetailedCombinerScale(stage.ScaleRgb);

    float4 srcAlpha = GetDetailedCombinerSrc(Color, Tex0, Tex1, Tex2, colorOutput, colorBuffer, stage.ConstantRegAlpha, stage.SourceAlpha0);
    srcAlpha = GetDetailedCombinerOp(srcAlpha, stage.OperandAlpha0);
    srcAlpha = GetDetailedCombinerMode(srcAlpha, float4(0.0f, 0.0f, 0.0f, 0.0f), float4(0.0f, 0.0f, 0.0f, 0.0f), stage.CombineAlpha);
    srcAlpha = srcAlpha * GetDetailedCombinerScale(stage.ScaleAlpha);

    colorOutput = float4(srcRgb.x, srcRgb.y, srcRgb.z, srcAlpha.w);
}

//---------------------------------------------------------------------------
void CalcDetailedCombinerSource2(
    const in float4 Color,
    const in float4 Tex0,
    const in float4 Tex1,
    const in float4 Tex2,
    const in DetailedCombinerStage stage,
    inout float4 colorOutput,
    inout float4 colorBuffer)
{
    // obt@̓͌
    if (stage.SavePrevRgb == 1)
    {
        colorBuffer.xyz = colorOutput.xyz;
    }
    if (stage.SavePrevAlpha == 1)
    {
        colorBuffer.w = colorOutput.w;
    }

    float4 srcRgb0 = GetDetailedCombinerSrc(Color, Tex0, Tex1, Tex2, colorOutput, colorBuffer, stage.ConstantRegRgb, stage.SourceRgb0);
    float4 srcRgb1 = GetDetailedCombinerSrc(Color, Tex0, Tex1, Tex2, colorOutput, colorBuffer, stage.ConstantRegRgb, stage.SourceRgb1);
    srcRgb0 = GetDetailedCombinerOp(srcRgb0, stage.OperandRgb0);
    srcRgb1 = GetDetailedCombinerOp(srcRgb1, stage.OperandRgb1);
    float4 srcRgb = GetDetailedCombinerMode(srcRgb0, srcRgb1, float4(0.0f, 0.0f, 0.0f, 0.0f), stage.CombineRgb);
    srcRgb = srcRgb * GetDetailedCombinerScale(stage.ScaleRgb);

    float4 srcAlpha0 = GetDetailedCombinerSrc(Color, Tex0, Tex1, Tex2, colorOutput, colorBuffer, stage.ConstantRegAlpha, stage.SourceAlpha0);
    float4 srcAlpha1 = GetDetailedCombinerSrc(Color, Tex0, Tex1, Tex2, colorOutput, colorBuffer, stage.ConstantRegAlpha, stage.SourceAlpha1);
    srcAlpha0 = GetDetailedCombinerOp(srcAlpha0, stage.OperandAlpha0);
    srcAlpha1 = GetDetailedCombinerOp(srcAlpha1, stage.OperandAlpha1);
    float4 srcAlpha = GetDetailedCombinerMode(srcAlpha0, srcAlpha1, float4(0.0f, 0.0f, 0.0f, 0.0f), stage.CombineAlpha);
    srcAlpha = srcAlpha * GetDetailedCombinerScale(stage.ScaleAlpha);

    colorOutput = float4(srcRgb.x, srcRgb.y, srcRgb.z, srcAlpha.w);
}

//---------------------------------------------------------------------------
void CalcDetailedCombinerSource3(
    const in float4 Color,
    const in float4 Tex0,
    const in float4 Tex1,
    const in float4 Tex2,
    const in DetailedCombinerStage stage,
    inout float4 colorOutput,
    inout float4 colorBuffer)
{
    // RX^gJ[

    // obt@̓͌
    if (stage.SavePrevRgb == 1)
    {
        colorBuffer.xyz = colorOutput.xyz;
    }
    if (stage.SavePrevAlpha == 1)
    {
        colorBuffer.w = colorOutput.w;
    }

    float4 srcRgb0 = GetDetailedCombinerSrc(Color, Tex0, Tex1, Tex2, colorOutput, colorBuffer, stage.ConstantRegRgb, stage.SourceRgb0);
    float4 srcRgb1 = GetDetailedCombinerSrc(Color, Tex0, Tex1, Tex2, colorOutput, colorBuffer, stage.ConstantRegRgb, stage.SourceRgb1);
    float4 srcRgb2 = GetDetailedCombinerSrc(Color, Tex0, Tex1, Tex2, colorOutput, colorBuffer, stage.ConstantRegRgb, stage.SourceRgb2);
    srcRgb0 = GetDetailedCombinerOp(srcRgb0, stage.OperandRgb0);
    srcRgb1 = GetDetailedCombinerOp(srcRgb1, stage.OperandRgb1);
    srcRgb2 = GetDetailedCombinerOp(srcRgb2, stage.OperandRgb2);
    float4 srcRgb = GetDetailedCombinerMode(srcRgb0, srcRgb1, srcRgb2, stage.CombineRgb);
    srcRgb = srcRgb * GetDetailedCombinerScale(stage.ScaleRgb);

    float4 srcAlpha0 = GetDetailedCombinerSrc(Color, Tex0, Tex1, Tex2, colorOutput, colorBuffer, stage.ConstantRegAlpha, stage.SourceAlpha0);
    float4 srcAlpha1 = GetDetailedCombinerSrc(Color, Tex0, Tex1, Tex2, colorOutput, colorBuffer, stage.ConstantRegAlpha, stage.SourceAlpha1);
    float4 srcAlpha2 = GetDetailedCombinerSrc(Color, Tex0, Tex1, Tex2, colorOutput, colorBuffer, stage.ConstantRegAlpha, stage.SourceAlpha2);
    srcAlpha0 = GetDetailedCombinerOp(srcAlpha0, stage.OperandAlpha0);
    srcAlpha1 = GetDetailedCombinerOp(srcAlpha1, stage.OperandAlpha1);
    srcAlpha2 = GetDetailedCombinerOp(srcAlpha2, stage.OperandAlpha2);
    float4 srcAlpha = GetDetailedCombinerMode(srcAlpha0, srcAlpha1, srcAlpha2, stage.CombineAlpha);
    srcAlpha = srcAlpha * GetDetailedCombinerScale(stage.ScaleAlpha);

    colorOutput = float4(srcRgb.x, srcRgb.y, srcRgb.z, srcAlpha.w);
}

//---------------------------------------------------------------------------
float4 PShader_dc_stg0(float4 Color : COLOR0, float4  Tex0 : TEXCOORD0, float4  Tex1 : TEXCOORD1, float4  Tex2 : TEXCOORD2) : SV_Target
{
    return  DetailedCombiner_ConstantColor5;
}

//---------------------------------------------------------------------------
float4 PShader_dc_stg1_src1(float4 Color : COLOR0, float4  Tex0 : TEXCOORD0, float4  Tex1 : TEXCOORD1, float4  Tex2 : TEXCOORD2) : SV_Target
{
    float4 colorBuffer = DetailedCombiner_ConstantColor5;
    float4 colorOutput = DetailedCombiner_ConstantColor5;

    CalcDetailedCombinerSource1(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages0, colorOutput, colorBuffer);

    return colorOutput;
}

//---------------------------------------------------------------------------
float4 PShader_dc_stg1_src2(float4 Color : COLOR0, float4  Tex0 : TEXCOORD0, float4  Tex1 : TEXCOORD1, float4  Tex2 : TEXCOORD2) : SV_Target
{
    float4 colorBuffer = DetailedCombiner_ConstantColor5;
    float4 colorOutput = DetailedCombiner_ConstantColor5;

    CalcDetailedCombinerSource2(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages0, colorOutput, colorBuffer);

    return colorOutput;
}

//---------------------------------------------------------------------------
float4 PShader_dc_stg1_src3(float4 Color : COLOR0, float4  Tex0 : TEXCOORD0, float4  Tex1 : TEXCOORD1, float4  Tex2 : TEXCOORD2) : SV_Target
{
    float4 colorBuffer = DetailedCombiner_ConstantColor5;
    float4 colorOutput = DetailedCombiner_ConstantColor5;

    CalcDetailedCombinerSource3(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages0, colorOutput, colorBuffer);

    return colorOutput;
}

//---------------------------------------------------------------------------
float4 PShader_dc_stg2_src1(float4 Color : COLOR0, float4  Tex0 : TEXCOORD0, float4  Tex1 : TEXCOORD1, float4  Tex2 : TEXCOORD2) : SV_Target
{
    float4 colorBuffer = DetailedCombiner_ConstantColor5;
    float4 colorOutput = DetailedCombiner_ConstantColor5;

    CalcDetailedCombinerSource1(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages0, colorOutput, colorBuffer);
    CalcDetailedCombinerSource1(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages1, colorOutput, colorBuffer);

    return colorOutput;
}

//---------------------------------------------------------------------------
float4 PShader_dc_stg2_src2(float4 Color : COLOR0, float4  Tex0 : TEXCOORD0, float4  Tex1 : TEXCOORD1, float4  Tex2 : TEXCOORD2) : SV_Target
{
    float4 colorBuffer = DetailedCombiner_ConstantColor5;
    float4 colorOutput = DetailedCombiner_ConstantColor5;

    CalcDetailedCombinerSource2(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages0, colorOutput, colorBuffer);
    CalcDetailedCombinerSource2(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages1, colorOutput, colorBuffer);

    return colorOutput;
}

//---------------------------------------------------------------------------
float4 PShader_dc_stg2_src3(float4 Color : COLOR0, float4  Tex0 : TEXCOORD0, float4  Tex1 : TEXCOORD1, float4  Tex2 : TEXCOORD2) : SV_Target
{
    float4 colorBuffer = DetailedCombiner_ConstantColor5;
    float4 colorOutput = DetailedCombiner_ConstantColor5;

    CalcDetailedCombinerSource3(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages0, colorOutput, colorBuffer);
    CalcDetailedCombinerSource3(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages1, colorOutput, colorBuffer);

    return colorOutput;
}

//---------------------------------------------------------------------------
float4 PShader_dc_stg3_src1(float4 Color : COLOR0, float4  Tex0 : TEXCOORD0, float4  Tex1 : TEXCOORD1, float4  Tex2 : TEXCOORD2) : SV_Target
{
    float4 colorBuffer = DetailedCombiner_ConstantColor5;
    float4 colorOutput = DetailedCombiner_ConstantColor5;

    CalcDetailedCombinerSource1(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages0, colorOutput, colorBuffer);
    CalcDetailedCombinerSource1(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages1, colorOutput, colorBuffer);
    CalcDetailedCombinerSource1(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages2, colorOutput, colorBuffer);

    return colorOutput;
}

//---------------------------------------------------------------------------
float4 PShader_dc_stg3_src2(float4 Color : COLOR0, float4  Tex0 : TEXCOORD0, float4  Tex1 : TEXCOORD1, float4  Tex2 : TEXCOORD2) : SV_Target
{
    float4 colorBuffer = DetailedCombiner_ConstantColor5;
    float4 colorOutput = DetailedCombiner_ConstantColor5;

    CalcDetailedCombinerSource2(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages0, colorOutput, colorBuffer);
    CalcDetailedCombinerSource2(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages1, colorOutput, colorBuffer);
    CalcDetailedCombinerSource2(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages2, colorOutput, colorBuffer);

    return colorOutput;
}

//---------------------------------------------------------------------------
float4 PShader_dc_stg3_src3(float4 Color : COLOR0, float4  Tex0 : TEXCOORD0, float4  Tex1 : TEXCOORD1, float4  Tex2 : TEXCOORD2) : SV_Target
{
    float4 colorBuffer = DetailedCombiner_ConstantColor5;
    float4 colorOutput = DetailedCombiner_ConstantColor5;

    CalcDetailedCombinerSource3(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages0, colorOutput, colorBuffer);
    CalcDetailedCombinerSource3(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages1, colorOutput, colorBuffer);
    CalcDetailedCombinerSource3(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages2, colorOutput, colorBuffer);

    return colorOutput;
}

//---------------------------------------------------------------------------
float4 PShader_dc_stg4_src1(float4 Color : COLOR0, float4  Tex0 : TEXCOORD0, float4  Tex1 : TEXCOORD1, float4  Tex2 : TEXCOORD2) : SV_Target
{
    float4 colorBuffer = DetailedCombiner_ConstantColor5;
    float4 colorOutput = DetailedCombiner_ConstantColor5;

    CalcDetailedCombinerSource1(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages0, colorOutput, colorBuffer);
    CalcDetailedCombinerSource1(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages1, colorOutput, colorBuffer);
    CalcDetailedCombinerSource1(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages2, colorOutput, colorBuffer);
    CalcDetailedCombinerSource1(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages3, colorOutput, colorBuffer);

    return colorOutput;
}

//---------------------------------------------------------------------------
float4 PShader_dc_stg4_src2(float4 Color : COLOR0, float4  Tex0 : TEXCOORD0, float4  Tex1 : TEXCOORD1, float4  Tex2 : TEXCOORD2) : SV_Target
{
    float4 colorBuffer = DetailedCombiner_ConstantColor5;
    float4 colorOutput = DetailedCombiner_ConstantColor5;

    CalcDetailedCombinerSource2(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages0, colorOutput, colorBuffer);
    CalcDetailedCombinerSource2(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages1, colorOutput, colorBuffer);
    CalcDetailedCombinerSource2(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages2, colorOutput, colorBuffer);
    CalcDetailedCombinerSource2(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages3, colorOutput, colorBuffer);

    return colorOutput;
}

//---------------------------------------------------------------------------
float4 PShader_dc_stg4_src3(float4 Color : COLOR0, float4  Tex0 : TEXCOORD0, float4  Tex1 : TEXCOORD1, float4  Tex2 : TEXCOORD2) : SV_Target
{
    float4 colorBuffer = DetailedCombiner_ConstantColor5;
    float4 colorOutput = DetailedCombiner_ConstantColor5;

    CalcDetailedCombinerSource3(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages0, colorOutput, colorBuffer);
    CalcDetailedCombinerSource3(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages1, colorOutput, colorBuffer);
    CalcDetailedCombinerSource3(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages2, colorOutput, colorBuffer);
    CalcDetailedCombinerSource3(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages3, colorOutput, colorBuffer);

    return colorOutput;
}

//---------------------------------------------------------------------------
float4 PShader_dc_stg5_src1(float4 Color : COLOR0, float4  Tex0 : TEXCOORD0, float4  Tex1 : TEXCOORD1, float4  Tex2 : TEXCOORD2) : SV_Target
{
    float4 colorBuffer = DetailedCombiner_ConstantColor5;
    float4 colorOutput = DetailedCombiner_ConstantColor5;

    CalcDetailedCombinerSource1(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages0, colorOutput, colorBuffer);
    CalcDetailedCombinerSource1(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages1, colorOutput, colorBuffer);
    CalcDetailedCombinerSource1(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages2, colorOutput, colorBuffer);
    CalcDetailedCombinerSource1(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages3, colorOutput, colorBuffer);
    CalcDetailedCombinerSource1(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages4, colorOutput, colorBuffer);

    return colorOutput;
}

//---------------------------------------------------------------------------
float4 PShader_dc_stg5_src2(float4 Color : COLOR0, float4  Tex0 : TEXCOORD0, float4  Tex1 : TEXCOORD1, float4  Tex2 : TEXCOORD2) : SV_Target
{
    float4 colorBuffer = DetailedCombiner_ConstantColor5;
    float4 colorOutput = DetailedCombiner_ConstantColor5;

    CalcDetailedCombinerSource2(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages0, colorOutput, colorBuffer);
    CalcDetailedCombinerSource2(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages1, colorOutput, colorBuffer);
    CalcDetailedCombinerSource2(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages2, colorOutput, colorBuffer);
    CalcDetailedCombinerSource2(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages3, colorOutput, colorBuffer);
    CalcDetailedCombinerSource2(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages4, colorOutput, colorBuffer);

    return colorOutput;
}

//---------------------------------------------------------------------------
float4 PShader_dc_stg5_src3(float4 Color : COLOR0, float4  Tex0 : TEXCOORD0, float4  Tex1 : TEXCOORD1, float4  Tex2 : TEXCOORD2) : SV_Target
{
    float4 colorBuffer = DetailedCombiner_ConstantColor5;
    float4 colorOutput = DetailedCombiner_ConstantColor5;

    CalcDetailedCombinerSource3(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages0, colorOutput, colorBuffer);
    CalcDetailedCombinerSource3(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages1, colorOutput, colorBuffer);
    CalcDetailedCombinerSource3(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages2, colorOutput, colorBuffer);
    CalcDetailedCombinerSource3(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages3, colorOutput, colorBuffer);
    CalcDetailedCombinerSource3(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages4, colorOutput, colorBuffer);

    return colorOutput;
}

//---------------------------------------------------------------------------
float4 PShader_dc_stg6_src1(float4 Color : COLOR0, float4  Tex0 : TEXCOORD0, float4  Tex1 : TEXCOORD1, float4  Tex2 : TEXCOORD2) : SV_Target
{
    float4 colorBuffer = DetailedCombiner_ConstantColor5;
    float4 colorOutput = DetailedCombiner_ConstantColor5;

    CalcDetailedCombinerSource1(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages0, colorOutput, colorBuffer);
    CalcDetailedCombinerSource1(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages1, colorOutput, colorBuffer);
    CalcDetailedCombinerSource1(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages2, colorOutput, colorBuffer);
    CalcDetailedCombinerSource1(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages3, colorOutput, colorBuffer);
    CalcDetailedCombinerSource1(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages4, colorOutput, colorBuffer);
    CalcDetailedCombinerSource1(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages5, colorOutput, colorBuffer);

    return colorOutput;
}

//---------------------------------------------------------------------------
float4 PShader_dc_stg6_src2(float4 Color : COLOR0, float4  Tex0 : TEXCOORD0, float4  Tex1 : TEXCOORD1, float4  Tex2 : TEXCOORD2) : SV_Target
{
    float4 colorBuffer = DetailedCombiner_ConstantColor5;
    float4 colorOutput = DetailedCombiner_ConstantColor5;

    CalcDetailedCombinerSource2(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages0, colorOutput, colorBuffer);
    CalcDetailedCombinerSource2(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages1, colorOutput, colorBuffer);
    CalcDetailedCombinerSource2(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages2, colorOutput, colorBuffer);
    CalcDetailedCombinerSource2(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages3, colorOutput, colorBuffer);
    CalcDetailedCombinerSource2(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages4, colorOutput, colorBuffer);
    CalcDetailedCombinerSource2(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages5, colorOutput, colorBuffer);

    return colorOutput;
}

//---------------------------------------------------------------------------
float4 PShader_dc_stg6_src3(float4 Color : COLOR0, float4  Tex0 : TEXCOORD0, float4  Tex1 : TEXCOORD1, float4  Tex2 : TEXCOORD2) : SV_Target
{
    float4 colorBuffer = DetailedCombiner_ConstantColor5;
    float4 colorOutput = DetailedCombiner_ConstantColor5;

    CalcDetailedCombinerSource3(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages0, colorOutput, colorBuffer);
    CalcDetailedCombinerSource3(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages1, colorOutput, colorBuffer);
    CalcDetailedCombinerSource3(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages2, colorOutput, colorBuffer);
    CalcDetailedCombinerSource3(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages3, colorOutput, colorBuffer);
    CalcDetailedCombinerSource3(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages4, colorOutput, colorBuffer);
    CalcDetailedCombinerSource3(Color, Tex0, Tex1, Tex2, DetailedCombiner_Stages5, colorOutput, colorBuffer);

    return colorOutput;
}
