sampler2D TexSampler0;
sampler2D TexSampler1;
sampler2D TexSampler2;

uniform const float4 InterpolateWidth;
uniform const float4 InterpolateOffset;
uniform const int EnabledTextureCount;
uniform const int ProceduralShapeEnabled;

uniform const float4 uProceduralShapeParams;
uniform const float4 uProceduralShapeSizeParams;
uniform const float4 uBlendType;
uniform const float4 uInnerStrokeParams;
uniform const float4 uInnerStrokeColor;
uniform const float4 uInnerShadowParams;
uniform const float4 uInnerShadowColor;
uniform const float4 uInnerShadowAttenuation;
uniform const float4 uColorOverlayColor;
uniform const float4 uGradationOverlayControlPoints;
uniform const float4 uGradationOverlayAngleParams;
uniform const float4 uGradationOverlayColors[4];

uniform const int PackedFontBorderDisabled;

uniform const int IndirectImgChannelNum;
uniform const float4 IndirectMtx1;
uniform const float4 IndirectMtx2;

uniform const int SelectAlphaMaxStage1;
uniform const int SelectAlphaMaxStage2;
uniform const int CombineModeStage1;
uniform const int CombineModeStage2;

//----------------------------------------
// Texture Combine
static const int COMBINE_REPLACE = 2;
static const int COMBINE_MODULATE = 3;
static const int COMBINE_ADD = 4;
static const int COMBINE_SUBTRACT = 5;
static const int COMBINE_EXCLUSION = 6;
static const int COMBINE_COLOR_DODGE = 7;
static const int COMBINE_COLOR_BURN = 8;
static const int COMBINE_OVERLAY = 9;
static const int COMBINE_LIGHTEN = 10;
static const int COMBINE_DARKEN  = 11;

static const int COMBINE_INDIRECT = 14;
static const int COMBINE_BLEND_INDIRECT = 15;
static const int COMBINE_EACH_INDIRECT = 16;
//----------------------------------------


//---------------------------------------------------------------------------
float4 InterporateQuadColor(const in float4x4 colors, const in float4 coord)
{
    float4 colorL = colors[0] * coord.w + colors[2] * coord.y;
    float4 colorR = colors[1] * coord.w + colors[3] * coord.y;
    return colorL * coord.z + colorR * coord.x;
}

//---------------------------------------------------------------------------
void CombineColor(
    const in float4 textureColor,
    const in int mode,
    const in bool selectAlphaMax,
    inout float4 color)
{
    if (mode == COMBINE_REPLACE) {
        color.rgb = textureColor.rgb * textureColor.a + color.rgb * (1 - textureColor.a);
    }
    
    if (mode == COMBINE_MODULATE) {
        color.rgb = color.rgb * textureColor.rgb;
    } 
    
    if (mode == COMBINE_ADD) {
        color.rgb = color.rgb + textureColor.rgb * textureColor.a;
    } 
    
    if (mode == COMBINE_SUBTRACT) {
        color.rgb = color.rgb - textureColor.rgb * textureColor.a;
    } 
    
    if (mode == COMBINE_EXCLUSION) {
        float3 c0 = color.rgb;
        float3 c1 = textureColor.rgb * textureColor.a;
        color.rgb = (1 - c1.rgb) * c0.rgb + (1 - c0.rgb) * c1.rgb;
    } 
    
    if (mode == COMBINE_COLOR_DODGE) {
        color.rgb = color.rgb / (1 - textureColor.rgb * textureColor.a);
        color.rgb = min(color.rgb, 1);
    } 
    
    if (mode == COMBINE_COLOR_BURN) {
        color.rgb = 1 - (1 - color.rgb) / textureColor.rgb;
        color.rgb = max(color.rgb, 0);
    } 
    
    if (mode == COMBINE_OVERLAY) {
        float3 multi = 2.0 * color.rgb * textureColor.rgb;
        float3 screen = 1.0 - 2.0 * (1.0 - color.rgb) * (1.0 - textureColor.rgb);
        
        // color.rgb = mix(screen, multi, lessThan(color.rgb, vec3(0.5)));
        if(color.r > 0.5)
        {
            color.r = screen.r;
        }else{
            color.r = multi.r;
        }
        
        if(color.g > 0.5)
        {
            color.g = screen.g;
        }else{
            color.g = multi.g;
        }
        
        if(color.b > 0.5)
        {
            color.b = screen.b;
        }else{
            color.b = multi.b;
        }
    }
        
    if(mode == COMBINE_LIGHTEN)
    {
        color.r = max(color.r, textureColor.r);
        color.g = max(color.g, textureColor.g);
        color.b = max(color.b, textureColor.b);
    }
    
    if(mode == COMBINE_DARKEN)
    {
        color.r = min(color.r, textureColor.r);
        color.g = min(color.g, textureColor.g);
        color.b = min(color.b, textureColor.b);
    }

    color.a = selectAlphaMax ? max(color.a, textureColor.a) : min(color.a, textureColor.a);
}

//----------------------------------------
float4 SelectIndirectTextureChannel(
    const in float4 indirectColor0, 
    const in int channelNum)
{
    // At@1`ltH[}bg̏ꍇ́A channelNum == -1 ƂāAAt@`ltFb`悤ɂ܂B
    if(channelNum == -1)
    {
        return float4(1, 1, 1, indirectColor0.a);
    }

    if(channelNum == 1)
    {
        return float4(indirectColor0.r, indirectColor0.r, 1, 1);
    }
    
    if(channelNum == 2)
    {
        return float4(indirectColor0.r, indirectColor0.a, 1, 1);
    }
    
    if(channelNum == 3)
    {
        return float4(indirectColor0.r, indirectColor0.g, 1, indirectColor0.b);
    }
    
    return indirectColor0;
}

//---------------------------------------------------------------------------
float4 SampleColorWithSingleIndirectTexture(
    const in float4 indirectColor,
    const in sampler2D smpTex,
    const in float2 texCoord)
{
    float4 finaleIndColor = SelectIndirectTextureChannel(indirectColor, IndirectImgChannelNum);
    
    float alpha = finaleIndColor.a;
    
    float2 indirect;
    indirect.x = dot(float4(finaleIndColor.xyz, 1.0), IndirectMtx1);
    indirect.y = dot(float4(finaleIndColor.xyz, 1.0), IndirectMtx2);
    
    float4 color = tex2D(smpTex, texCoord + indirect);
    color.a = min(color.a, alpha);
    
    return color;
}

//---------------------------------------------------------------------------
float4 SampleColorWithDoubleIndirectTexture(
    const in float4 indirectColor0,
    const in float4 indirectColor1,
    const in int mode,
    const in sampler2D smpTex,
    const in float2 texCoord)
{
    float alpha = indirectColor0.a * indirectColor1.a;
    float4 color0;
    color0.rgb = (indirectColor0.rgb - 0.5) * 2;
    color0.w = 1;
    float4 color1;
    color1.rgb = (indirectColor1.rgb - 0.5) * 2;
    color1.w = 1;
    
    CombineColor(color1, mode, true, color0);
    color0 = SelectIndirectTextureChannel(color0, IndirectImgChannelNum);
    
    float2 indirect;
    indirect.x = dot(color0.xy, IndirectMtx1.xy);
    indirect.y = dot(color0.xy, IndirectMtx2.xy);
    indirect *= 0.5;
    
    float4 color = tex2D(smpTex, texCoord + indirect);
    color.a = min(color.a, alpha);
    
    return color;
}

float CalculateDistance(const in float2 pos, in float functionExp, in float2 cornerOffset, out float isInCorner, in float scale)
{
    float2 one = float2(1.0, 1.0);
    float2 absPos = abs(pos);

    // t̊pۃItZbgʒuvZ
    float2 cornerCenterWithSign = sign(pos) * cornerOffset;
    // pی_̕tItZbgl(ϊOWn)
    float2 cornerOriginOffset = pos - cornerCenterWithSign;
    // pۂ̃TCY(ϊOWn)
    float2 cornerSize = one - cornerOffset;

    // pۃTCYPʂ̊pی_̋vZ
    float2  distanceFromCornerOriginAbs = abs(cornerOriginOffset / cornerSize) * (1.0 / scale);

    // pی_Ŋ֐]
    float2 expValue = float2(functionExp, functionExp);
    float2 functionValue = pow(abs(distanceFromCornerOriginAbs), expValue);

    // pی_̋̏ꍇɃGbẄƔf
    float2 inEdge = clamp(sign(cornerOffset - absPos), 0.0, 1.0);

    float centerBox = inEdge.x * inEdge.y;
    float inCorner = (1.0 - inEdge.x) * (1.0 - inEdge.y);
    isInCorner = inCorner;
    // pۗ̈̏ꍇ (x + y)
    float distance = (functionValue.x + functionValue.y) * inCorner;
    // EẼGbW̏ꍇ͊pۂƂ̋E̒ls[g
    distance += inEdge.x * functionValue.y;
    distance += inEdge.y * functionValue.x;
    // S̗̈͊pۃTCYŕꂽ̒ls[g
    distance *= (1.0 - centerBox);
    distance -= (distanceFromCornerOriginAbs.x * distanceFromCornerOriginAbs.y * centerBox);

    return distance;
}

//-------------------------------------------------------------------
// pۋ@\puh
//-------------------------------------------------------------------
float4 ProceduralShapeBlend(in float type, in float4 color1, in float4 color2)
{
    float4    color;
    float4 white = float4(1.0, 1.0, 1.0, 1.0);

    if (type == 1.0)
    {
        //  DropShadowBlendMode_Mul,
        color.rgb = (color1.rgb * (color2.rgb + (white.rgb - color2.rgb) * (1.0 - color2.a)));
        color.a = color1.a;
    }
    else if (type == 2.0)
    {
        //  DropShadowBlendMode_Add,
        color.rgb = color1.rgb + (color2.rgb * color2.a);
        color.a = color1.a;
    }
    else if (type == 3.0)
    {
        //  DropShadowBlendMode_Sub,
        color.rgb = color1.rgb - (color2.rgb * color2.a);
        color.a = color1.a;
    }
    else
    {
        //  DropShadowBlendMode_Normal,
        color.rgb = ((color1.rgb * (1.0 - color2.a)) + (color2.rgb * color2.a));
        color.a = color1.a;
    }

    return color;
}

//----------------------------------------
float4 ApplyProceduralShape(const in float4 inColor, const in float4 vLocalPosition)
{
    float4 color = inColor;

    float2 shapeEvaluatePos, shapeEvaluatePosAbs;
    shapeEvaluatePos.x = (vLocalPosition.x - 0.5) * 2.0;
    shapeEvaluatePos.y = (vLocalPosition.y - 0.5) * 2.0;
    shapeEvaluatePosAbs = abs(shapeEvaluatePos);
    float2 paneSize = float2(uProceduralShapeSizeParams.x, uProceduralShapeSizeParams.y);
    float2 cornerOffset = uProceduralShapeParams.yz;

    float functionExp = uProceduralShapeParams.x;
    float cornerSize = uProceduralShapeSizeParams.z;
    float isInCorner;

    // `
    float distance = CalculateDistance(shapeEvaluatePosAbs, functionExp, cornerOffset, isInCorner, 1.0);

    // GbW̃At@ڂ
    // functionExp < 1.0 ̎̂݊pەA`GCAX邽߂̃XP[vZ
    float cornerEdgeAlphaScale = 1.0 + ((isInCorner * 4.0)) * clamp(-(functionExp - 1.0) * 2.0, 0.0, 1.0);
    // cornerSize sNZ 0.0 - 1.0 Ƀ}bv̂ 0.5 sNZɓTCYݒ肷
    float edgeAntiAliasRange = 1.0 / cornerSize * 0.5 * functionExp * cornerEdgeAlphaScale;
    // ܂ApۃTCY 0 ŊpۂȂꍇ̓GbW̃At@ڂsȂ
    float enableCorner = step(0.01, cornerSize);
    float edgeAlpha = 1.0 - clamp(clamp(distance - (1.0 - edgeAntiAliasRange), 0.0, 1.0) / edgeAntiAliasRange, 0.0, 1.0);
    edgeAlpha += (1.0 - enableCorner);
    color.a *= (sign(1.0 - distance) * edgeAlpha);

    // Of[VI[o[C
    if (uGradationOverlayControlPoints.x >= 0.0)
    {
        // ] 0.0 - 1.0 փ}bv
        float gradationEvaluateValue = cos(uGradationOverlayAngleParams.x) * shapeEvaluatePos.x + sin(uGradationOverlayAngleParams.x) * shapeEvaluatePos.y;
        gradationEvaluateValue = gradationEvaluateValue * 0.5 + 0.5;

        float minValue = step(0.0, uGradationOverlayControlPoints.x - gradationEvaluateValue);
        float maxValue = step(0.0, gradationEvaluateValue - uGradationOverlayControlPoints.w);
        // eԂ̊Jnn_̃ItZbgvZ
        float4 interpolateRange = uGradationOverlayControlPoints.yzww - uGradationOverlayControlPoints.xyzw + 0.00001;
        // eԂLǂ̌W쐬
        float4 inRange;
        inRange.x = (step(0.0, gradationEvaluateValue - uGradationOverlayControlPoints[0]) * step(0.0, uGradationOverlayControlPoints[1] - gradationEvaluateValue));
        inRange.y = (step(0.0, gradationEvaluateValue - uGradationOverlayControlPoints[1]) * step(0.0, uGradationOverlayControlPoints[2] - gradationEvaluateValue));
        inRange.z = (step(0.0, gradationEvaluateValue - uGradationOverlayControlPoints[2]) * step(0.0, uGradationOverlayControlPoints[3] - gradationEvaluateValue));
        // eԂƂɕԂ
        float4 color0 = lerp(uGradationOverlayColors[0], uGradationOverlayColors[1], clamp((gradationEvaluateValue - uGradationOverlayControlPoints[0]) / interpolateRange.x, 0.0, 1.0)) * inRange.x;
        float4 color1 = lerp(uGradationOverlayColors[1], uGradationOverlayColors[2], clamp((gradationEvaluateValue - uGradationOverlayControlPoints[1]) / interpolateRange.y, 0.0, 1.0)) * inRange.y;
        float4 color2 = lerp(uGradationOverlayColors[2], uGradationOverlayColors[3], clamp((gradationEvaluateValue - uGradationOverlayControlPoints[2]) / interpolateRange.z, 0.0, 1.0)) * inRange.z;

        float4 interpolatedColor = uGradationOverlayColors[0] * minValue + color0 + color1 + color2 + uGradationOverlayColors[3] * maxValue;

        color = ProceduralShapeBlend(uBlendType.w, color, interpolatedColor);
    }

    // J[I[o[C
    if (uColorOverlayColor.a > 0.0)
    {
        color = ProceduralShapeBlend(uBlendType.z, color, uColorOverlayColor);
    }

    // VhE()
    if (uInnerShadowColor.a > 0.0)
    {
        float   innerShadowSize = uInnerShadowParams.x;
        float   innerShadowOffsetX = uInnerShadowParams.y;
        float   innerShadowOffsetY = uInnerShadowParams.z;
        float   innerShadowCornerRatio = uProceduralShapeParams.w;

        float2	shadowEvaluatePos = shapeEvaluatePos;
        shadowEvaluatePos.x += innerShadowOffsetX;
        shadowEvaluatePos.y += innerShadowOffsetY;

        float innerShadowDistance = CalculateDistance(shadowEvaluatePos, functionExp, cornerOffset, isInCorner, 1.0);
        float innerShadowValue = clamp((innerShadowDistance - (1.0 - innerShadowSize)) / innerShadowSize, 0.0, 1.0);

        float4    attenuation;
        attenuation.x = clamp(pow(innerShadowValue, 2.0), 0.0, 1.0);
        attenuation.y = clamp(pow(innerShadowValue, 1.0), 0.0, 1.0);
        attenuation.z = clamp(1.0 - pow(1.0 - innerShadowValue, 2.0), 0.0, 1.0);
        attenuation.w = 0.0;

        float4 innerShadowBlendColor;
        innerShadowBlendColor = ProceduralShapeBlend(uBlendType.y, color, uInnerShadowColor) - color;
        color += innerShadowBlendColor * dot(uInnerShadowAttenuation, attenuation);
    }

    // E()
    if (uInnerStrokeColor.a > 0.0)
    {
        // pۃTCY
        float innerStrokeSize = uInnerStrokeParams.x;

        // pۈȊÕGbW̋E̍쐬
        float2 strokeEdgeLocalSize = float2(innerStrokeSize / (paneSize.x * 0.5), innerStrokeSize / (paneSize.y * 0.5));
        float strokeEdgeVertical = (shapeEvaluatePosAbs.x - (1.0 - strokeEdgeLocalSize.x)) / strokeEdgeLocalSize.x;
        float strokeEdgeHorizontal = (shapeEvaluatePosAbs.y - (1.0 - strokeEdgeLocalSize.y)) / strokeEdgeLocalSize.y;
        float edgeStrokeValue = clamp(sign(strokeEdgeVertical), 0.0, 1.0) + clamp(sign(strokeEdgeHorizontal), 0.0, 1.0);

        // ` 1.0 ̎͊pۂ̒Sʒuɂ炵ċE̕ϓɂ(炷ʂ x, y ꂼ cos 45)B
        // ` 2.0 ̎͊p̑傫ςēS~ɂ邽߁A 1.0 - 2.0 Ő`ԂĉeRg[B
        float interpolateValue = clamp(2.0 - functionExp, 0.0, 1.0) * 0.707;
        // Ep̊pۂ̃XP[
        // 1.0 傫ꍇ͊pۂ̃XP[`ɉĐ`ԂēS~ɋE쐬悤ɂB
        float radiusScale = 1.0 - ((innerStrokeSize / cornerSize) * clamp(functionExp - 1.0, 0.0, 1.0)) * step(1.0, functionExp);

        // pۂ̋]̂߂̒Sʒu炷B
        float2 centerOffset = strokeEdgeLocalSize * interpolateValue;
        float2 innerStrokeEvaluatePos = shapeEvaluatePosAbs + centerOffset;

        float innerStrokeDistance = CalculateDistance(innerStrokeEvaluatePos, functionExp, cornerOffset, isInCorner, radiusScale);
        // 0 傫ׂ͂ēhԂB
        // GbW̃A`GCAXɂĕsvȕ̓At@ 0 ɂȂ邽ߖȂB
        float cornerStrokeValue = clamp(sign(innerStrokeDistance), 0.0, 1.0) * isInCorner;

        // GbW̃A`GCAX
        float edgeAntiAliasPixel = 1.0;
        float2 edgeAntiAlias = float2(edgeAntiAliasPixel / (paneSize.x * 0.5), edgeAntiAliasPixel / (paneSize.y * 0.5));
        float edgeStrokeAlphaHorizontal = clamp(strokeEdgeHorizontal / edgeAntiAlias.x, 0.0, 1.0) + clamp(-sign(strokeEdgeHorizontal), 0.0, 1.0);
        float edgeStrokeAlphaVertical = clamp(strokeEdgeVertical / edgeAntiAlias.y, 0.0, 1.0) + clamp(-sign(strokeEdgeVertical), 0.0, 1.0);

        // ӂ̃A`GCAẌȍ~ɂȂȂ悤ɁAA`GCAX̒[ 1.0 ZB
        edgeStrokeAlphaVertical += step(1.0, strokeEdgeHorizontal / edgeAntiAlias.x);
        edgeStrokeAlphaHorizontal += step(1.0, strokeEdgeVertical / edgeAntiAlias.y);

        float innerEdgeAlpha = clamp(edgeStrokeAlphaHorizontal * edgeStrokeAlphaVertical, 0.0, 1.0);

        // pۓ̋EGbW̃A`GCAX
        float cornerSizeRatio = cornerSize / 500.0;
        // pےPʂ̂ڂW
        float cornerAntiAliasRange = 0.002 + (1.0 - cornerSizeRatio) * (1.0 / cornerSize);
        float cornerAntiAliasRangeHalf = cornerAntiAliasRange * 0.5;
        float cornerAlphaMask = clamp(((innerStrokeDistance - (1.0 - cornerAntiAliasRangeHalf)) + cornerAntiAliasRangeHalf) / cornerAntiAliasRange, 0.0, 1.0);
        float cornerAlpha = cornerAlphaMask * isInCorner + (1.0 - isInCorner);

        // GbW̃At@Ɗpۂ̃At@𓝍ƕKvȂƂ낪ɂȂ肷邽߁AAt@l𒲐
        cornerAlpha += edgeStrokeValue;
        float alpha = clamp(innerEdgeAlpha * cornerAlpha + step(1.0, cornerAlphaMask), 0.0, 1.0);

        float4 innerStrokeColor = uInnerStrokeColor;

        innerStrokeColor.a *= alpha;

        float innerStroke = clamp(edgeStrokeValue + cornerStrokeValue, 0.0, 1.0);
        float4  innerStrokeBlendColor;

        innerStrokeBlendColor = ProceduralShapeBlend(uBlendType.x, color, innerStrokeColor) - color;
        color += innerStrokeBlendColor * innerStroke;
    }

    return color;
}

//----------------------------------------
float4 PShader0Tex(float4 Color : COLOR0, float4 vLocalPosition : TEXCOORD3) : SV_Target
{
    if (ProceduralShapeEnabled == 1)
    {
        return ApplyProceduralShape(Color, vLocalPosition);
    }
    else
    {
        return Color;
    }
}

//----------------------------------------
float4 PShader0TexBlend(float4 Color : COLOR0, float4 vLocalPosition : TEXCOORD3) : SV_Target
{
    // 0 eNX`ł́AInterpolateOffset  łB
	float4 deafultShaderColor = InterpolateWidth * Color;

    if (ProceduralShapeEnabled == 1)
    {
        return ApplyProceduralShape(deafultShaderColor, vLocalPosition);
    }
    else
    {
        return deafultShaderColor;
    }
}

//----------------------------------------
float4 PShader1Tex(float4 Color : COLOR0, float4  Tex0 : TEXCOORD0, float4 vLocalPosition : TEXCOORD3) : SV_Target 
{
	float4 textureColor = tex2D(TexSampler0, Tex0.xy);
	
	if (EnabledTextureCount == 1) 
    {
        textureColor = tex2D(TexSampler0, Tex0.xy);
    } 

	float4 deafultShaderColor = Color * textureColor;

    if (ProceduralShapeEnabled == 1)
    {
        return ApplyProceduralShape(deafultShaderColor, vLocalPosition);
    }
    else
    {
        return deafultShaderColor;
    }
}

//----------------------------------------
float4 PShader1TexColorBlend(float4 Color : COLOR0, float4  Tex0 : TEXCOORD0, float4 vLocalPosition : TEXCOORD3) : SV_Target 
{
	float4 textureColor = tex2D(TexSampler0, Tex0.xy);
    
    if (EnabledTextureCount == 1) 
    {
        textureColor = tex2D(TexSampler0, Tex0.xy);
    } 
    
    textureColor = InterpolateOffset + InterpolateWidth * textureColor;
    
	float4 deafultShaderColor = Color * textureColor;

    if (ProceduralShapeEnabled == 1)
    {
        return ApplyProceduralShape(deafultShaderColor, vLocalPosition);
    }
    else
    {
        return deafultShaderColor;
    }
}

//----------------------------------------
float4 PShaderPackedFont(float4 Color : COLOR0, float4  Tex0 : TEXCOORD0) : SV_Target 
{
	float4 textureColor = tex2D(TexSampler0, Tex0.xy);
    
    if (EnabledTextureCount == 1) 
    {
        textureColor = tex2D(TexSampler0, Tex0.xy);
    } 
    
    if(PackedFontBorderDisabled == 1)
    {
        // 0.52 = 0.5 + 0.02 (keNX`̃mCY؂̂Ă邽߂̃}[Wł)
        if(textureColor.a < 0.52)
        {
            textureColor = float4(0,0,0, 0);
        }else{
            textureColor = float4(1,1,1, (textureColor.a - 0.5) * 2.0);
        }
    }
    else
    {
        // 0.52 = 0.5 + 0.02 (keNX`̃mCY؂̂Ă邽߂̃}[Wł)
        if(textureColor.a < 0.52)
        {
            textureColor = float4(0,0,0, textureColor.a * 2.0);
        }else{
            float col = (textureColor.a - 0.5) * 2.0;
            textureColor = float4(col,col,col, 1.0);
        }
    }
    
    textureColor = InterpolateOffset + InterpolateWidth * textureColor;

	return Color * textureColor;
}

//----------------------------------------
float4 PShader(float4 Color : COLOR0, float4  Tex0 : TEXCOORD0, float4  Tex1 : TEXCOORD1, float4  Tex2 : TEXCOORD2, float4 vLocalPosition : TEXCOORD3 ) : SV_Target 
{
	//----------------------------------------
    // COMBINE TEXTURE COLOR
    float4 textureColor;
    
    // V{e[up邽߁AœKɂč폜Ȃ悤Ƀ_~[̗pLqĂB
    if(PackedFontBorderDisabled == 1)
    {
        return 1.0;
    }
        
    if (EnabledTextureCount == 0) 
    {
        textureColor = 1.0;
    } 
    
    if (EnabledTextureCount == 1) 
    {
        textureColor = tex2D(TexSampler0, Tex0.xy);
    } 
    
    if (EnabledTextureCount > 1) 
    {
        int colorMode1 = CombineModeStage1;
        int colorMode2 = 0;
        bool selectAlphaMax2 = 0;
        float4 textureColor2 = float4(0.0f, 0.0f, 0.0f, 1.0f);
        if (EnabledTextureCount == 3)
        {
            colorMode2      = CombineModeStage2;
            textureColor2   = tex2D(TexSampler2, Tex2.xy);
        }

        if (COMBINE_INDIRECT <= colorMode1)
        {
            float4 textureColor1 = tex2D(TexSampler1, Tex1.xy);
            
            if (colorMode1 == COMBINE_INDIRECT)
            {
                // INDIRECT TEXTURE = uTexture1
                textureColor = SampleColorWithSingleIndirectTexture(textureColor1, TexSampler0, Tex0.xy);
                
                if (COMBINE_REPLACE <= colorMode2)
                {
                    bool selectAlphaMax2 = 0;
                    if (EnabledTextureCount == 3)
                    {
                        selectAlphaMax2 = SelectAlphaMaxStage2 == 1;
                    }
                    CombineColor(tex2D(TexSampler2, Tex2.xy), colorMode2, selectAlphaMax2, textureColor);
                }
            }
            else
            {
                // INDIRECT TEXTURE = (uTexture1 & uTexture2)
                textureColor = SampleColorWithDoubleIndirectTexture(textureColor1, textureColor2, colorMode2, TexSampler0, Tex0.xy);
            }
        }
        else
        {
            bool selectAlphaMax1 = SelectAlphaMaxStage1 == 1;
            if (colorMode2 == COMBINE_EACH_INDIRECT)
            {
                // INDIRECT TEXTURE = uTexture2
                textureColor = SampleColorWithSingleIndirectTexture(
                    textureColor2, TexSampler0, Tex0.xy);
                    
                // INDIRECT TEXTURE = uTexture2
                float4 textureColor1 = SampleColorWithSingleIndirectTexture(
                    textureColor2, TexSampler1, Tex1.xy);
                    
                bool selectAlphaMax1 = SelectAlphaMaxStage1 == 1;
                CombineColor(textureColor1, colorMode1, selectAlphaMax1, textureColor);
            }
            else
            {
                if (COMBINE_INDIRECT <= colorMode2)
                {
                    // INDIRECT TEXTURE = uTexture2
                    textureColor = tex2D(TexSampler0, Tex0.xy);
                    float4 textureColor3 = SampleColorWithSingleIndirectTexture(
                        textureColor2, TexSampler1, Tex1.xy);
                    
                    CombineColor(textureColor3, colorMode1, selectAlphaMax1, textureColor);
                }
                else
                {
                    // MULTI TEXTURE
                    textureColor = tex2D(TexSampler0, Tex0.xy);
                    CombineColor(tex2D(TexSampler1, Tex1.xy), colorMode1, selectAlphaMax1, textureColor);
                    
                    if (COMBINE_REPLACE <= colorMode2)
                    {
                        bool selectAlphaMax2 = 0;
                        if (EnabledTextureCount == 3)
                        {
                            selectAlphaMax2 = SelectAlphaMaxStage2 == 1;
                        }
                        CombineColor(textureColor2, colorMode2, selectAlphaMax2, textureColor);
                    }
                }
            }
        }
    }

    textureColor = InterpolateOffset + InterpolateWidth * textureColor;
   
	float4 deafultShaderColor = Color * textureColor;

    if (ProceduralShapeEnabled == 1)
    {
        return ApplyProceduralShape(deafultShaderColor, vLocalPosition);
    }
    else
    {
        return deafultShaderColor;
    }
}
