﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Text;
using System.Runtime.InteropServices;

namespace LECore.Win32
{
    /// <summary>
    /// kernel32.dll。
    /// </summary>
    public sealed class Kernel32
    {
        // WinBase.h

        /// <summary>
        /// インポート関数。
        /// </summary>
        [DllImport("Kernel32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        public static extern uint GetPrivateProfileInt(string lpAppName, string lpKeyName, int nDefault, string lpFileName);

        /// <summary>
        /// インポート関数。
        /// </summary>
        [DllImport("Kernel32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        public static extern uint GetPrivateProfileString(string lpAppName, string lpKeyName, string lpDefault, StringBuilder lpReturnedString, uint nSize, string lpFileName);

        /// <summary>
        /// インポート関数。
        /// </summary>
        [DllImport("Kernel32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        public static extern bool WritePrivateProfileString(string lpAppName, string lpKeyName, string lpString, string lpFileName);

        /// <summary>
        /// インポート関数。
        /// </summary>
        [DllImport("kernel32.dll")]
        public static extern short QueryPerformanceCounter(ref long tick);

        /// <summary>
        /// インポート関数。
        /// </summary>
        [DllImport("kernel32.dll")]
        public static extern short QueryPerformanceFrequency(ref long tick);

        /// <summary>
        /// インポート関数。
        /// </summary>
        [DllImport("kernel32.dll")]
        public extern static int LoadLibrary(string lpFileName);

        /// <summary>
        /// インポート関数。
        /// </summary>
        [DllImport("kernel32.dll")]
        public extern static bool FreeLibrary(int hModule);


        [DllImport("kernel32.dll", EntryPoint = "CopyMemory", SetLastError = false)]
        public extern static void CopyMemory(IntPtr dest, IntPtr src, uint count);
    }

    /// <summary>
    /// user32.dll。
    /// </summary>
    public sealed class User32
    {
        // WinUser.h

        /// <summary>
        /// インポート関数。
        /// </summary>
        [DllImport("User32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        public static extern bool GetUpdateRect(IntPtr hWnd, ref RECT lpRect, bool bErase);

        /// <summary>
        /// インポート関数。
        /// </summary>
        [DllImport("User32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        public static extern int MessageBox(IntPtr hWnd, string lpText, string lpCaption, int uType);

        /// <summary>
        /// インポート関数。
        /// </summary>
        [DllImport("User32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        public static extern IntPtr SendMessage(IntPtr hWnd, int msg, IntPtr wParam, IntPtr lParam);

        /// <summary>
        /// インポート関数。
        /// </summary>
        [DllImport( "User32.dll", CharSet = CharSet.Auto, SetLastError = true )]
        public static extern IntPtr SendMessage( IntPtr hWnd, int msg, IntPtr wParam, ref COPYDATASTRUCT lParam );


        /// <summary>
        /// インポート関数。
        /// </summary>
        [DllImport("User32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        public static extern IntPtr SendMessage(IntPtr hWnd, int msg, IntPtr wParam, ref RECT lParam);

        /// <summary>
        /// インポート関数。
        /// </summary>
        [DllImport("User32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        public static extern IntPtr SendMessage(IntPtr hWnd, int msg, IntPtr wParam, int[] lParam);

        /// <summary>
        /// インポート関数。
        /// </summary>
        [DllImport("user32.dll", CharSet = CharSet.Auto, SetLastError = true)]
        public static extern IntPtr SendMessage(IntPtr hWnd, int msg, IntPtr wParam, ref HDITEM lParam);

        [DllImport("user32.dll", CharSet = CharSet.Auto)]
        public static extern IntPtr SendMessage(IntPtr hWnd, uint Msg, int wParam, ref TVITEM lParam);

        [DllImport("user32.dll", CharSet = CharSet.Auto)]
        public static extern IntPtr SendMessage(IntPtr hWnd, uint Msg, int wParam, ref LVITEM lParam);

        [DllImport("User32.dll", CharSet = CharSet.Auto, SetLastError = true)]
        public static extern IntPtr SendMessage(IntPtr hWnd, int Msg, int wParam, int lParam);


        /// <summary>
        /// インポート関数。
        /// </summary>
        [DllImport("User32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        public static extern IntPtr BeginPaint(IntPtr hWnd, ref PAINTSTRUCT lpPaint);

        /// <summary>
        /// インポート関数。
        /// </summary>
        [DllImport("User32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        public static extern bool EndPaint(IntPtr hWnd, ref PAINTSTRUCT lpPaint);

        /// <summary>
        /// インポート関数。
        /// </summary>
        [DllImport("User32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        public static extern bool SetWindowPlacement(IntPtr hWnd, ref WINDOWPLACEMENT lpwndpl);

        /// <summary>
        /// インポート関数。
        /// </summary>
        [DllImport("user32.dll", SetLastError = true)]
        public static extern IntPtr GetWindow(IntPtr hWnd, uint uCmd);

        /// <summary>
        /// インポート関数。
        /// </summary>
        [DllImport("user32.dll")]
        [return: MarshalAs(UnmanagedType.Bool)]
        public static extern bool IsWindowVisible(IntPtr hWnd);

        /// <summary>
        /// インポート関数。
        /// </summary>
        [DllImport("User32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        public static extern bool GetWindowPlacement(IntPtr hWnd, ref WINDOWPLACEMENT lpwndpl);

        /// <summary>
        /// インポート関数。
        /// </summary>
        [DllImport("user32.dll", CharSet = CharSet.Auto, SetLastError = true)]
        public static extern bool GetWindowRect(IntPtr hWnd, ref RECT lpRect);

        /// <summary>
        /// インポート関数。
        /// </summary>
        [DllImport("User32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        public static extern int SetWindowLong(IntPtr hWnd, int nIndex, int dwNewLong);

        /// <summary>
        /// インポート関数。
        /// </summary>
        [DllImport("User32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        public static extern int GetWindowLong(IntPtr hWnd, int nIndex);

        /// <summary>
        /// インポート関数。
        /// </summary>
        [DllImport("User32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        public static extern bool DrawFocusRect(IntPtr hDC, ref RECT lprc);

        /// <summary>
        /// インポート関数。
        /// </summary>
        [DllImport("user32.dll", SetLastError = true)]
        public static extern short GetKeyState(int nVirtKey);

        /// <summary>
        /// インポート関数。
        /// </summary>
        [DllImport( "user32.dll", SetLastError = true )]
        public static extern bool ValidateRect( IntPtr hWnd, System.Drawing.Rectangle lpRect );

        /// <summary>
        /// インポート関数。
        /// </summary>
        [DllImport( "user32.dll" )]
        public static extern bool SetForegroundWindow( IntPtr hWnd );

        [DllImport("user32.dll")]
        public static extern IntPtr FindWindow(string lpClassName,string lpWindowName);

        #region　GetScrollPos 関数

        [DllImport( "USER32.DLL", CharSet = CharSet.Auto )]
        public static extern int GetScrollPos( System.IntPtr handle, int nBar );

        [DllImport( "USER32.dll" )]
        public static extern int SetScrollPos( IntPtr hWnd, int nBar, int nPos, bool bRedraw );

        #endregion
    }

    /// <summary>
    /// Shell32.dll。
    /// </summary>
    public sealed class Shell32
    {
        //[DllImport( "shell32.dll", CharSet = CharSet.Ansi )]
        //public static extern void SHAddToRecentDocs( uint flag, string path );

        //[DllImport("Shell32.dll", CharSet = CharSet.Unicode)]
        //public static extern void SHAddToRecentDocs(uint flags, string file);

        [DllImport("Shell32.dll", BestFitMapping = false, ThrowOnUnmappableChar = true)]
        public static extern void SHAddToRecentDocs(uint flags, [MarshalAs(UnmanagedType.LPStr)]string file);

        [DllImport( "shell32.dll" )]
        public static extern void SHAddToRecentDocs( uint flag, IntPtr pidl );
    }

    /// <summary>
    /// gdi32.dll。
    /// </summary>
    public sealed class Gdi32
    {
        // WinGDI.h

        /// <summary>
        /// インポート関数。
        /// </summary>
        [DllImport("Gdi32.dll", CharSet=CharSet.Auto, SetLastError=true)]
        public static extern bool BitBlt(IntPtr hdcDest, int nXDest, int nYDest, int nWidth, int nHeight, IntPtr hdcSrc, int nXSrc, int nYSrc, int dwRop);
    }

    /// <summary>
    /// Core.dll。
    /// </summary>
    public sealed class Imm32
    {
        [DllImport( "Imm32.dll", SetLastError = true )]
        public static extern IntPtr ImmGetContext( IntPtr hWnd );

        [DllImport( "Imm32.dll" )]
        public static extern bool ImmReleaseContext( IntPtr hWnd, IntPtr hIMC );

        [DllImport( "imm32.dll" )]
        public static extern bool ImmGetOpenStatus( IntPtr hIMC );

        [DllImport( "imm32.dll" )]
        public static extern bool ImmSetOpenStatus( IntPtr hIMC, bool flag );
    }
}
