﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Runtime.InteropServices;

namespace LECore.Win32
{
    // WinUser.h

    #region WS
    /// <summary>
    /// ウインドウスタイル。
    /// </summary>
    public sealed class WS
    {
        private WS() {}
        /// <summary>0x00000000</summary>
        public const int WS_OVERLAPPED       = 0x00000000;
        /// <summary>0x80000000</summary>
        public const int WS_POPUP            = unchecked((int)0x80000000);
        /// <summary>0x40000000</summary>
        public const int WS_CHILD            = 0x40000000;
        /// <summary>0x20000000</summary>
        public const int WS_MINIMIZE         = 0x20000000;
        /// <summary>0x10000000</summary>
        public const int WS_VISIBLE          = 0x10000000;
        /// <summary>0x08000000</summary>
        public const int WS_DISABLED         = 0x08000000;
        /// <summary>0x04000000</summary>
        public const int WS_CLIPSIBLINGS     = 0x04000000;
        /// <summary>0x02000000</summary>
        public const int WS_CLIPCHILDREN     = 0x02000000;
        /// <summary>0x01000000</summary>
        public const int WS_MAXIMIZE         = 0x01000000;
        /// <summary>0x00C00000</summary>
        public const int WS_CAPTION          = 0x00C00000; // WS_BORDER | WS_DLGFRAME
        /// <summary>0x00800000</summary>
        public const int WS_BORDER           = 0x00800000;
        /// <summary>0x00400000</summary>
        public const int WS_DLGFRAME         = 0x00400000;
        /// <summary>0x00200000</summary>
        public const int WS_VSCROLL          = 0x00200000;
        /// <summary>0x00100000</summary>
        public const int WS_HSCROLL          = 0x00100000;
        /// <summary>0x00080000</summary>
        public const int WS_SYSMENU          = 0x00080000;
        /// <summary>0x00040000</summary>
        public const int WS_THICKFRAME       = 0x00040000;
        /// <summary>0x00020000</summary>
        public const int WS_GROUP            = 0x00020000;
        /// <summary>0x00010000</summary>
        public const int WS_TABSTOP          = 0x00010000;
        /// <summary>0x00020000</summary>
        public const int WS_MINIMIZEBOX      = 0x00020000;
        /// <summary>0x00010000</summary>
        public const int WS_MAXIMIZEBOX      = 0x00010000;
        /// <summary>(WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | WS_THICKFRAME | WS_MINIMIZEBOX | WS_MAXIMIZEBOX)</summary>
        public const int WS_OVERLAPPEDWINDOW = (WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | WS_THICKFRAME | WS_MINIMIZEBOX | WS_MAXIMIZEBOX);
        /// <summary>(WS_POPUP | WS_BORDER | WS_SYSMENU)</summary>
        public const int WS_POPUPWINDOW      = (WS_POPUP | WS_BORDER | WS_SYSMENU);
        /// <summary>WS_CHILD</summary>
        public const int WS_CHILDWINDOW      = (WS_CHILD);
        /// <summary>WS_OVERLAPPED</summary>
        public const int WS_TILED            = WS_OVERLAPPED;
        /// <summary>WS_MINIMIZE</summary>
        public const int WS_ICONIC           = WS_MINIMIZE;
        /// <summary>WS_THICKFRAME</summary>
        public const int WS_SIZEBOX          = WS_THICKFRAME;
        /// <summary>WS_OVERLAPPEDWINDOW</summary>
        public const int WS_TILEDWINDOW      = WS_OVERLAPPEDWINDOW;
    }
    #endregion

    #region WS_EX
    /// <summary>
    /// 拡張ウインドウスタイル。
    /// </summary>
    public sealed class WS_EX
    {
        private WS_EX() {}
        /// <summary>0x00000001</summary>
        public const int WS_EX_DLGMODALFRAME    = 0x00000001;
        /// <summary>0x00000004</summary>
        public const int WS_EX_NOPARENTNOTIFY   = 0x00000004;
        /// <summary>0x00000008</summary>
        public const int WS_EX_TOPMOST          = 0x00000008;
        /// <summary>0x00000010</summary>
        public const int WS_EX_ACCEPTFILES      = 0x00000010;
        /// <summary>0x00000020</summary>
        public const int WS_EX_TRANSPARENT      = 0x00000020;
        /// <summary>0x00000040</summary>
        public const int WS_EX_MDICHILD         = 0x00000040;
        /// <summary>0x00000080</summary>
        public const int WS_EX_TOOLWINDOW       = 0x00000080;
        /// <summary>0x00000100</summary>
        public const int WS_EX_WINDOWEDGE       = 0x00000100;
        /// <summary>0x00000200</summary>
        public const int WS_EX_CLIENTEDGE       = 0x00000200;
        /// <summary>0x00000400</summary>
        public const int WS_EX_CONTEXTHELP      = 0x00000400;
        /// <summary>0x00001000</summary>
        public const int WS_EX_RIGHT            = 0x00001000;
        /// <summary>0x00000000</summary>
        public const int WS_EX_LEFT             = 0x00000000;
        /// <summary>0x00002000</summary>
        public const int WS_EX_RTLREADING       = 0x00002000;
        /// <summary>0x00000000</summary>
        public const int WS_EX_LTRREADING       = 0x00000000;
        /// <summary>0x00004000</summary>
        public const int WS_EX_LEFTSCROLLBAR    = 0x00004000;
        /// <summary>0x00000000</summary>
        public const int WS_EX_RIGHTSCROLLBAR   = 0x00000000;
        /// <summary>0x00010000</summary>
        public const int WS_EX_CONTROLPARENT    = 0x00010000;
        /// <summary>0x00020000</summary>
        public const int WS_EX_STATICEDGE       = 0x00020000;
        /// <summary>0x00040000</summary>
        public const int WS_EX_APPWINDOW        = 0x00040000;
        /// <summary>(WS_EX_WINDOWEDGE | WS_EX_CLIENTEDGE)</summary>
        public const int WS_EX_OVERLAPPEDWINDOW = (WS_EX_WINDOWEDGE | WS_EX_CLIENTEDGE);
        /// <summary>(WS_EX_WINDOWEDGE | WS_EX_TOOLWINDOW | WS_EX_TOPMOST)</summary>
        public const int WS_EX_PALETTEWINDOW    = (WS_EX_WINDOWEDGE | WS_EX_TOOLWINDOW | WS_EX_TOPMOST);
        /// <summary>0x00080000</summary>
        public const int WS_EX_LAYERED          = 0x00080000;
        /// <summary>0x00100000</summary>
        public const int WS_EX_NOINHERITLAYOUT  = 0x00100000; // Disable inheritence of mirroring by children
        /// <summary>0x00400000</summary>
        public const int WS_EX_LAYOUTRTL        = 0x00400000; // Right to left mirroring
        /// <summary>0x02000000</summary>
        public const int WS_EX_COMPOSITED       = 0x02000000;
        /// <summary>0x08000000</summary>
        public const int WS_EX_NOACTIVATE       = 0x08000000;
    }
    #endregion

    #region WPF
    /// <summary>
    /// ウインドウ配置情報フラグ。
    /// </summary>
    public sealed class WPF
    {
        private WPF() {}
        /// <summary>0x0001</summary>
        public const int WPF_SETMINPOSITION         = 0x0001;
        /// <summary>0x0002</summary>
        public const int WPF_RESTORETOMAXIMIZED     = 0x0002;
        /// <summary>0x0004</summary>
        public const int WPF_ASYNCWINDOWPLACEMENT   = 0x0004;
    }
    #endregion

    #region SW
    /// <summary>
    /// ウインドウ表示フラグ。
    /// </summary>
    public sealed class SW
    {
        private SW() {}
        /// <summary>0</summary>
        public const int SW_HIDE            = 0;
        /// <summary>1</summary>
        public const int SW_SHOWNORMAL      = 1;
        /// <summary>1</summary>
        public const int SW_NORMAL          = 1;
        /// <summary>2</summary>
        public const int SW_SHOWMINIMIZED   = 2;
        /// <summary>3</summary>
        public const int SW_SHOWMAXIMIZED   = 3;
        /// <summary>3</summary>
        public const int SW_MAXIMIZE        = 3;
        /// <summary>4</summary>
        public const int SW_SHOWNOACTIVATE  = 4;
        /// <summary>5</summary>
        public const int SW_SHOW            = 5;
        /// <summary>6</summary>
        public const int SW_MINIMIZE        = 6;
        /// <summary>7</summary>
        public const int SW_SHOWMINNOACTIVE = 7;
        /// <summary>8</summary>
        public const int SW_SHOWNA          = 8;
        /// <summary>9</summary>
        public const int SW_RESTORE         = 9;
        /// <summary>10</summary>
        public const int SW_SHOWDEFAULT     = 10;
        /// <summary>11</summary>
        public const int SW_FORCEMINIMIZE   = 11;
        /// <summary>11</summary>
        public const int SW_MAX             = 11;
    }
    #endregion

    #region MA
    /// <summary>
    /// WM_MOUSEACTIVATE Return Codes。
    /// </summary>
    public static class MA
    {
        /// <summary></summary>
        public const int MA_ACTIVATE         = 1;
        /// <summary></summary>
        public const int MA_ACTIVATEANDEAT   = 2;
        /// <summary></summary>
        public const int MA_NOACTIVATE       = 3;
        /// <summary></summary>
        public const int MA_NOACTIVATEANDEAT = 4;
    }
    #endregion

    #region WM
    /// <summary>
    /// ウインドウメッセージ。
    /// </summary>
    public sealed class WM
    {
        private WM() {}
        /// <summary>0x0000</summary>
        public const int WM_NULL                   = 0x0000;
        /// <summary>0x0001</summary>
        public const int WM_CREATE                 = 0x0001;
        /// <summary>0x0002</summary>
        public const int WM_DESTROY                = 0x0002;
        /// <summary>0x0003</summary>
        public const int WM_MOVE                   = 0x0003;
        /// <summary>0x0005</summary>
        public const int WM_SIZE                   = 0x0005;
        /// <summary>0x0006</summary>
        public const int WM_ACTIVATE               = 0x0006;
        /// <summary>0x0007</summary>
        public const int WM_SETFOCUS               = 0x0007;
        /// <summary>0x0008</summary>
        public const int WM_KILLFOCUS              = 0x0008;
        /// <summary>0x000A</summary>
        public const int WM_ENABLE                 = 0x000A;
        /// <summary>0x000B</summary>
        public const int WM_SETREDRAW              = 0x000B;
        /// <summary>0x000C</summary>
        public const int WM_SETTEXT                = 0x000C;
        /// <summary>0x000D</summary>
        public const int WM_GETTEXT                = 0x000D;
        /// <summary>0x000E</summary>
        public const int WM_GETTEXTLENGTH          = 0x000E;
        /// <summary>0x000F</summary>
        public const int WM_PAINT                  = 0x000F;
        /// <summary>0x0010</summary>
        public const int WM_CLOSE                  = 0x0010;
        /// <summary>0x0011</summary>
        public const int WM_QUERYENDSESSION        = 0x0011;
        /// <summary>0x0013</summary>
        public const int WM_QUERYOPEN              = 0x0013;
        /// <summary>0x0016</summary>
        public const int WM_ENDSESSION             = 0x0016;
        /// <summary>0x0012</summary>
        public const int WM_QUIT                   = 0x0012;
        /// <summary>0x0014</summary>
        public const int WM_ERASEBKGND             = 0x0014;
        /// <summary>0x0015</summary>
        public const int WM_SYSCOLORCHANGE         = 0x0015;
        /// <summary>0x0018</summary>
        public const int WM_SHOWWINDOW             = 0x0018;
        /// <summary>0x0019</summary>
        public const int WM_CTLCOLOR               = 0x0019;	// WindowsX.h で定義
        /// <summary>0x001A</summary>
        public const int WM_WININICHANGE           = 0x001A;
        /// <summary>WM_WININICHANGE</summary>
        public const int WM_SETTINGCHANGE          = WM_WININICHANGE;
        /// <summary>0x001B</summary>
        public const int WM_DEVMODECHANGE          = 0x001B;
        /// <summary>0x001C</summary>
        public const int WM_ACTIVATEAPP            = 0x001C;
        /// <summary>0x001D</summary>
        public const int WM_FONTCHANGE             = 0x001D;
        /// <summary>0x001E</summary>
        public const int WM_TIMECHANGE             = 0x001E;
        /// <summary>0x001F</summary>
        public const int WM_CANCELMODE             = 0x001F;
        /// <summary>0x0020</summary>
        public const int WM_SETCURSOR              = 0x0020;
        /// <summary>0x0021</summary>
        public const int WM_MOUSEACTIVATE          = 0x0021;
        /// <summary>0x0022</summary>
        public const int WM_CHILDACTIVATE          = 0x0022;
        /// <summary>0x0023</summary>
        public const int WM_QUEUESYNC              = 0x0023;
        /// <summary>0x0024</summary>
        public const int WM_GETMINMAXINFO          = 0x0024;
        /// <summary>0x0026</summary>
        public const int WM_PAINTICON              = 0x0026;
        /// <summary>0x0027</summary>
        public const int WM_ICONERASEBKGND         = 0x0027;
        /// <summary>0x0028</summary>
        public const int WM_NEXTDLGCTL             = 0x0028;
        /// <summary>0x002A</summary>
        public const int WM_SPOOLERSTATUS          = 0x002A;
        /// <summary>0x002B</summary>
        public const int WM_DRAWITEM               = 0x002B;
        /// <summary>0x002C</summary>
        public const int WM_MEASUREITEM            = 0x002C;
        /// <summary>0x002D</summary>
        public const int WM_DELETEITEM             = 0x002D;
        /// <summary>0x002E</summary>
        public const int WM_VKEYTOITEM             = 0x002E;
        /// <summary>0x002F</summary>
        public const int WM_CHARTOITEM             = 0x002F;
        /// <summary>0x0030</summary>
        public const int WM_SETFONT                = 0x0030;
        /// <summary>0x0031</summary>
        public const int WM_GETFONT                = 0x0031;
        /// <summary>0x0032</summary>
        public const int WM_SETHOTKEY              = 0x0032;
        /// <summary>0x0033</summary>
        public const int WM_GETHOTKEY              = 0x0033;
        /// <summary>0x0037</summary>
        public const int WM_QUERYDRAGICON          = 0x0037;
        /// <summary>0x0039</summary>
        public const int WM_COMPAREITEM            = 0x0039;
        /// <summary>0x003D</summary>
        public const int WM_GETOBJECT              = 0x003D;
        /// <summary>0x0041</summary>
        public const int WM_COMPACTING             = 0x0041;
        /// <summary>0x0044</summary>
        public const int WM_COMMNOTIFY             = 0x0044;	// no longer suported
        /// <summary>0x0046</summary>
        public const int WM_WINDOWPOSCHANGING      = 0x0046;
        /// <summary>0x0047</summary>
        public const int WM_WINDOWPOSCHANGED       = 0x0047;
        /// <summary>0x0048</summary>
        public const int WM_POWER                  = 0x0048;
        /// <summary>0x004A</summary>
        public const int WM_COPYDATA               = 0x004A;
        /// <summary>0x004B</summary>
        public const int WM_CANCELJOURNAL          = 0x004B;
        /// <summary>0x004E</summary>
        public const int WM_NOTIFY                 = 0x004E;
        /// <summary>0x0050</summary>
        public const int WM_INPUTLANGCHANGEREQUEST = 0x0050;
        /// <summary>0x0051</summary>
        public const int WM_INPUTLANGCHANGE        = 0x0051;
        /// <summary>0x0052</summary>
        public const int WM_TCARD                  = 0x0052;
        /// <summary>0x0053</summary>
        public const int WM_HELP                   = 0x0053;
        /// <summary>0x0054</summary>
        public const int WM_USERCHANGED            = 0x0054;
        /// <summary>0x0055</summary>
        public const int WM_NOTIFYFORMAT           = 0x0055;
        /// <summary>0x007B</summary>
        public const int WM_CONTEXTMENU            = 0x007B;
        /// <summary>0x007C</summary>
        public const int WM_STYLECHANGING          = 0x007C;
        /// <summary>0x007D</summary>
        public const int WM_STYLECHANGED           = 0x007D;
        /// <summary>0x007E</summary>
        public const int WM_DISPLAYCHANGE          = 0x007E;
        /// <summary>0x007F</summary>
        public const int WM_GETICON                = 0x007F;
        /// <summary>0x0080</summary>
        public const int WM_SETICON                = 0x0080;
        /// <summary>0x0081</summary>
        public const int WM_NCCREATE               = 0x0081;
        /// <summary>0x0082</summary>
        public const int WM_NCDESTROY              = 0x0082;
        /// <summary>0x0083</summary>
        public const int WM_NCCALCSIZE             = 0x0083;
        /// <summary>0x0084</summary>
        public const int WM_NCHITTEST              = 0x0084;
        /// <summary>0x0085</summary>
        public const int WM_NCPAINT                = 0x0085;
        /// <summary>0x0086</summary>
        public const int WM_NCACTIVATE             = 0x0086;
        /// <summary>0x0087</summary>
        public const int WM_GETDLGCODE             = 0x0087;
        /// <summary>0x0088</summary>
        public const int WM_SYNCPAINT              = 0x0088;
        /// <summary>0x00A0</summary>
        public const int WM_NCMOUSEMOVE            = 0x00A0;
        /// <summary>0x00A1</summary>
        public const int WM_NCLBUTTONDOWN          = 0x00A1;
        /// <summary>0x00A2</summary>
        public const int WM_NCLBUTTONUP            = 0x00A2;
        /// <summary>0x00A3</summary>
        public const int WM_NCLBUTTONDBLCLK        = 0x00A3;
        /// <summary>0x00A4</summary>
        public const int WM_NCRBUTTONDOWN          = 0x00A4;
        /// <summary>0x00A5</summary>
        public const int WM_NCRBUTTONUP            = 0x00A5;
        /// <summary>0x00A6</summary>
        public const int WM_NCRBUTTONDBLCLK        = 0x00A6;
        /// <summary>0x00A7</summary>
        public const int WM_NCMBUTTONDOWN          = 0x00A7;
        /// <summary>0x00A8</summary>
        public const int WM_NCMBUTTONUP            = 0x00A8;
        /// <summary>0x00A9</summary>
        public const int WM_NCMBUTTONDBLCLK        = 0x00A9;
        /// <summary>0x00AB</summary>
        public const int WM_NCXBUTTONDOWN          = 0x00AB;
        /// <summary>0x00AC</summary>
        public const int WM_NCXBUTTONUP            = 0x00AC;
        /// <summary>0x00AD</summary>
        public const int WM_NCXBUTTONDBLCLK        = 0x00AD;
        /// <summary>0x00FF</summary>
        public const int WM_INPUT                  = 0x00FF;
        /// <summary>0x0100</summary>
        public const int WM_KEYFIRST               = 0x0100;
        /// <summary>0x0100</summary>
        public const int WM_KEYDOWN                = 0x0100;
        /// <summary>0x0101</summary>
        public const int WM_KEYUP                  = 0x0101;
        /// <summary>0x0102</summary>
        public const int WM_CHAR                   = 0x0102;
        /// <summary>0x0103</summary>
        public const int WM_DEADCHAR               = 0x0103;
        /// <summary>0x0104</summary>
        public const int WM_SYSKEYDOWN             = 0x0104;
        /// <summary>0x0105</summary>
        public const int WM_SYSKEYUP               = 0x0105;
        /// <summary>0x0106</summary>
        public const int WM_SYSCHAR                = 0x0106;
        /// <summary>0x0107</summary>
        public const int WM_SYSDEADCHAR            = 0x0107;
        /// <summary>0x0109</summary>
        public const int WM_UNICHAR                = 0x0109;
        /// <summary>0x0109</summary>
        public const int WM_KEYLAST_forXPLater     = 0x0109; // _WIN32_WINNT >= 0x501
        /// <summary>0x0108</summary>
        public const int WM_KEYLAST                = 0x0108;
        /// <summary>0x010D</summary>
        public const int WM_IME_STARTCOMPOSITION   = 0x010D;
        /// <summary>0x010E</summary>
        public const int WM_IME_ENDCOMPOSITION     = 0x010E;
        /// <summary>0x010F</summary>
        public const int WM_IME_COMPOSITION        = 0x010F;
        /// <summary>0x010F</summary>
        public const int WM_IME_KEYLAST            = 0x010F;
        /// <summary>0x0110</summary>
        public const int WM_INITDIALOG             = 0x0110;
        /// <summary>0x0111</summary>
        public const int WM_COMMAND                = 0x0111;
        /// <summary>0x0112</summary>
        public const int WM_SYSCOMMAND             = 0x0112;
        /// <summary>0x0113</summary>
        public const int WM_TIMER                  = 0x0113;
        /// <summary>0x0114</summary>
        public const int WM_HSCROLL                = 0x0114;
        /// <summary>0x0115</summary>
        public const int WM_VSCROLL                = 0x0115;
        /// <summary>0x0116</summary>
        public const int WM_INITMENU               = 0x0116;
        /// <summary>0x0117</summary>
        public const int WM_INITMENUPOPUP          = 0x0117;
        /// <summary>0x011F</summary>
        public const int WM_MENUSELECT             = 0x011F;
        /// <summary>0x0120</summary>
        public const int WM_MENUCHAR               = 0x0120;
        /// <summary>0x0121</summary>
        public const int WM_ENTERIDLE              = 0x0121;
        /// <summary>0x0122</summary>
        public const int WM_MENURBUTTONUP          = 0x0122;
        /// <summary>0x0123</summary>
        public const int WM_MENUDRAG               = 0x0123;
        /// <summary>0x0124</summary>
        public const int WM_MENUGETOBJECT          = 0x0124;
        /// <summary>0x0125</summary>
        public const int WM_UNINITMENUPOPUP        = 0x0125;
        /// <summary>0x0126</summary>
        public const int WM_MENUCOMMAND            = 0x0126;
        /// <summary>0x0127</summary>
        public const int WM_CHANGEUISTATE          = 0x0127;
        /// <summary>0x0128</summary>
        public const int WM_UPDATEUISTATE          = 0x0128;
        /// <summary>0x0129</summary>
        public const int WM_QUERYUISTATE           = 0x0129;
        /// <summary>0x0132</summary>
        public const int WM_CTLCOLORMSGBOX         = 0x0132;
        /// <summary>0x0133</summary>
        public const int WM_CTLCOLOREDIT           = 0x0133;
        /// <summary>0x0134</summary>
        public const int WM_CTLCOLORLISTBOX        = 0x0134;
        /// <summary>0x0135</summary>
        public const int WM_CTLCOLORBTN            = 0x0135;
        /// <summary>0x0136</summary>
        public const int WM_CTLCOLORDLG            = 0x0136;
        /// <summary>0x0137</summary>
        public const int WM_CTLCOLORSCROLLBAR      = 0x0137;
        /// <summary>0x0138</summary>
        public const int WM_CTLCOLORSTATIC         = 0x0138;
        /// <summary>0x0200</summary>
        public const int WM_MOUSEFIRST             = 0x0200;
        /// <summary>0x0200</summary>
        public const int WM_MOUSEMOVE              = 0x0200;
        /// <summary>0x0201</summary>
        public const int WM_LBUTTONDOWN            = 0x0201;
        /// <summary>0x0202</summary>
        public const int WM_LBUTTONUP              = 0x0202;
        /// <summary>0x0202</summary>
        public const int WM_LBUTTONDBLCLK          = 0x0203;
        /// <summary>0x0204</summary>
        public const int WM_RBUTTONDOWN            = 0x0204;
        /// <summary>0x0205</summary>
        public const int WM_RBUTTONUP              = 0x0205;
        /// <summary>0x0206</summary>
        public const int WM_RBUTTONDBLCLK          = 0x0206;
        /// <summary>0x0207</summary>
        public const int WM_MBUTTONDOWN            = 0x0207;
        /// <summary>0x0208</summary>
        public const int WM_MBUTTONUP              = 0x0208;
        /// <summary>0x0209</summary>
        public const int WM_MBUTTONDBLCLK          = 0x0209;
        /// <summary>0x020A</summary>
        public const int WM_MOUSEWHEEL             = 0x020A;
        /// <summary>0x020B</summary>
        public const int WM_XBUTTONDOWN            = 0x020B;
        /// <summary>0x020C</summary>
        public const int WM_XBUTTONUP              = 0x020C;
        /// <summary>0x020D</summary>
        public const int WM_XBUTTONDBLCLK          = 0x020D;
        /// <summary>0x020D</summary>
        public const int WM_MOUSELAST_for2KLater   = 0x020D;
        /// <summary>0x020A</summary>
        public const int WM_MOUSELAST_forNT        = 0x020A;
        /// <summary>0x0209</summary>
        public const int WM_MOUSELAST              = 0x0209;
        /// <summary>0x0210</summary>
        public const int WM_PARENTNOTIFY           = 0x0210;
        /// <summary>0x0211</summary>
        public const int WM_ENTERMENULOOP          = 0x0211;
        /// <summary>0x0212</summary>
        public const int WM_EXITMENULOOP           = 0x0212;
        /// <summary>0x0213</summary>
        public const int WM_NEXTMENU               = 0x0213;
        /// <summary>0x0214</summary>
        public const int WM_SIZING                 = 0x0214;
        /// <summary>0x0215</summary>
        public const int WM_CAPTURECHANGED         = 0x0215;
        /// <summary>0x0216</summary>
        public const int WM_MOVING                 = 0x0216;
        /// <summary>0x0218</summary>
        public const int WM_POWERBROADCAST         = 0x0218;
        /// <summary>0x0219</summary>
        public const int WM_DEVICECHANGE           = 0x0219;
        /// <summary>0x0220</summary>
        public const int WM_MDICREATE              = 0x0220;
        /// <summary>0x0221</summary>
        public const int WM_MDIDESTROY             = 0x0221;
        /// <summary>0x0222</summary>
        public const int WM_MDIACTIVATE            = 0x0222;
        /// <summary>0x0223</summary>
        public const int WM_MDIRESTORE             = 0x0223;
        /// <summary>0x0224</summary>
        public const int WM_MDINEXT                = 0x0224;
        /// <summary>0x0225</summary>
        public const int WM_MDIMAXIMIZE            = 0x0225;
        /// <summary>0x0226</summary>
        public const int WM_MDITILE                = 0x0226;
        /// <summary>0x0227</summary>
        public const int WM_MDICASCADE             = 0x0227;
        /// <summary>0x0228</summary>
        public const int WM_MDIICONARRANGE         = 0x0228;
        /// <summary>0x0229</summary>
        public const int WM_MDIGETACTIVE           = 0x0229;
        /// <summary>0x0230</summary>
        public const int WM_MDISETMENU             = 0x0230;
        /// <summary>0x0231</summary>
        public const int WM_ENTERSIZEMOVE          = 0x0231;
        /// <summary>0x0232</summary>
        public const int WM_EXITSIZEMOVE           = 0x0232;
        /// <summary>0x0233</summary>
        public const int WM_DROPFILES              = 0x0233;
        /// <summary>0x0234</summary>
        public const int WM_MDIREFRESHMENU         = 0x0234;
        /// <summary>0x0281</summary>
        public const int WM_IME_SETCONTEXT         = 0x0281;
        /// <summary>0x0282</summary>
        public const int WM_IME_NOTIFY             = 0x0282;
        /// <summary>0x0283</summary>
        public const int WM_IME_CONTROL            = 0x0283;
        /// <summary>0x0284</summary>
        public const int WM_IME_COMPOSITIONFULL    = 0x0284;
        /// <summary>0x0285</summary>
        public const int WM_IME_SELECT             = 0x0285;
        /// <summary>0x0286</summary>
        public const int WM_IME_CHAR               = 0x0286;
        /// <summary>0x0288</summary>
        public const int WM_IME_REQUEST            = 0x0288;
        /// <summary>0x0290</summary>
        public const int WM_IME_KEYDOWN            = 0x0290;
        /// <summary>0x0291</summary>
        public const int WM_IME_KEYUP              = 0x0291;
        /// <summary>0x02A1</summary>
        public const int WM_MOUSEHOVER             = 0x02A1;
        /// <summary>0x02A3</summary>
        public const int WM_MOUSELEAVE             = 0x02A3;
        /// <summary>0x02A0</summary>
        public const int WM_NCMOUSEHOVER           = 0x02A0;
        /// <summary>0x02A2</summary>
        public const int WM_NCMOUSELEAVE           = 0x02A2;
        /// <summary>0x02B1</summary>
        public const int WM_WTSSESSION_CHANGE      = 0x02B1;
        /// <summary>0x02c0</summary>
        public const int WM_TABLET_FIRST           = 0x02c0;
        /// <summary>0x02df</summary>
        public const int WM_TABLET_LAST            = 0x02df;
        /// <summary>0x0300</summary>
        public const int WM_CUT                    = 0x0300;
        /// <summary>0x0301</summary>
        public const int WM_COPY                   = 0x0301;
        /// <summary>0x0302</summary>
        public const int WM_PASTE                  = 0x0302;
        /// <summary>0x0303</summary>
        public const int WM_CLEAR                  = 0x0303;
        /// <summary>0x0304</summary>
        public const int WM_UNDO                   = 0x0304;
        /// <summary>0x0305</summary>
        public const int WM_RENDERFORMAT           = 0x0305;
        /// <summary>0x0306</summary>
        public const int WM_RENDERALLFORMATS       = 0x0306;
        /// <summary>0x0307</summary>
        public const int WM_DESTROYCLIPBOARD       = 0x0307;
        /// <summary>0x0308</summary>
        public const int WM_DRAWCLIPBOARD          = 0x0308;
        /// <summary>0x0309</summary>
        public const int WM_PAINTCLIPBOARD         = 0x0309;
        /// <summary>0x030A</summary>
        public const int WM_VSCROLLCLIPBOARD       = 0x030A;
        /// <summary>0x030B</summary>
        public const int WM_SIZECLIPBOARD          = 0x030B;
        /// <summary>0x030C</summary>
        public const int WM_ASKCBFORMATNAME        = 0x030C;
        /// <summary>0x030D</summary>
        public const int WM_CHANGECBCHAIN          = 0x030D;
        /// <summary>0x030E</summary>
        public const int WM_HSCROLLCLIPBOARD       = 0x030E;
        /// <summary>0x030F</summary>
        public const int WM_QUERYNEWPALETTE        = 0x030F;
        /// <summary>0x0310</summary>
        public const int WM_PALETTEISCHANGING      = 0x0310;
        /// <summary>0x0311</summary>
        public const int WM_PALETTECHANGED         = 0x0311;
        /// <summary>0x0312</summary>
        public const int WM_HOTKEY                 = 0x0312;
        /// <summary>0x0317</summary>
        public const int WM_PRINT                  = 0x0317;
        /// <summary>0x0318</summary>
        public const int WM_PRINTCLIENT            = 0x0318;
        /// <summary>0x0319</summary>
        public const int WM_APPCOMMAND             = 0x0319;
        /// <summary>0x031A</summary>
        public const int WM_THEMECHANGED           = 0x031A;
        /// <summary>0x0358</summary>
        public const int WM_HANDHELDFIRST          = 0x0358;
        /// <summary>0x035F</summary>
        public const int WM_HANDHELDLAST           = 0x035F;
        /// <summary>0x0360</summary>
        public const int WM_AFXFIRST               = 0x0360;
        /// <summary>0x037F</summary>
        public const int WM_AFXLAST                = 0x037F;
        /// <summary>0x0380</summary>
        public const int WM_PENWINFIRST            = 0x0380;
        /// <summary>0x038F</summary>
        public const int WM_PENWINLAST             = 0x038F;
        /// <summary>0x8000</summary>
        public const int WM_APP                    = 0x8000;
        /// <summary>0x0400</summary>
        public const int WM_USER                   = 0x0400;
        /// <summary>0x2000</summary>
        public const int WM_REFLECT                = 0x2000; // 不明（WinUser.hで未定義）
    }
    #endregion

    #region GWL
    /// <summary>
    /// ウインドウパラメタ。
    /// </summary>
    public sealed class GWL
    {
        private GWL() {}
        /// <summary>-4</summary>
        public const int GWL_WNDPROC        = (-4);
        /// <summary>-6</summary>
        public const int GWL_HINSTANCE      = (-6);
        /// <summary>-8</summary>
        public const int GWL_HWNDPARENT     = (-8);
        /// <summary>-16</summary>
        public const int GWL_STYLE          = (-16);
        /// <summary>-20</summary>
        public const int GWL_EXSTYLE        = (-20);
        /// <summary>-21</summary>
        public const int GWL_USERDATA       = (-21);
        /// <summary>-12</summary>
        public const int GWL_ID             = (-12);
    }
    #endregion

    #region MB
    /// <summary>
    /// メッセージボックスフラグ。
    /// </summary>
    public sealed class MB
    {
        private MB() {}
        /// <summary>0x00000000</summary>
        public const int MB_OK                      = 0x00000000;
        /// <summary>0x00000001</summary>
        public const int MB_OKCANCEL                = 0x00000001;
        /// <summary>0x00000002</summary>
        public const int MB_ABORTRETRYIGNORE        = 0x00000002;
        /// <summary>0x00000003</summary>
        public const int MB_YESNOCANCEL             = 0x00000003;
        /// <summary>0x00000004</summary>
        public const int MB_YESNO                   = 0x00000004;
        /// <summary>0x00000005</summary>
        public const int MB_RETRYCANCEL             = 0x00000005;
        /// <summary>0x00000006</summary>
        public const int MB_CANCELTRYCONTINUE       = 0x00000006;
        /// <summary>0x00000010</summary>
        public const int MB_ICONHAND                = 0x00000010;
        /// <summary>0x00000020</summary>
        public const int MB_ICONQUESTION            = 0x00000020;
        /// <summary>0x00000030</summary>
        public const int MB_ICONEXCLAMATION         = 0x00000030;
        /// <summary>0x00000040</summary>
        public const int MB_ICONASTERISK            = 0x00000040;
        /// <summary>0x00000080</summary>
        public const int MB_USERICON                = 0x00000080;
        /// <summary>MB_ICONEXCLAMATION</summary>
        public const int MB_ICONWARNING             = MB_ICONEXCLAMATION;
        /// <summary>MB_ICONHAND</summary>
        public const int MB_ICONERROR               = MB_ICONHAND;
        /// <summary>MB_ICONASTERISK</summary>
        public const int MB_ICONINFORMATION         = MB_ICONASTERISK;
        /// <summary>MB_ICONHAND</summary>
        public const int MB_ICONSTOP                = MB_ICONHAND;
        /// <summary>0x00000000</summary>
        public const int MB_DEFBUTTON1              = 0x00000000;
        /// <summary>0x00000100</summary>
        public const int MB_DEFBUTTON2              = 0x00000100;
        /// <summary>0x00000200</summary>
        public const int MB_DEFBUTTON3              = 0x00000200;
        /// <summary>0x00000300</summary>
        public const int MB_DEFBUTTON4              = 0x00000300;
        /// <summary>0x00000000</summary>
        public const int MB_APPLMODAL               = 0x00000000;
        /// <summary>0x00001000</summary>
        public const int MB_SYSTEMMODAL             = 0x00001000;
        /// <summary>0x00002000</summary>
        public const int MB_TASKMODAL               = 0x00002000;
        /// <summary>0x00004000</summary>
        public const int MB_HELP                    = 0x00004000; // Help Button
        /// <summary>0x00008000</summary>
        public const int MB_NOFOCUS                 = 0x00008000;
        /// <summary>0x00010000</summary>
        public const int MB_SETFOREGROUND           = 0x00010000;
        /// <summary>0x00020000</summary>
        public const int MB_DEFAULT_DESKTOP_ONLY    = 0x00020000;
        /// <summary>0x00040000</summary>
        public const int MB_TOPMOST                 = 0x00040000;
        /// <summary>0x00080000</summary>
        public const int MB_RIGHT                   = 0x00080000;
        /// <summary>0x00100000</summary>
        public const int MB_RTLREADING              = 0x00100000;
        /// <summary>0x00200000</summary>
        public const int MB_SERVICE_NOTIFICATION_forNTLater = 0x00200000;
        /// <summary>0x00040000</summary>
        public const int MB_SERVICE_NOTIFICATION            = 0x00040000;
        /// <summary>0x00040000</summary>
        public const int MB_SERVICE_NOTIFICATION_NT3X       = 0x00040000;
        /// <summary>0x0000000F</summary>
        public const int MB_TYPEMASK                = 0x0000000F;
        /// <summary>0x000000F0</summary>
        public const int MB_ICONMASK                = 0x000000F0;
        /// <summary>0x00000F00</summary>
        public const int MB_DEFMASK                 = 0x00000F00;
        /// <summary>0x00003000</summary>
        public const int MB_MODEMASK                = 0x00003000;
        /// <summary>0x0000C000</summary>
        public const int MB_MISCMASK                = 0x0000C000;
    }
    #endregion

    #region ODT
    /// <summary>
    /// オーナー描画タイプ。
    /// </summary>
    public sealed class ODT
    {
        private ODT() {}
        /// <summary>1</summary>
        public const int ODT_MENU       = 1;
        /// <summary>2</summary>
        public const int ODT_LISTBOX    = 2;
        /// <summary>3</summary>
        public const int ODT_COMBOBOX   = 3;
        /// <summary>4</summary>
        public const int ODT_BUTTON     = 4;
        /// <summary>5</summary>
        public const int ODT_STATIC     = 5;
    }
    #endregion

    #region ODA
    /// <summary>
    /// オーナー描画アクション。
    /// </summary>
    public sealed class ODA
    {
        private ODA() {}
        /// <summary>0x0001</summary>
        public const int ODA_DRAWENTIRE = 0x0001;
        /// <summary>0x0002</summary>
        public const int ODA_SELECT     = 0x0002;
        /// <summary>0x0004</summary>
        public const int ODA_FOCUS      = 0x0004;
    }
    #endregion

    #region ODS
    /// <summary>
    /// オーナー描画状態。
    /// </summary>
    public sealed class ODS
    {
        private ODS() {}
        /// <summary>0x0001</summary>
        public const int ODS_SELECTED       = 0x0001;
        /// <summary>0x0002</summary>
        public const int ODS_GRAYED         = 0x0002;
        /// <summary>0x0004</summary>
        public const int ODS_DISABLED       = 0x0004;
        /// <summary>0x0008</summary>
        public const int ODS_CHECKED        = 0x0008;
        /// <summary>0x0010</summary>
        public const int ODS_FOCUS          = 0x0010;
        /// <summary>0x0020</summary>
        public const int ODS_DEFAULT        = 0x0020;
        /// <summary>0x1000</summary>
        public const int ODS_COMBOBOXEDIT   = 0x1000;
        /// <summary>0x0040</summary>
        public const int ODS_HOTLIGHT       = 0x0040;
        /// <summary>0x0080</summary>
        public const int ODS_INACTIVE       = 0x0080;
        /// <summary>0x0100</summary>
        public const int ODS_NOACCEL        = 0x0100;
        /// <summary>0x0200</summary>
        public const int ODS_NOFOCUSRECT    = 0x0200;
    }
    #endregion

    #region SB
    /// <summary>
    /// スクロールバーフラグ。
    /// </summary>
    public sealed class SB
    {
        private SB() {}
        /// <summary>0</summary>
        public const int SB_HORZ            = 0;
        /// <summary>1</summary>
        public const int SB_VERT            = 1;
        /// <summary>2</summary>
        public const int SB_CTL             = 2;
        /// <summary>3</summary>
        public const int SB_BOTH            = 3;
        /// <summary>0</summary>
        public const int SB_LINEUP          = 0;
        /// <summary>0</summary>
        public const int SB_LINELEFT        = 0;
        /// <summary>1</summary>
        public const int SB_LINEDOWN        = 1;
        /// <summary>1</summary>
        public const int SB_LINERIGHT       = 1;
        /// <summary>2</summary>
        public const int SB_PAGEUP          = 2;
        /// <summary>2</summary>
        public const int SB_PAGELEFT        = 2;
        /// <summary>3</summary>
        public const int SB_PAGEDOWN        = 3;
        /// <summary>3</summary>
        public const int SB_PAGERIGHT       = 3;
        /// <summary>4</summary>
        public const int SB_THUMBPOSITION   = 4;
        /// <summary>5</summary>
        public const int SB_THUMBTRACK      = 5;
        /// <summary>6</summary>
        public const int SB_TOP             = 6;
        /// <summary>6</summary>
        public const int SB_LEFT            = 6;
        /// <summary>7</summary>
        public const int SB_BOTTOM          = 7;
        /// <summary>7</summary>
        public const int SB_RIGHT           = 7;
        /// <summary>8</summary>
        public const int SB_ENDSCROLL       = 8;
    }
    #endregion

    #region BS
    /// <summary>
    /// ボタンスタイル。
    /// </summary>
    public sealed class BS
    {
        private BS() {}
        /// <summary>0x00000000</summary>
        public const int BS_PUSHBUTTON      = 0x00000000;
        /// <summary>0x00000001</summary>
        public const int BS_DEFPUSHBUTTON   = 0x00000001;
        /// <summary>0x00000002</summary>
        public const int BS_CHECKBOX        = 0x00000002;
        /// <summary>0x00000003</summary>
        public const int BS_AUTOCHECKBOX    = 0x00000003;
        /// <summary>0x00000004</summary>
        public const int BS_RADIOBUTTON     = 0x00000004;
        /// <summary>0x00000005</summary>
        public const int BS_3STATE          = 0x00000005;
        /// <summary>0x00000006</summary>
        public const int BS_AUTO3STATE      = 0x00000006;
        /// <summary>0x00000007</summary>
        public const int BS_GROUPBOX        = 0x00000007;
        /// <summary>0x00000008</summary>
        public const int BS_USERBUTTON      = 0x00000008;
        /// <summary>0x00000009</summary>
        public const int BS_AUTORADIOBUTTON = 0x00000009;
        /// <summary>0x0000000A</summary>
        public const int BS_PUSHBOX         = 0x0000000A;
        /// <summary>0x0000000B</summary>
        public const int BS_OWNERDRAW       = 0x0000000B;
        /// <summary>0x0000000F</summary>
        public const int BS_TYPEMASK        = 0x0000000F;
        /// <summary>0x00000020</summary>
        public const int BS_LEFTTEXT        = 0x00000020;
        /// <summary>0x00000000</summary>
        public const int BS_TEXT            = 0x00000000;
        /// <summary>0x00000040</summary>
        public const int BS_ICON            = 0x00000040;
        /// <summary>0x00000080</summary>
        public const int BS_BITMAP          = 0x00000080;
        /// <summary>0x00000100</summary>
        public const int BS_LEFT            = 0x00000100;
        /// <summary>0x00000200</summary>
        public const int BS_RIGHT           = 0x00000200;
        /// <summary>0x00000300</summary>
        public const int BS_CENTER          = 0x00000300;
        /// <summary>0x00000400</summary>
        public const int BS_TOP             = 0x00000400;
        /// <summary>0x00000800</summary>
        public const int BS_BOTTOM          = 0x00000800;
        /// <summary>0x00000C00</summary>
        public const int BS_VCENTER         = 0x00000C00;
        /// <summary>0x00001000</summary>
        public const int BS_PUSHLIKE        = 0x00001000;
        /// <summary>0x00002000</summary>
        public const int BS_MULTILINE       = 0x00002000;
        /// <summary>0x00004000</summary>
        public const int BS_NOTIFY          = 0x00004000;
        /// <summary>0x00008000</summary>
        public const int BS_FLAT            = 0x00008000;
        /// <summary>BS_LEFTTEXT</summary>
        public const int BS_RIGHTBUTTON     = BS_LEFTTEXT;
    }
    #endregion

    #region VK
    /// <summary>
    /// 仮想キー値
    /// </summary>
    public sealed class VK
    {
        private VK() {}
        /// <summary>0x0C</summary>
        public const int    VK_CLEAR            = 0x0C;
        /// <summary>0x0D</summary>
        public const int    VK_RETURN           = 0x0D;

        /// <summary>0x10</summary>
        public const int    VK_SHIFT            = 0x10;
        /// <summary>0x11</summary>
        public const int    VK_CONTROL          = 0x11;
        /// <summary>0x12</summary>
        public const int    VK_MENU             = 0x12;
        /// <summary>0x13</summary>
        public const int    VK_PAUSE            = 0x13;
        /// <summary>0x14</summary>
        public const int    VK_CAPITAL          = 0x14;

        /// <summary>0x15</summary>
        public const int    VK_KANA             = 0x15;
        /// <summary>0x15</summary>
        public const int    VK_HANGUL           = 0x15;
        /// <summary>0x17</summary>
        public const int    VK_JUNJA            = 0x17;
        /// <summary>0x18</summary>
        public const int    VK_FINAL            = 0x18;
        /// <summary>0x19</summary>
        public const int    VK_HANJA            = 0x19;
        /// <summary>0x19</summary>
        public const int    VK_KANJI            = 0x19;

        /// <summary>0x1B</summary>
        public const int    VK_ESCAPE           = 0x1B;

        /// <summary>0x1C</summary>
        public const int    VK_CONVERT          = 0x1C;
        /// <summary>0x1D</summary>
        public const int    VK_NONCONVERT       = 0x1D;
        /// <summary>0x1E</summary>
        public const int    VK_ACCEPT           = 0x1E;
        /// <summary>0x1F</summary>
        public const int    VK_MODECHANGE       = 0x1F;

        /// <summary>0x20</summary>
        public const int    VK_SPACE            = 0x20;
        /// <summary>0x21</summary>
        public const int    VK_PRIOR            = 0x21;
        /// <summary>0x22</summary>
        public const int    VK_NEXT             = 0x22;
        /// <summary>0x23</summary>
        public const int    VK_END              = 0x23;
        /// <summary>0x24</summary>
        public const int    VK_HOME             = 0x24;
        /// <summary>0x25</summary>
        public const int    VK_LEFT             = 0x25;
        /// <summary>0x26</summary>
        public const int    VK_UP               = 0x26;
        /// <summary>0x27</summary>
        public const int    VK_RIGHT            = 0x27;
        /// <summary>0x28</summary>
        public const int    VK_DOWN             = 0x28;
        /// <summary>0x29</summary>
        public const int    VK_SELECT           = 0x29;
        /// <summary>0x2A</summary>
        public const int    VK_PRINT            = 0x2A;
        /// <summary>0x2B</summary>
        public const int    VK_EXECUTE          = 0x2B;
        /// <summary>0x2C</summary>
        public const int    VK_SNAPSHOT         = 0x2C;
        /// <summary>0x2D</summary>
        public const int    VK_INSERT           = 0x2D;
        /// <summary>0x2E</summary>
        public const int    VK_DELETE           = 0x2E;
        /// <summary>0x2F</summary>
        public const int    VK_HELP             = 0x2F;
    }
    #endregion VK

    #region HT
    /// <summary>
    /// HitTest
    /// </summary>
    public sealed class HT
    {
        /// <summary> </summary>
        public const int HTERROR = ( -2 );
        /// <summary> </summary>
        public const int HTTRANSPARENT = ( -1 );
        /// <summary> </summary>
        public const int HTNOWHERE = 0;
        /// <summary> </summary>
        public const int HTCLIENT = 1;
        /// <summary> </summary>
        public const int HTCAPTION = 2;
        /// <summary> </summary>
        public const int HTSYSMENU = 3;
        /// <summary> </summary>
        public const int HTGROWBOX = 4;
        /// <summary> </summary>
        public const int HTSIZE = HTGROWBOX;
        /// <summary> </summary>
        public const int HTMENU = 5;
        /// <summary> </summary>
        public const int HTHSCROLL = 6;
        /// <summary> </summary>
        public const int HTVSCROLL = 7;
        /// <summary> </summary>
        public const int HTMINBUTTON = 8;
        /// <summary> </summary>
        public const int HTMAXBUTTON = 9;
        /// <summary> </summary>
        public const int HTLEFT = 10;
        /// <summary> </summary>
        public const int HTRIGHT = 11;
        /// <summary> </summary>
        public const int HTTOP = 12;
        /// <summary> </summary>
        public const int HTTOPLEFT = 13;
        /// <summary> </summary>
        public const int HTTOPRIGHT = 14;
        /// <summary> </summary>
        public const int HTBOTTOM = 15;
        /// <summary> </summary>
        public const int HTBOTTOMLEFT = 16;
        /// <summary> </summary>
        public const int HTBOTTOMRIGHT = 17;
        /// <summary> </summary>
        public const int HTBORDER = 18;
        /// <summary> </summary>
        public const int HTREDUCE = HTMINBUTTON;
        /// <summary> </summary>
        public const int HTZOOM = HTMAXBUTTON;
        /// <summary> </summary>
        public const int HTSIZEFIRST = HTLEFT;
        /// <summary> </summary>
        public const int HTSIZELAST = HTBOTTOMRIGHT;
        /// <summary> </summary>
        public const int HTOBJECT = 19;
        /// <summary> </summary>
        public const int HTCLOSE = 20;
        /// <summary> </summary>
        public const int HTHELP = 21;
    }
    #endregion HT

    #region GW
    /// <summary>
    ///
    /// </summary>
    public sealed class GW
    {
        /// <summary> </summary>
        public const int GW_HWNDPREV = 3;
        /// <summary> </summary>
        public const int GW_OWNER = 4;
    }
    #endregion

    // WinGDI.h

    #region R2
    /// <summary>
    /// バイナリラスタ操作フラグ。
    /// </summary>
    public sealed class R2
    {
        private R2() {}
        /// <summary>1</summary>
        public const int R2_BLACK           = 1;   /*  0       */
        /// <summary>2</summary>
        public const int R2_NOTMERGEPEN     = 2;   /* DPon     */
        /// <summary>3</summary>
        public const int R2_MASKNOTPEN      = 3;   /* DPna     */
        /// <summary>4</summary>
        public const int R2_NOTCOPYPEN      = 4;   /* PN       */
        /// <summary>5</summary>
        public const int R2_MASKPENNOT      = 5;   /* PDna     */
        /// <summary>6</summary>
        public const int R2_NOT             = 6;   /* Dn       */
        /// <summary>7</summary>
        public const int R2_XORPEN          = 7;   /* DPx      */
        /// <summary>8</summary>
        public const int R2_NOTMASKPEN      = 8;   /* DPan     */
        /// <summary>9</summary>
        public const int R2_MASKPEN         = 9;   /* DPa      */
        /// <summary>10</summary>
        public const int R2_NOTXORPEN       = 10;  /* DPxn     */
        /// <summary>11</summary>
        public const int R2_NOP             = 11;  /* D        */
        /// <summary>12</summary>
        public const int R2_MERGENOTPEN     = 12;  /* DPno     */
        /// <summary>13</summary>
        public const int R2_COPYPEN         = 13;  /* P        */
        /// <summary>14</summary>
        public const int R2_MERGEPENNOT     = 14;  /* PDno     */
        /// <summary>15</summary>
        public const int R2_MERGEPEN        = 15;  /* DPo      */
        /// <summary>16</summary>
        public const int R2_WHITE           = 16;  /*  1       */
        /// <summary>16</summary>
        public const int R2_LAST            = 16;
    }
    #endregion

    #region ROP
    /// <summary>
    /// ラスタ操作フラグ。
    /// </summary>
    public sealed class ROP
    {
        private ROP() {}
        /// <summary>0x00CC0020</summary>
        public const int SRCCOPY             = 0x00CC0020; /* dest = source                   */
        /// <summary>0x00EE0086</summary>
        public const int SRCPAINT            = 0x00EE0086; /* dest = source OR dest           */
        /// <summary>0x008800C6</summary>
        public const int SRCAND              = 0x008800C6; /* dest = source AND dest          */
        /// <summary>0x00660046</summary>
        public const int SRCINVERT           = 0x00660046; /* dest = source XOR dest          */
        /// <summary>0x00440328</summary>
        public const int SRCERASE            = 0x00440328; /* dest = source AND (NOT dest )   */
        /// <summary>0x00330008</summary>
        public const int NOTSRCCOPY          = 0x00330008; /* dest = (NOT source)             */
        /// <summary>0x001100A6</summary>
        public const int NOTSRCERASE         = 0x001100A6; /* dest = (NOT src) AND (NOT dest) */
        /// <summary>0x00C000CA</summary>
        public const int MERGECOPY           = 0x00C000CA; /* dest = (source AND pattern)     */
        /// <summary>0x00BB0226</summary>
        public const int MERGEPAINT          = 0x00BB0226; /* dest = (NOT source) OR dest     */
        /// <summary>0x00F00021</summary>
        public const int PATCOPY             = 0x00F00021; /* dest = pattern                  */
        /// <summary>0x00FB0A09</summary>
        public const int PATPAINT            = 0x00FB0A09; /* dest = DPSnoo                   */
        /// <summary>0x005A0049</summary>
        public const int PATINVERT           = 0x005A0049; /* dest = pattern XOR dest         */
        /// <summary>0x00550009</summary>
        public const int DSTINVERT           = 0x00550009; /* dest = (NOT dest)               */
        /// <summary>0x00000042</summary>
        public const int BLACKNESS           = 0x00000042; /* dest = BLACK                    */
        /// <summary>0x00FF0062</summary>
        public const int WHITENESS           = 0x00FF0062; /* dest = WHITE                    */
        /// <summary>0x80000000</summary>
        public const int NOMIRRORBITMAP      = unchecked((int)0x80000000); /* Do not Mirror the bitmap in this call */
        /// <summary>0x40000000</summary>
        public const int CAPTUREBLT          = 0x40000000; /* Include layered windows */
    }
    #endregion

    // CommCtrl.h

    #region NM
    /// <summary>
    /// 通知コード。
    /// </summary>
    public sealed class NM
    {
        private NM() {}
        /// <summary>(0-  0)</summary>
        public const int NM_FIRST               = (0-  0);         // generic to all controls
        /// <summary>(0- 99)</summary>
        public const int NM_LAST                = (0- 99);
        /// <summary>(NM_FIRST-1)</summary>
        public const int NM_OUTOFMEMORY         = (NM_FIRST-1);
        /// <summary>(NM_FIRST-2)</summary>
        public const int NM_CLICK               = (NM_FIRST-2);    // uses NMCLICK struct
        /// <summary>(NM_FIRST-3)</summary>
        public const int NM_DBLCLK              = (NM_FIRST-3);
        /// <summary>(NM_FIRST-4)</summary>
        public const int NM_RETURN              = (NM_FIRST-4);
        /// <summary>(NM_FIRST-5)</summary>
        public const int NM_RCLICK              = (NM_FIRST-5);    // uses NMCLICK struct
        /// <summary>(NM_FIRST-6)</summary>
        public const int NM_RDBLCLK             = (NM_FIRST-6);
        /// <summary>(NM_FIRST-7)</summary>
        public const int NM_SETFOCUS            = (NM_FIRST-7);
        /// <summary>(NM_FIRST-8)</summary>
        public const int NM_KILLFOCUS           = (NM_FIRST-8);
        /// <summary>(NM_FIRST-12)</summary>
        public const int NM_CUSTOMDRAW          = (NM_FIRST-12);
        /// <summary>(NM_FIRST-13)</summary>
        public const int NM_HOVER               = (NM_FIRST-13);
        /// <summary>(NM_FIRST-14)</summary>
        public const int NM_NCHITTEST           = (NM_FIRST-14);   // uses NMMOUSE struct
        /// <summary>(NM_FIRST-15)</summary>
        public const int NM_KEYDOWN             = (NM_FIRST-15);   // uses NMKEY struct
        /// <summary>(NM_FIRST-16)</summary>
        public const int NM_RELEASEDCAPTURE     = (NM_FIRST-16);
        /// <summary>(NM_FIRST-17)</summary>
        public const int NM_SETCURSOR           = (NM_FIRST-17);   // uses NMMOUSE struct
        /// <summary>(NM_FIRST-18)</summary>
        public const int NM_CHAR                = (NM_FIRST-18);   // uses NMCHAR struct
        /// <summary>(NM_FIRST-19)</summary>
        public const int NM_TOOLTIPSCREATED     = (NM_FIRST-19);   // notify of when the tooltips window is create
        /// <summary>(NM_FIRST-20)</summary>
        public const int NM_LDOWN               = (NM_FIRST-20);
        /// <summary>(NM_FIRST-21)</summary>
        public const int NM_RDOWN               = (NM_FIRST-21);
        /// <summary>(NM_FIRST-22)</summary>
        public const int NM_THEMECHANGED        = (NM_FIRST-22);
    }
    #endregion

    #region CDRF
    /// <summary>
    /// カスタム描画戻り値フラグ。
    /// </summary>
    public sealed class CDRF
    {
        private CDRF() {}
        /// <summary>0x00000000</summary>
        public const int CDRF_DODEFAULT         = 0x00000000;
        /// <summary>0x00000002</summary>
        public const int CDRF_NEWFONT           = 0x00000002;
        /// <summary>0x00000004</summary>
        public const int CDRF_SKIPDEFAULT       = 0x00000004;
        /// <summary>0x00000010</summary>
        public const int CDRF_NOTIFYPOSTPAINT   = 0x00000010;
        /// <summary>0x00000020</summary>
        public const int CDRF_NOTIFYITEMDRAW    = 0x00000020;
        /// <summary>0x00000020</summary>
        public const int CDRF_NOTIFYSUBITEMDRAW = 0x00000020;  // flags are the same, we can distinguish by context
        /// <summary>0x00000040</summary>
        public const int CDRF_NOTIFYPOSTERASE   = 0x00000040;
    }
    #endregion

    #region CDDS
    /// <summary>
    /// カスタム描画ステージフラグ。
    /// </summary>
    public sealed class CDDS
    {
        private CDDS() {}
        /// <summary>0x00000001</summary>
        public const int CDDS_PREPAINT          = 0x00000001;
        /// <summary>0x00000002</summary>
        public const int CDDS_POSTPAINT         = 0x00000002;
        /// <summary>0x00000003</summary>
        public const int CDDS_PREERASE          = 0x00000003;
        /// <summary>0x00000004</summary>
        public const int CDDS_POSTERASE         = 0x00000004;
        /// <summary>0x00010000</summary>
        public const int CDDS_ITEM              = 0x00010000;
        /// <summary>(CDDS_ITEM | CDDS_PREPAINT)</summary>
        public const int CDDS_ITEMPREPAINT      = (CDDS_ITEM | CDDS_PREPAINT);
        /// <summary>(CDDS_ITEM | CDDS_POSTPAINT)</summary>
        public const int CDDS_ITEMPOSTPAINT     = (CDDS_ITEM | CDDS_POSTPAINT);
        /// <summary>(CDDS_ITEM | CDDS_PREERASE)</summary>
        public const int CDDS_ITEMPREERASE      = (CDDS_ITEM | CDDS_PREERASE);
        /// <summary>(CDDS_ITEM | CDDS_POSTERASE)</summary>
        public const int CDDS_ITEMPOSTERASE     = (CDDS_ITEM | CDDS_POSTERASE);
        /// <summary>0x00020000</summary>
        public const int CDDS_SUBITEM           = 0x00020000;
        /// <summary>(CDDS_ITEM | CDDS_SUBITEM | CDDS_PREPAINT)</summary>
        public const int CDDS_SUBITEMPREPAINT   = (CDDS_ITEM | CDDS_SUBITEM | CDDS_PREPAINT);
        /// <summary>(CDDS_ITEM | CDDS_SUBITEM | CDDS_POSTPAINT)</summary>
        public const int CDDS_SUBITEMPOSTPAINT  = (CDDS_ITEM | CDDS_SUBITEM | CDDS_POSTPAINT);
        /// <summary>(CDDS_ITEM | CDDS_SUBITEM | CDDS_PREERASE)</summary>
        public const int CDDS_SUBITEMPREERASE   = (CDDS_ITEM | CDDS_SUBITEM | CDDS_PREERASE);
        /// <summary>(CDDS_ITEM | CDDS_SUBITEM | CDDS_POSTERASE)</summary>
        public const int CDDS_SUBITEMPOSTERASE  = (CDDS_ITEM | CDDS_SUBITEM | CDDS_POSTERASE);
    }
    #endregion

    #region CDIS
    /// <summary>
    /// カスタム描画項目状態。
    /// </summary>
    public sealed class CDIS
    {
        private CDIS() {}
        /// <summary>0x0001</summary>
        public const int CDIS_SELECTED          = 0x0001;
        /// <summary>0x0002</summary>
        public const int CDIS_GRAYED            = 0x0002;
        /// <summary>0x0004</summary>
        public const int CDIS_DISABLED          = 0x0004;
        /// <summary>0x0008</summary>
        public const int CDIS_CHECKED           = 0x0008;
        /// <summary>0x0010</summary>
        public const int CDIS_FOCUS             = 0x0010;
        /// <summary>0x0020</summary>
        public const int CDIS_DEFAULT           = 0x0020;
        /// <summary>0x0040</summary>
        public const int CDIS_HOT               = 0x0040;
        /// <summary>0x0080</summary>
        public const int CDIS_MARKED            = 0x0080;
        /// <summary>0x0100</summary>
        public const int CDIS_INDETERMINATE     = 0x0100;
        /// <summary>0x0200</summary>
        public const int CDIS_SHOWKEYBOARDCUES  = 0x0200;
    }
    #endregion

    #region LVS
    /// <summary>
    /// リストビュースタイル。
    /// </summary>
    public sealed class LVS
    {
        private LVS() {}
        /// <summary>0x0000</summary>
        public const int LVS_ICON               = 0x0000;
        /// <summary>0x0001</summary>
        public const int LVS_REPORT             = 0x0001;
        /// <summary>0x0002</summary>
        public const int LVS_SMALLICON          = 0x0002;
        /// <summary>0x0003</summary>
        public const int LVS_LIST               = 0x0003;
        /// <summary>0x0003</summary>
        public const int LVS_TYPEMASK           = 0x0003;
        /// <summary>0x0004</summary>
        public const int LVS_SINGLESEL          = 0x0004;
        /// <summary>0x0008</summary>
        public const int LVS_SHOWSELALWAYS      = 0x0008;
        /// <summary>0x0010</summary>
        public const int LVS_SORTASCENDING      = 0x0010;
        /// <summary>0x0020</summary>
        public const int LVS_SORTDESCENDING     = 0x0020;
        /// <summary>0x0040</summary>
        public const int LVS_SHAREIMAGELISTS    = 0x0040;
        /// <summary>0x0080</summary>
        public const int LVS_NOLABELWRAP        = 0x0080;
        /// <summary>0x0100</summary>
        public const int LVS_AUTOARRANGE        = 0x0100;
        /// <summary>0x0200</summary>
        public const int LVS_EDITLABELS         = 0x0200;
        /// <summary>0x1000</summary>
        public const int LVS_OWNERDATA          = 0x1000;
        /// <summary>0x2000</summary>
        public const int LVS_NOSCROLL           = 0x2000;
        /// <summary>0xfc00</summary>
        public const int LVS_TYPESTYLEMASK      = 0xfc00;
        /// <summary>0x0000</summary>
        public const int LVS_ALIGNTOP           = 0x0000;
        /// <summary>0x0800</summary>
        public const int LVS_ALIGNLEFT          = 0x0800;
        /// <summary>0x0c00</summary>
        public const int LVS_ALIGNMASK          = 0x0c00;
        /// <summary>0x0400</summary>
        public const int LVS_OWNERDRAWFIXED     = 0x0400;
        /// <summary>0x4000</summary>
        public const int LVS_NOCOLUMNHEADER     = 0x4000;
        /// <summary>0x8000</summary>
        public const int LVS_NOSORTHEADER       = 0x8000;
    }
    #endregion

    #region LVM
    /// <summary>
    /// リストビューメッセージ。
    /// </summary>
    public sealed class LVM
    {
        private LVM() {}
        /// <summary>0x1000</summary>
        public const int LVM_FIRST                    = 0x1000;      // ListView messages
        /// <summary>(LVM_FIRST + 0)</summary>
        public const int LVM_GETBKCOLOR               = (LVM_FIRST + 0);
        /// <summary>(LVM_FIRST + 1)</summary>
        public const int LVM_SETBKCOLOR               = (LVM_FIRST + 1);
        /// <summary>(LVM_FIRST + 2)</summary>
        public const int LVM_GETIMAGELIST             = (LVM_FIRST + 2);
        /// <summary>(LVM_FIRST + 3)</summary>
        public const int LVM_SETIMAGELIST             = (LVM_FIRST + 3);
        /// <summary>(LVM_FIRST + 4)</summary>
        public const int LVM_GETITEMCOUNT             = (LVM_FIRST + 4);
        /// <summary>(LVM_FIRST + 75)</summary>
        public const int LVM_GETITEMW                 = (LVM_FIRST + 75);
        /// <summary>(LVM_FIRST + 76)</summary>
        public const int LVM_SETITEMW                 = (LVM_FIRST + 76);
        /// <summary>(LVM_FIRST + 77)</summary>
        public const int LVM_INSERTITEMW              = (LVM_FIRST + 77);
        /// <summary>(LVM_FIRST + 8)</summary>
        public const int LVM_DELETEITEM               = (LVM_FIRST + 8);
        /// <summary>(LVM_FIRST + 9)</summary>
        public const int LVM_DELETEALLITEMS           = (LVM_FIRST + 9);
        /// <summary>(LVM_FIRST + 10)</summary>
        public const int LVM_GETCALLBACKMASK          = (LVM_FIRST + 10);
        /// <summary>(LVM_FIRST + 11)</summary>
        public const int LVM_SETCALLBACKMASK          = (LVM_FIRST + 11);
        /// <summary>(LVM_FIRST + 12)</summary>
        public const int LVM_GETNEXTITEM              = (LVM_FIRST + 12);
        /// <summary>(LVM_FIRST + 83)</summary>
        public const int LVM_FINDITEMW                = (LVM_FIRST + 83);
        /// <summary>(LVM_FIRST + 14)</summary>
        public const int LVM_GETITEMRECT              = (LVM_FIRST + 14);
        /// <summary>(LVM_FIRST + 15)</summary>
        public const int LVM_SETITEMPOSITION          = (LVM_FIRST + 15);
        /// <summary>(LVM_FIRST + 16)</summary>
        public const int LVM_GETITEMPOSITION          = (LVM_FIRST + 16);
        /// <summary>(LVM_FIRST + 87)</summary>
        public const int LVM_GETSTRINGWIDTHW          = (LVM_FIRST + 87);
        /// <summary>(LVM_FIRST + 18)</summary>
        public const int LVM_HITTEST                  = (LVM_FIRST + 18);
        /// <summary>(LVM_FIRST + 19)</summary>
        public const int LVM_ENSUREVISIBLE            = (LVM_FIRST + 19);
        /// <summary>(LVM_FIRST + 20)</summary>
        public const int LVM_SCROLL                   = (LVM_FIRST + 20);
        /// <summary>(LVM_FIRST + 21)</summary>
        public const int LVM_REDRAWITEMS              = (LVM_FIRST + 21);
        /// <summary>(LVM_FIRST + 22)</summary>
        public const int LVM_ARRANGE                  = (LVM_FIRST + 22);
        /// <summary>(LVM_FIRST + 118)</summary>
        public const int LVM_EDITLABELW               = (LVM_FIRST + 118);
        /// <summary>(LVM_FIRST + 24)</summary>
        public const int LVM_GETEDITCONTROL           = (LVM_FIRST + 24);
        /// <summary>(LVM_FIRST + 95)</summary>
        public const int LVM_GETCOLUMNW               = (LVM_FIRST + 95);
        /// <summary>(LVM_FIRST + 96)</summary>
        public const int LVM_SETCOLUMNW               = (LVM_FIRST + 96);
        /// <summary>(LVM_FIRST + 97)</summary>
        public const int LVM_INSERTCOLUMNW            = (LVM_FIRST + 97);
        /// <summary>(LVM_FIRST + 28)</summary>
        public const int LVM_DELETECOLUMN             = (LVM_FIRST + 28);
        /// <summary>(LVM_FIRST + 29)</summary>
        public const int LVM_GETCOLUMNWIDTH           = (LVM_FIRST + 29);
        /// <summary>(LVM_FIRST + 30)</summary>
        public const int LVM_SETCOLUMNWIDTH           = (LVM_FIRST + 30);
        /// <summary>(LVM_FIRST + 31)</summary>
        public const int LVM_GETHEADER                = (LVM_FIRST + 31);
        /// <summary>(LVM_FIRST + 33)</summary>
        public const int LVM_CREATEDRAGIMAGE          = (LVM_FIRST + 33);
        /// <summary>(LVM_FIRST + 34)</summary>
        public const int LVM_GETVIEWRECT              = (LVM_FIRST + 34);
        /// <summary>(LVM_FIRST + 35)</summary>
        public const int LVM_GETTEXTCOLOR             = (LVM_FIRST + 35);
        /// <summary>(LVM_FIRST + 36)</summary>
        public const int LVM_SETTEXTCOLOR             = (LVM_FIRST + 36);
        /// <summary>(LVM_FIRST + 37)</summary>
        public const int LVM_GETTEXTBKCOLOR           = (LVM_FIRST + 37);
        /// <summary>(LVM_FIRST + 38)</summary>
        public const int LVM_SETTEXTBKCOLOR           = (LVM_FIRST + 38);
        /// <summary>(LVM_FIRST + 39)</summary>
        public const int LVM_GETTOPINDEX              = (LVM_FIRST + 39);
        /// <summary>(LVM_FIRST + 40)</summary>
        public const int LVM_GETCOUNTPERPAGE          = (LVM_FIRST + 40);
        /// <summary>(LVM_FIRST + 41)</summary>
        public const int LVM_GETORIGIN                = (LVM_FIRST + 41);
        /// <summary>(LVM_FIRST + 42)</summary>
        public const int LVM_UPDATE                   = (LVM_FIRST + 42);
        /// <summary>(LVM_FIRST + 43)</summary>
        public const int LVM_SETITEMSTATE             = (LVM_FIRST + 43);
        /// <summary>(LVM_FIRST + 44)</summary>
        public const int LVM_GETITEMSTATE             = (LVM_FIRST + 44);
        /// <summary>(LVM_FIRST + 115)</summary>
        public const int LVM_GETITEMTEXTW             = (LVM_FIRST + 115);
        /// <summary>(LVM_FIRST + 116)</summary>
        public const int LVM_SETITEMTEXTW             = (LVM_FIRST + 116);
        /// <summary>(LVM_FIRST + 47)</summary>
        public const int LVM_SETITEMCOUNT             = (LVM_FIRST + 47);
        /// <summary>(LVM_FIRST + 48)</summary>
        public const int LVM_SORTITEMS                = (LVM_FIRST + 48);
        /// <summary>(LVM_FIRST + 49)</summary>
        public const int LVM_SETITEMPOSITION32        = (LVM_FIRST + 49);
        /// <summary>(LVM_FIRST + 50)</summary>
        public const int LVM_GETSELECTEDCOUNT         = (LVM_FIRST + 50);
        /// <summary>(LVM_FIRST + 51)</summary>
        public const int LVM_GETITEMSPACING           = (LVM_FIRST + 51);
        /// <summary>(LVM_FIRST + 117)</summary>
        public const int LVM_GETISEARCHSTRINGW        = (LVM_FIRST + 117);
        /// <summary>(LVM_FIRST + 53)</summary>
        public const int LVM_SETICONSPACING           = (LVM_FIRST + 53);
        /// <summary>(LVM_FIRST + 54)</summary>
        public const int LVM_SETEXTENDEDLISTVIEWSTYLE = (LVM_FIRST + 54);   // optional wParam == mask
        /// <summary>(LVM_FIRST + 55)</summary>
        public const int LVM_GETEXTENDEDLISTVIEWSTYLE = (LVM_FIRST + 55);
        /// <summary>(LVM_FIRST + 56)</summary>
        public const int LVM_GETSUBITEMRECT           = (LVM_FIRST + 56);
        /// <summary>(LVM_FIRST + 57)</summary>
        public const int LVM_SUBITEMHITTEST           = (LVM_FIRST + 57);
        /// <summary>(LVM_FIRST + 58)</summary>
        public const int LVM_SETCOLUMNORDERARRAY      = (LVM_FIRST + 58);
        /// <summary>(LVM_FIRST + 59)</summary>
        public const int LVM_GETCOLUMNORDERARRAY      = (LVM_FIRST + 59);
        /// <summary>(LVM_FIRST + 60)</summary>
        public const int LVM_SETHOTITEM               = (LVM_FIRST + 60);
        /// <summary>(LVM_FIRST + 61)</summary>
        public const int LVM_GETHOTITEM               = (LVM_FIRST + 61);
        /// <summary>(LVM_FIRST + 62)</summary>
        public const int LVM_SETHOTCURSOR             = (LVM_FIRST + 62);
        /// <summary>(LVM_FIRST + 63)</summary>
        public const int LVM_GETHOTCURSOR             = (LVM_FIRST + 63);
        /// <summary>(LVM_FIRST + 64)</summary>
        public const int LVM_APPROXIMATEVIEWRECT      = (LVM_FIRST + 64);
        /// <summary>(LVM_FIRST + 65)</summary>
        public const int LVM_SETWORKAREAS             = (LVM_FIRST + 65);
        /// <summary>(LVM_FIRST + 66)</summary>
        public const int LVM_GETSELECTIONMARK         = (LVM_FIRST + 66);
        /// <summary>(LVM_FIRST + 67)</summary>
        public const int LVM_SETSELECTIONMARK         = (LVM_FIRST + 67);
        /// <summary>(LVM_FIRST + 138)</summary>
        public const int LVM_SETBKIMAGEW              = (LVM_FIRST + 138);
        /// <summary>(LVM_FIRST + 139)</summary>
        public const int LVM_GETBKIMAGEW              = (LVM_FIRST + 139);
        /// <summary>(LVM_FIRST + 70)</summary>
        public const int LVM_GETWORKAREAS             = (LVM_FIRST + 70);
        /// <summary>(LVM_FIRST + 71)</summary>
        public const int LVM_SETHOVERTIME             = (LVM_FIRST + 71);
        /// <summary>(LVM_FIRST + 72)</summary>
        public const int LVM_GETHOVERTIME             = (LVM_FIRST + 72);
        /// <summary>(LVM_FIRST + 73)</summary>
        public const int LVM_GETNUMBEROFWORKAREAS     = (LVM_FIRST + 73);
        /// <summary>(LVM_FIRST + 74)</summary>
        public const int LVM_SETTOOLTIPS              = (LVM_FIRST + 74);
        /// <summary>(LVM_FIRST + 78)</summary>
        public const int LVM_GETTOOLTIPS              = (LVM_FIRST + 78);
        /// <summary>(LVM_FIRST + 81)</summary>
        public const int LVM_SORTITEMSEX              = (LVM_FIRST + 81);
        /// <summary>(LVM_FIRST + 140)</summary>
        public const int LVM_SETSELECTEDCOLUMN        = (LVM_FIRST + 140);
        /// <summary>(LVM_FIRST + 141)</summary>
        public const int LVM_SETTILEWIDTH             = (LVM_FIRST + 141);
        /// <summary>(LVM_FIRST + 142)</summary>
        public const int LVM_SETVIEW                  = (LVM_FIRST + 142);
        /// <summary>(LVM_FIRST + 143)</summary>
        public const int LVM_GETVIEW                  = (LVM_FIRST + 143);
        /// <summary>(LVM_FIRST + 145)</summary>
        public const int LVM_INSERTGROUP              = (LVM_FIRST + 145);
        /// <summary>(LVM_FIRST + 147)</summary>
        public const int LVM_SETGROUPINFO             = (LVM_FIRST + 147);
        /// <summary>(LVM_FIRST + 149)</summary>
        public const int LVM_GETGROUPINFO             = (LVM_FIRST + 149);
        /// <summary>(LVM_FIRST + 150)</summary>
        public const int LVM_REMOVEGROUP              = (LVM_FIRST + 150);
        /// <summary>(LVM_FIRST + 151)</summary>
        public const int LVM_MOVEGROUP                = (LVM_FIRST + 151);
        /// <summary>(LVM_FIRST + 154)</summary>
        public const int LVM_MOVEITEMTOGROUP          = (LVM_FIRST + 154);
        /// <summary>(LVM_FIRST + 155)</summary>
        public const int LVM_SETGROUPMETRICS          = (LVM_FIRST + 155);
        /// <summary>(LVM_FIRST + 156)</summary>
        public const int LVM_GETGROUPMETRICS          = (LVM_FIRST + 156);
        /// <summary>(LVM_FIRST + 157)</summary>
        public const int LVM_ENABLEGROUPVIEW          = (LVM_FIRST + 157);
        /// <summary>(LVM_FIRST + 158)</summary>
        public const int LVM_SORTGROUPS               = (LVM_FIRST + 158);
        /// <summary>(LVM_FIRST + 159)</summary>
        public const int LVM_INSERTGROUPSORTED        = (LVM_FIRST + 159);
        /// <summary>(LVM_FIRST + 160)</summary>
        public const int LVM_REMOVEALLGROUPS          = (LVM_FIRST + 160);
        /// <summary>(LVM_FIRST + 161)</summary>
        public const int LVM_HASGROUP                 = (LVM_FIRST + 161);
        /// <summary>(LVM_FIRST + 162)</summary>
        public const int LVM_SETTILEVIEWINFO          = (LVM_FIRST + 162);
        /// <summary>(LVM_FIRST + 163)</summary>
        public const int LVM_GETTILEVIEWINFO          = (LVM_FIRST + 163);
        /// <summary>(LVM_FIRST + 164)</summary>
        public const int LVM_SETTILEINFO              = (LVM_FIRST + 164);
        /// <summary>(LVM_FIRST + 165)</summary>
        public const int LVM_GETTILEINFO              = (LVM_FIRST + 165);
        /// <summary>(LVM_FIRST + 166)</summary>
        public const int LVM_SETINSERTMARK            = (LVM_FIRST + 166);
        /// <summary>(LVM_FIRST + 167)</summary>
        public const int LVM_GETINSERTMARK            = (LVM_FIRST + 167);
        /// <summary>(LVM_FIRST + 168)</summary>
        public const int LVM_INSERTMARKHITTEST        = (LVM_FIRST + 168);
        /// <summary>(LVM_FIRST + 169)</summary>
        public const int LVM_GETINSERTMARKRECT        = (LVM_FIRST + 169);
        /// <summary>(LVM_FIRST + 170)</summary>
        public const int LVM_SETINSERTMARKCOLOR       = (LVM_FIRST + 170);
        /// <summary>(LVM_FIRST + 171)</summary>
        public const int LVM_GETINSERTMARKCOLOR       = (LVM_FIRST + 171);
        /// <summary>(LVM_FIRST + 173)</summary>
        public const int LVM_SETINFOTIP               = (LVM_FIRST + 173);
        /// <summary>(LVM_FIRST + 174)</summary>
        public const int LVM_GETSELECTEDCOLUMN        = (LVM_FIRST + 174);
        /// <summary>(LVM_FIRST + 175)</summary>
        public const int LVM_ISGROUPVIEWENABLED       = (LVM_FIRST + 175);
        /// <summary>(LVM_FIRST + 176)</summary>
        public const int LVM_GETOUTLINECOLOR          = (LVM_FIRST + 176);
        /// <summary>(LVM_FIRST + 177)</summary>
        public const int LVM_SETOUTLINECOLOR          = (LVM_FIRST + 177);
        /// <summary>(LVM_FIRST + 179)</summary>
        public const int LVM_CANCELEDITLABEL          = (LVM_FIRST + 179);
        /// <summary>(LVM_FIRST + 180)</summary>
        public const int LVM_MAPINDEXTOID             = (LVM_FIRST + 180);
        /// <summary>(LVM_FIRST + 181)</summary>
        public const int LVM_MAPIDTOINDEX             = (LVM_FIRST + 181);
    }
    #endregion

    #region LVIR
    /// <summary>
    /// リストビュー項目領域。
    /// </summary>
    public sealed class LVIR
    {
        private LVIR() {}
        /// <summary>0</summary>
        public const int LVIR_BOUNDS            = 0;
        /// <summary>1</summary>
        public const int LVIR_ICON              = 1;
        /// <summary>2</summary>
        public const int LVIR_LABEL             = 2;
        /// <summary>3</summary>
        public const int LVIR_SELECTBOUNDS      = 3;
    }
    #endregion

    #region TBS
    /// <summary>
    /// トラックバースタイル。
    /// </summary>
    public sealed class TBS
    {
        private TBS() {}
        /// <summary>0x0001</summary>
        public const int TBS_AUTOTICKS          = 0x0001;
        /// <summary>0x0002</summary>
        public const int TBS_VERT               = 0x0002;
        /// <summary>0x0000</summary>
        public const int TBS_HORZ               = 0x0000;
        /// <summary>0x0004</summary>
        public const int TBS_TOP                = 0x0004;
        /// <summary>0x0000</summary>
        public const int TBS_BOTTOM             = 0x0000;
        /// <summary>0x0004</summary>
        public const int TBS_LEFT               = 0x0004;
        /// <summary>0x0000</summary>
        public const int TBS_RIGHT              = 0x0000;
        /// <summary>0x0008</summary>
        public const int TBS_BOTH               = 0x0008;
        /// <summary>0x0010</summary>
        public const int TBS_NOTICKS            = 0x0010;
        /// <summary>0x0020</summary>
        public const int TBS_ENABLESELRANGE     = 0x0020;
        /// <summary>0x0040</summary>
        public const int TBS_FIXEDLENGTH        = 0x0040;
        /// <summary>0x0080</summary>
        public const int TBS_NOTHUMB            = 0x0080;
        /// <summary>0x0100</summary>
        public const int TBS_TOOLTIPS           = 0x0100;
        /// <summary>0x0200</summary>
        public const int TBS_REVERSED           = 0x0200; // Accessibility hint: the smaller number (usually the min value) means "high" and the larger number (usually the max value) means "low"
        /// <summary>0x0400</summary>
        public const int TBS_DOWNISLEFT         = 0x0400; // Down=Left and Up=Right (default is Down=Right and Up=Left)
    }
    #endregion

    #region HDS
    /// <summary>
    /// ヘッダースタイル。
    /// </summary>
    public static class HDS
    {
        /// <summary></summary>
        public const int HDS_HORZ = 0x0000;
        /// <summary></summary>
        public const int HDS_BUTTONS = 0x0002;
        /// <summary></summary>
        public const int HDS_HOTTRACK = 0x0004;
        /// <summary></summary>
        public const int HDS_HIDDEN = 0x0008;
        /// <summary></summary>
        public const int HDS_DRAGDROP = 0x0040;
        /// <summary></summary>
        public const int HDS_FULLDRAG = 0x0080;
        /// <summary></summary>
        public const int HDS_FILTERBAR = 0x0100;
        /// <summary></summary>
        public const int HDS_FLAT = 0x0200;
    }
    #endregion

    #region HDM
    /// <summary>
    /// ヘッダーメッセージ。
    /// </summary>
    public static class HDM
    {
        /// <summary></summary>
        public const int HDM_FIRST = 0x1200;      // Header messages
        /// <summary></summary>
        public const int HDM_GETITEMCOUNT = (HDM_FIRST + 0);
        /// <summary></summary>
        public const int HDM_INSERTITEMA = (HDM_FIRST + 1);
        /// <summary></summary>
        public const int HDM_INSERTITEMW = (HDM_FIRST + 10);
        /// <summary></summary>
        public const int HDM_DELETEITEM = (HDM_FIRST + 2);
        /// <summary></summary>
        public const int HDM_GETITEMA = (HDM_FIRST + 3);
        /// <summary></summary>
        public const int HDM_GETITEMW = (HDM_FIRST + 11);
        /// <summary></summary>
        public const int HDM_SETITEMA = (HDM_FIRST + 4);
        /// <summary></summary>
        public const int HDM_SETITEMW = (HDM_FIRST + 12);
        /// <summary></summary>
        public const int HDM_LAYOUT = (HDM_FIRST + 5);
        /// <summary></summary>
        public const int HDM_HITTEST = (HDM_FIRST + 6);
        /// <summary></summary>
        public const int HDM_GETITEMRECT = (HDM_FIRST + 7);
        /// <summary></summary>
        public const int HDM_SETIMAGELIST = (HDM_FIRST + 8);
        /// <summary></summary>
        public const int HDM_GETIMAGELIST = (HDM_FIRST + 9);
        /// <summary></summary>
        public const int HDM_ORDERTOINDEX = (HDM_FIRST + 15);
        /// <summary></summary>
        public const int HDM_CREATEDRAGIMAGE = (HDM_FIRST + 16);  // wparam = which item (by index);
        /// <summary></summary>
        public const int HDM_GETORDERARRAY = (HDM_FIRST + 17);
        /// <summary></summary>
        public const int HDM_SETORDERARRAY = (HDM_FIRST + 18);
        /// <summary></summary>
        public const int HDM_SETHOTDIVIDER = (HDM_FIRST + 19);
        /// <summary></summary>
        public const int HDM_SETBITMAPMARGIN = (HDM_FIRST + 20);
        /// <summary></summary>
        public const int HDM_GETBITMAPMARGIN = (HDM_FIRST + 21);
        /// <summary></summary>
        public const int HDM_SETFILTERCHANGETIMEOUT = (HDM_FIRST + 22);
        /// <summary></summary>
        public const int HDM_EDITFILTER = (HDM_FIRST + 23);
        /// <summary></summary>
        public const int HDM_CLEARFILTER = (HDM_FIRST + 24);
    }
    #endregion

    #region HDN
    /// <summary>
    /// ヘッダ通知コード。
    /// </summary>
    public static class HDN
    {
        /// <summary></summary>
        public const int HDN_FIRST = (0 - 300);       // header
        /// <summary></summary>
        public const int HDN_LAST = (0 - 399);
        /// <summary></summary>
        public const int HDN_ITEMCHANGINGA = (HDN_FIRST - 0);
        /// <summary></summary>
        public const int HDN_ITEMCHANGINGW = (HDN_FIRST - 20);
        /// <summary></summary>
        public const int HDN_ITEMCHANGEDA = (HDN_FIRST - 1);
        /// <summary></summary>
        public const int HDN_ITEMCHANGEDW = (HDN_FIRST - 21);
        /// <summary></summary>
        public const int HDN_ITEMCLICKA = (HDN_FIRST - 2);
        /// <summary></summary>
        public const int HDN_ITEMCLICKW = (HDN_FIRST - 22);
        /// <summary></summary>
        public const int HDN_ITEMDBLCLICKA = (HDN_FIRST - 3);
        /// <summary></summary>
        public const int HDN_ITEMDBLCLICKW = (HDN_FIRST - 23);
        /// <summary></summary>
        public const int HDN_DIVIDERDBLCLICKA = (HDN_FIRST - 5);
        /// <summary></summary>
        public const int HDN_DIVIDERDBLCLICKW = (HDN_FIRST - 25);
        /// <summary></summary>
        public const int HDN_BEGINTRACKA = (HDN_FIRST - 6);
        /// <summary></summary>
        public const int HDN_BEGINTRACKW = (HDN_FIRST - 26);
        /// <summary></summary>
        public const int HDN_ENDTRACKA = (HDN_FIRST - 7);
        /// <summary></summary>
        public const int HDN_ENDTRACKW = (HDN_FIRST - 27);
        /// <summary></summary>
        public const int HDN_TRACKA = (HDN_FIRST - 8);
        /// <summary></summary>
        public const int HDN_TRACKW = (HDN_FIRST - 28);
        /// <summary></summary>
        public const int HDN_GETDISPINFOA = (HDN_FIRST - 9);
        /// <summary></summary>
        public const int HDN_GETDISPINFOW = (HDN_FIRST - 29);
        /// <summary></summary>
        public const int HDN_BEGINDRAG = (HDN_FIRST - 10);
        /// <summary></summary>
        public const int HDN_ENDDRAG = (HDN_FIRST - 11);
        /// <summary></summary>
        public const int HDN_FILTERCHANGE = (HDN_FIRST - 12);
        /// <summary></summary>
        public const int HDN_FILTERBTNCLICK = (HDN_FIRST - 13);
    }
    #endregion

    #region HDI
    /// <summary>
    /// ヘッダ項目マスク。
    /// </summary>
    public static class HDI
    {
        /// <summary></summary>
        public const int HDI_WIDTH = 0x0001;
        /// <summary></summary>
        public const int HDI_HEIGHT = HDI_WIDTH;
        /// <summary></summary>
        public const int HDI_TEXT = 0x0002;
        /// <summary></summary>
        public const int HDI_FORMAT = 0x0004;
        /// <summary></summary>
        public const int HDI_LPARAM = 0x0008;
        /// <summary></summary>
        public const int HDI_BITMAP = 0x0010;
        /// <summary></summary>
        public const int HDI_IMAGE = 0x0020;
        /// <summary></summary>
        public const int HDI_DI_SETITEM = 0x0040;
        /// <summary></summary>
        public const int HDI_ORDER = 0x0080;
        /// <summary></summary>
        public const int HDI_FILTER = 0x0100;
    }
    #endregion

    #region HDF
    /// <summary>
    /// ヘッダ項目フォーマット。
    /// </summary>
    public static class HDF
    {
        /// <summary></summary>
        public const int HDF_LEFT = 0x0000;
        /// <summary></summary>
        public const int HDF_RIGHT = 0x0001;
        /// <summary></summary>
        public const int HDF_CENTER = 0x0002;
        /// <summary></summary>
        public const int HDF_JUSTIFYMASK = 0x0003;
        /// <summary></summary>
        public const int HDF_RTLREADING = 0x0004;
        /// <summary></summary>
        public const int HDF_OWNERDRAW = 0x8000;
        /// <summary></summary>
        public const int HDF_STRING = 0x4000;
        /// <summary></summary>
        public const int HDF_BITMAP = 0x2000;
        /// <summary></summary>
        public const int HDF_BITMAP_ON_RIGHT = 0x1000;
        /// <summary></summary>
        public const int HDF_IMAGE = 0x0800;
        /// <summary></summary>
        public const int HDF_SORTUP = 0x0400;
        /// <summary></summary>
        public const int HDF_SORTDOWN = 0x0200;
    }
    #endregion

    // OleCtl.h

    #region OCM
    /// <summary>
    /// Reflected ウインドウメッセージ。
    /// </summary>
    public sealed class OCM	// OleCtl.h
    {
        private OCM() {}
        /// <summary>(WM.WM_USER + 0x1c00)</summary>
        public const int OCM__BASE              = (WM.WM_USER + 0x1c00);
        /// <summary>(OCM__BASE + WM.WM_COMMAND)</summary>
        public const int OCM_COMMAND            = (OCM__BASE + WM.WM_COMMAND);
        /// <summary>(OCM__BASE + WM.WM_CTLCOLORBTN)</summary>
        public const int OCM_CTLCOLORBTN        = (OCM__BASE + WM.WM_CTLCOLORBTN);
        /// <summary>(OCM__BASE + WM.WM_CTLCOLOREDIT)</summary>
        public const int OCM_CTLCOLOREDIT       = (OCM__BASE + WM.WM_CTLCOLOREDIT);
        /// <summary>(OCM__BASE + WM.WM_CTLCOLORDLG)</summary>
        public const int OCM_CTLCOLORDLG        = (OCM__BASE + WM.WM_CTLCOLORDLG);
        /// <summary>(OCM__BASE + WM.WM_CTLCOLORLISTBOX)</summary>
        public const int OCM_CTLCOLORLISTBOX    = (OCM__BASE + WM.WM_CTLCOLORLISTBOX);
        /// <summary>(OCM__BASE + WM.WM_CTLCOLORMSGBOX)</summary>
        public const int OCM_CTLCOLORMSGBOX     = (OCM__BASE + WM.WM_CTLCOLORMSGBOX);
        /// <summary>(OCM__BASE + WM.WM_CTLCOLORSCROLLBAR)</summary>
        public const int OCM_CTLCOLORSCROLLBAR  = (OCM__BASE + WM.WM_CTLCOLORSCROLLBAR);
        /// <summary>(OCM__BASE + WM.WM_CTLCOLORSTATIC)</summary>
        public const int OCM_CTLCOLORSTATIC     = (OCM__BASE + WM.WM_CTLCOLORSTATIC);
        /// <summary>(OCM__BASE + WM.WM_CTLCOLOR)</summary>
        public const int OCM_CTLCOLOR           = (OCM__BASE + WM.WM_CTLCOLOR);
        /// <summary>(OCM__BASE + WM.WM_DRAWITEM)</summary>
        public const int OCM_DRAWITEM           = (OCM__BASE + WM.WM_DRAWITEM);
        /// <summary>(OCM__BASE + WM.WM_MEASUREITEM)</summary>
        public const int OCM_MEASUREITEM        = (OCM__BASE + WM.WM_MEASUREITEM);
        /// <summary>(OCM__BASE + WM.WM_DELETEITEM)</summary>
        public const int OCM_DELETEITEM         = (OCM__BASE + WM.WM_DELETEITEM);
        /// <summary>(OCM__BASE + WM.WM_VKEYTOITEM)</summary>
        public const int OCM_VKEYTOITEM         = (OCM__BASE + WM.WM_VKEYTOITEM);
        /// <summary>(OCM__BASE + WM.WM_CHARTOITEM)</summary>
        public const int OCM_CHARTOITEM         = (OCM__BASE + WM.WM_CHARTOITEM);
        /// <summary>(OCM__BASE + WM.WM_COMPAREITEM)</summary>
        public const int OCM_COMPAREITEM        = (OCM__BASE + WM.WM_COMPAREITEM);
        /// <summary>(OCM__BASE + WM.WM_HSCROLL)</summary>
        public const int OCM_HSCROLL            = (OCM__BASE + WM.WM_HSCROLL);
        /// <summary>(OCM__BASE + WM.WM_VSCROLL)</summary>
        public const int OCM_VSCROLL            = (OCM__BASE + WM.WM_VSCROLL);
        /// <summary>(OCM__BASE + WM.WM_PARENTNOTIFY)</summary>
        public const int OCM_PARENTNOTIFY       = (OCM__BASE + WM.WM_PARENTNOTIFY);
        /// <summary>(OCM__BASE + WM.WM_NOTIFY)</summary>
        public const int OCM_NOTIFY             = (OCM__BASE + WM.WM_NOTIFY);
    }
    #endregion

    // その他

    #region Constants
    /// <summary>
    /// 定数値。
    /// </summary>
    public sealed class Constants
    {
        private Constants() {}

        /// <summary>120</summary>
        public const int WHEEL_DELTA = 120;

        /// <summary>API ShellAddToRecentDocs 第一引数の型</summary>
        public const uint SHARD_PIDL = 0x001;
        public const uint SHARD_PATH = 0x002;
    }
    #endregion
}
