﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Diagnostics;
using System.Drawing;

namespace LECore.Structures
{

    using Core;
    using LECoreInterface;
    using NWFont = NW4R.Font;

    /// <summary>
    /// Alignment ペインの情報
    /// 外部モジュール公開インタフェース
    /// </summary>
    public interface IScissor
        : IDrawable, IPaneExParamater
    {
    }

    public static class ScissorHelper
    {
        public static bool HasScissorPaneTarget(this IScissor src)
        {
            if(src == null || src.OwnerPane == null)
            {
                return false;
            }

            if(!src.OwnerPane.HasChildren)
            {
                return false;
            }

            return true;
        }
    }
}
