﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Diagnostics;
using System.Drawing;

namespace LECore.Structures
{

    using Core;
    using LECoreInterface;
    using NWFont = NW4R.Font;

    /// <summary>
    /// Capture ペインの情報
    /// 外部モジュール公開インタフェース
    /// </summary>
    public interface ICapture
        : IDrawable, IPaneExParamater
    {
        //----------------------------------------------------------
        //
        //----------------------------------------------------------

        /// <summary>
        /// フレームバッファキャプチャを行うかどうか
        /// </summary>
        bool FrameBufferCaptureEnabled{ get; }
        /// <summary>
        /// フレームバッファキャプチャの際に初回だけキャプチャを行うかどうか
        /// </summary>
        bool CaptureOnlyFirstFrame{ get; }
        /// <summary>
        /// キャプチャ画像のクリアカラー
        /// </summary>
        FloatColor ClearColor { get; }
        /// <summary>
        /// テクスチャフォーマットの変更
        /// </summary>
        TexImagePixelFmt Format { get; }
        /// <summary>
        /// テクスチャ解像度のスケール
        /// </summary>
        float TextureScale { get; }

        /// <summary>
        /// 自分自身から作成されたテクスチャ
        /// </summary>
        ICaptureTexture OwnTexture { get; }
    }
}
