﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Diagnostics;
using System.Text;
using System.Threading.Tasks;

namespace LECore.Save_Load
{
    using LECore.Structures;
    using LECore.Structures.Nsrif.Attributes;
    using AppData = LECore.Structures;
    using FileFmt = LECore.Structures.SerializableObject.Lyt;

    public partial class RlytConverter
    {
        #region File => App
        void Convert_Pane_ProceduralShape_(AppData.ProceduralShape dstProceduralShape, FileFmt.ProceduralShapeParam srcProceduralShape)
        {
            if (srcProceduralShape == null)
            {
                dstProceduralShape.IsProceduralShapeEnabled = false;
                return;
            }

            dstProceduralShape.IsProceduralShapeEnabled = srcProceduralShape.proceduralShapeEnabled;
            dstProceduralShape.Exp = srcProceduralShape.exp;
            dstProceduralShape.Radius = srcProceduralShape.radius;

            dstProceduralShape.IsInnerStrokeEnabled = srcProceduralShape.innerStrokeEnabled;
            dstProceduralShape.InnerStrokeSize = srcProceduralShape.innerStrokeSize;
            dstProceduralShape.InnerStrokeBlendMode = (AppData.LECoreInterface.ProceduralShapeEffectBlendMode)srcProceduralShape.innerStrokeBlendMode;
            dstProceduralShape.InnerStrokeColor = Convert_RGBAColor_(srcProceduralShape.innerStrokeColor);

            dstProceduralShape.IsInnerShadowEnabled = srcProceduralShape.innerShadowEnabled;
            dstProceduralShape.InnerShadowBlendMode = (AppData.LECoreInterface.ProceduralShapeEffectBlendMode)srcProceduralShape.innerShadowBlendMode;
            dstProceduralShape.InnerShadowColor = Convert_RGBAColor_(srcProceduralShape.innerShadowColor);
            dstProceduralShape.InnerShadowAngle = srcProceduralShape.innerShadowAngle;
            dstProceduralShape.InnerShadowDistance = srcProceduralShape.innerShadowDistance;
            dstProceduralShape.InnerShadowSize = srcProceduralShape.innerShadowSize;
            dstProceduralShape.InnerShadowType = (AppData.LECoreInterface.ProceduralShapeShadowType)srcProceduralShape.innerShadowType;

            dstProceduralShape.IsColorOverayEnabled = srcProceduralShape.colorOverlayEnabled;
            dstProceduralShape.ColorOverlayBlendMode = (AppData.LECoreInterface.ProceduralShapeEffectBlendMode)srcProceduralShape.colorOverlayBlendMode;
            dstProceduralShape.ColorOverlayColor = Convert_RGBAColor_(srcProceduralShape.colorOverlayColor);

            dstProceduralShape.IsGradationOverayEnabled = srcProceduralShape.gradationOverlayEnabled;
            dstProceduralShape.GradationOverlayBlendMode = (AppData.LECoreInterface.ProceduralShapeEffectBlendMode)srcProceduralShape.gradationOverlayBlendMode;
            dstProceduralShape.GradationOverlayControlPointCount = srcProceduralShape.gradationOverlayControlPoint.Length;

            for (int i = 0; i < dstProceduralShape.GradationOverlayControlPointCount; ++i)
            {
                dstProceduralShape.SetGradationOverlayColor(i, Convert_RGBAColor_(srcProceduralShape.gradationOverlayColor[i]));
                dstProceduralShape.SetGradationOverlayControlPoint(i, srcProceduralShape.gradationOverlayControlPoint[i]);
            }

            dstProceduralShape.GradationOverlayAngle = srcProceduralShape.gradationOverlayAngle;

            dstProceduralShape.IsOuterShadowEnabled = srcProceduralShape.outerShadowEnabled;
            dstProceduralShape.OuterShadowBlendMode = (AppData.LECoreInterface.ProceduralShapeEffectBlendMode)srcProceduralShape.outerShadowBlendMode;
            dstProceduralShape.OuterShadowColor = Convert_RGBAColor_(srcProceduralShape.outerShadowColor);
            dstProceduralShape.OuterShadowAngle = srcProceduralShape.outerShadowAngle;
            dstProceduralShape.OuterShadowDistance = srcProceduralShape.outerShadowDistance;
            dstProceduralShape.OuterShadowSize = srcProceduralShape.outerShadowSize;
            dstProceduralShape.OuterShadowType = (AppData.LECoreInterface.ProceduralShapeShadowType)srcProceduralShape.outerShadowType;
        }
        #endregion

#region App => File

        FileFmt.ProceduralShapeParam Convert_ToFile_ProceduralShape_(AppData.IProceduralShape srcProceduralShape)
        {
            if (!srcProceduralShape.IsProceduralShapeEnabled)
            {
                return null;
            }

            FileFmt.ProceduralShapeParam dstProceduralShape = new FileFmt.ProceduralShapeParam();

            dstProceduralShape.proceduralShapeEnabled = srcProceduralShape.IsProceduralShapeEnabled;
            dstProceduralShape.exp = srcProceduralShape.Exp;
            dstProceduralShape.radius = srcProceduralShape.Radius;

            dstProceduralShape.innerStrokeEnabled = srcProceduralShape.IsInnerStrokeEnabled;
            dstProceduralShape.innerStrokeSize = srcProceduralShape.InnerStrokeSize;
            dstProceduralShape.innerStrokeBlendMode = (FileFmt.ProceduralShapeEffectBlendMode)srcProceduralShape.InnerStrokeBlendMode;
            dstProceduralShape.innerStrokeColor = Convert_Color4_(srcProceduralShape.InnerStrokeColor);

            dstProceduralShape.innerShadowEnabled = srcProceduralShape.IsInnerShadowEnabled;
            dstProceduralShape.innerShadowBlendMode = (FileFmt.ProceduralShapeEffectBlendMode)srcProceduralShape.InnerShadowBlendMode;
            dstProceduralShape.innerShadowColor = Convert_Color4_(srcProceduralShape.InnerShadowColor);
            dstProceduralShape.innerShadowAngle = srcProceduralShape.InnerShadowAngle;
            dstProceduralShape.innerShadowDistance = srcProceduralShape.InnerShadowDistance;
            dstProceduralShape.innerShadowSize = srcProceduralShape.InnerShadowSize;
            dstProceduralShape.innerShadowType = (FileFmt.ProceduralShapeShadowType)srcProceduralShape.InnerShadowType;

            dstProceduralShape.colorOverlayEnabled = srcProceduralShape.IsColorOverayEnabled;
            dstProceduralShape.colorOverlayBlendMode = (FileFmt.ProceduralShapeEffectBlendMode)srcProceduralShape.ColorOverlayBlendMode;
            dstProceduralShape.colorOverlayColor = Convert_Color4_(srcProceduralShape.ColorOverlayColor);

            dstProceduralShape.gradationOverlayEnabled = srcProceduralShape.IsGradationOverayEnabled;
            dstProceduralShape.gradationOverlayBlendMode = (FileFmt.ProceduralShapeEffectBlendMode)srcProceduralShape.GradationOverlayBlendMode;

            dstProceduralShape.gradationOverlayColor = new FileFmt.Color4[srcProceduralShape.GradationOverlayControlPointCount];
            dstProceduralShape.gradationOverlayControlPoint = new float[srcProceduralShape.GradationOverlayControlPointCount];
            for (int i = 0; i < srcProceduralShape.GradationOverlayControlPointCount; ++i)
            {
                dstProceduralShape.gradationOverlayColor[i] = Convert_Color4_(srcProceduralShape.GetGradationOverlayColor(i));
                dstProceduralShape.gradationOverlayControlPoint[i] = srcProceduralShape.GetGradationOverlayControlPoint(i);
            }
            dstProceduralShape.gradationOverlayAngle = srcProceduralShape.GradationOverlayAngle;

            dstProceduralShape.outerShadowEnabled = srcProceduralShape.IsOuterShadowEnabled;
            dstProceduralShape.outerShadowBlendMode = (FileFmt.ProceduralShapeEffectBlendMode)srcProceduralShape.OuterShadowBlendMode;
            dstProceduralShape.outerShadowColor = Convert_Color4_(srcProceduralShape.OuterShadowColor);
            dstProceduralShape.outerShadowAngle = srcProceduralShape.OuterShadowAngle;
            dstProceduralShape.outerShadowDistance = srcProceduralShape.OuterShadowDistance;
            dstProceduralShape.outerShadowSize = srcProceduralShape.OuterShadowSize;
            dstProceduralShape.outerShadowType = (FileFmt.ProceduralShapeShadowType)srcProceduralShape.OuterShadowType;

            return dstProceduralShape;
        }

#endregion

        internal AppData.ProceduralShape Convert_Pane_ProceduralShapeSelf(AppData.Pane dstPane, FileFmt.ProceduralShapeParam srcProceduralShape)
        {
            if (dstPane.IPicture == null)
            {
                return null;
            }

            Convert_Pane_ProceduralShape_(dstPane.IPicture.IProceduralShape as AppData.ProceduralShape, srcProceduralShape);
            return dstPane.IPicture.IProceduralShape as AppData.ProceduralShape;
        }

        internal FileFmt.ProceduralShapeParam Convert_Item_ProceduralShapeSelf(AppData.IProceduralShape srcProceduralShape)
        {
            return Convert_ToFile_ProceduralShape_(srcProceduralShape);
        }
    }
}
