﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Text;
using System.Collections;
using System.Diagnostics;

namespace LECore.Save_Load
{
    using Structures;
    using Structures.Core;
    using Structures.SerializableObject.Lan;
    using System.Linq;
    using static RlanHelper;
    using AppData = LECore.Structures;
    using FileFmt = LECore.Structures.SerializableObject.Lan;

    class RlpaConverter
    {
        #region ---------- Rlpa(読み込み)


        /// <summary>
        /// AnimTargetType に相応しい、アニメーションアトリビュートを取得します。
        /// TODO:
        /// アニメーションアトリビュートは名前で検索可能なので、
        /// 名前でアトリビュートを取得するように変更したい。
        /// セーブフォーマットにアトリビュート名を記述するようにしたい。
        /// </summary>
        /// <param name="type"></param>
        /// <returns></returns>
        static AnmAttribute GetTargetAnmAttribute_(AppData.Pane dstPane, FileFmt.AnimTargetType type)
        {
            // ------------ FIX ME !! ------------
            PaneAttribute paneAttr = dstPane.PaneAttrRef;
            switch (type)
            {
                case FileFmt.AnimTargetType.TranslateX: return paneAttr.TransAttr.FindAttributeByIdx(0);
                case FileFmt.AnimTargetType.TranslateY: return paneAttr.TransAttr.FindAttributeByIdx(1);
                case FileFmt.AnimTargetType.TranslateZ: return paneAttr.TransAttr.FindAttributeByIdx(2);
                case FileFmt.AnimTargetType.ScaleX: return paneAttr.ScaleAttr.FindAttributeByIdx(0);
                case FileFmt.AnimTargetType.ScaleY: return paneAttr.ScaleAttr.FindAttributeByIdx(1);
                case FileFmt.AnimTargetType.RotateX: return paneAttr.RotAngAttr.FindAttributeByIdx(0);
                case FileFmt.AnimTargetType.RotateY: return paneAttr.RotAngAttr.FindAttributeByIdx(1);
                case FileFmt.AnimTargetType.RotateZ: return paneAttr.RotAngAttr.FindAttributeByIdx(2);
                case FileFmt.AnimTargetType.SizeW: return paneAttr.SizeAttr.FindAttributeByIdx(0);
                case FileFmt.AnimTargetType.SizeH: return paneAttr.SizeAttr.FindAttributeByIdx(1);
                default: Debug.Assert(false); return null;
            }
        }

        /// <summary>
        /// シリアライズデータ => アプリケーションデータ
        /// </summary>
        // static public void LoadRlpaToPane( object dstObject, FileFmt.AnimTarget srcAnimTraget )
        static public void LoadRlpaToPane(object dstObject, FileFmt.AnimContent srcAnimContent, string tag)
        {
            Pane dstPane = dstObject as Pane;
            if (dstPane == null)
            {
                return;
            }

            if (dstPane.PaneName != srcAnimContent.name)
            {
                return;
            }

            foreach (FileFmt.AnimTarget srcAnimTraget in srcAnimContent.Items)
            {
                AnmAttribute dstAttr = GetTargetAnmAttribute_(dstPane, srcAnimTraget.target);
                Debug.Assert(dstAttr != null);

                RlanHelper.SetHermiteKeyFrame_(dstAttr, srcAnimTraget, tag);
            }
        }

        #endregion ---------- Rlpa


        #region --------------------- Rlpa(保存)
        /// <summary>
        /// FileFmt.AnimContent[] ---- Rlpa
        /// </summary>
        static public FileFmt.AnimContent[] SavePaneSRTAnim(AppData.IPane pane, string tag)
        {
            return ConvertToAnimContents<IPaneAttribute, AnimPaneSRTTarget>(
                tag,
                ParamaterKind.Animation_PaneSRT,
                pane,
                x => new[] { new AnimContentSource<IPaneAttribute>(x.PaneName, x.IPaneAttribute) },
                x =>GetAnimTargetSourcesFromSubAttributes(x.TransIAttr, new[] { AnimTargetType.TranslateX, AnimTargetType.TranslateY, AnimTargetType.TranslateZ })
                    .Concat(GetAnimTargetSourcesFromSubAttributes(x.ScaleIAttr, new[] { AnimTargetType.ScaleX, AnimTargetType.ScaleY }))
                    .Concat(GetAnimTargetSourcesFromSubAttributes(x.RotAngIAttr, new[] { FileFmt.AnimTargetType.RotateX, AnimTargetType.RotateY, AnimTargetType.RotateZ }))
                    .Concat(GetAnimTargetSourcesFromSubAttributes(x.SizeIAttr, new[] { AnimTargetType.SizeW, AnimTargetType.SizeH }))
                ).ToArray();
        }

        #endregion --------------------- Rlpa
    }
}
