﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Diagnostics;

namespace LECore.Manipulator
{
    using LECore.Structures;
    using LECore.Structures.Nsrif.Attributes;
    using LECore.Structures.Core.Command;
    using MaterialTexMapCommandFactory = LECore.Structures.Core.Command.MementoCommandFactory<LECore.Structures.IMaterialTexMap>;

    /// <summary>
    /// MaterialManipulator の概要の説明です。
    /// </summary>
    public class MaterialTexMapManipulator : BaseManipulator
    {
        // 操作対象
        MaterialTexMap						_target = null;
        MaterialTexMapCommandFactory _MaterialTexMapCommandFactory;

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public MaterialTexMapManipulator()
        {
            _MaterialTexMapCommandFactory = new MaterialTexMapCommandFactory(
                delegate( IMaterialTexMap src ){return new MaterialTexMapMemento( src );} );
        }

        /// <summary>
        /// 操作対象を設定します。
        /// </summary>
        /// <param name="targetTextBox"></param>
        public void BindTarget( IMaterialTexMap targetMatTexMap )
        {
            _target = targetMatTexMap as MaterialTexMap;
            Debug.Assert( _target != null );
        }

        /// <summary>
        /// 繰り返し方法 S
        /// </summary>
        public AttrTexWrap WrapS
        {
            set
            {
                if( _target.WrapS != value )
                {
                    _MaterialTexMapCommandFactory.Modify( _target, delegate()
                    {
                        _target.WrapS = value;
                    } );
                }
            }
        }

        /// <summary>
        /// 繰り返し方法 T
        /// </summary>
        public AttrTexWrap WrapT
        {
            set
            {
                if( _target.WrapT != value )
                {
                    _MaterialTexMapCommandFactory.Modify( _target, delegate()
                    {
                        _target.WrapT = value;
                    } );
                }
            }
        }

        /// <summary>
        /// 縮小フィルタ
        /// </summary>
        public AttrTexFilterMin MinFilter
        {
            set
            {
                if( _target.MinFilter != value )
                {
                    _MaterialTexMapCommandFactory.Modify( _target, delegate()
                    {
                        _target.MinFilter = value;
                    } );
                }
            }
        }

        /// <summary>
        /// 拡大フィルタ
        /// </summary>
        public AttrTexFilterMag MagFilter
        {
            set
            {
                if( _target.MagFilter != value )
                {
                    _MaterialTexMapCommandFactory.Modify( _target, delegate()
                    {
                        _target.MagFilter = value;
                    } );
                }
            }
        }

        /// <summary>
        /// テクスチャ画像を初期設定します。
        /// </summary>
        /// <param name="mgr"></param>
        public void SetupTextureImage( ITextureMgr mgr )
        {
        }
    }
}
