﻿using LECore.Structures;
using LECore.Structures.Core.Command;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace LECore.Manipulator
{
    /// <summary>
    /// ドキュメントのヘッダーのマニピュレータ
    /// </summary>
    public class DocumentHeaderManipulator : TargetManipulatorBase<IDocumentHeader>
    {
        public string Comment
        {
            set
            {
                Set(value, x => x.Comment, (x, y) => x.Comment = y);
            }
        }
    }

    public class TargetManipulatorBase<T>
    {
        public void BindTarget(T target)
        {
            _target = target;
        }

        protected T _target;
        protected class PropertyMement<S> : ICommandMemento<T>
        {
            readonly S _data;
            readonly Action<T, S> _copy;
            public PropertyMement(S src, Action<T, S> copy)
            {
                _data = src;
                _copy = copy;
            }

            public void CopyTo(T dst)
            {
                _copy(dst, _data);
            }
        }

        protected void Set<S>(S value, Func<T, S> getter, Action<T, S> setter)
        {
            if (!getter(_target).Equals(value))
            {
                new MementoCommandFactory<T>(delegate(T src)
                {
                    return new PropertyMement<S>(getter(src), setter);
                }).Modify(_target, () => setter(_target, value));
            }
        }
    }

}
