﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Diagnostics;
using System.Runtime.InteropServices;



namespace LECore
{
    using Win32;
    /// <summary>
    /// LEStopWatch の概要の説明です。
    /// </summary>
    public class LEStopWatch
    {
        #region フィールド
        const long              _DefaultClockValue     = 0;
        static long             _SystemConterFrequency = 0;

        long             _countStateClock = _DefaultClockValue;
        #endregion フィールド



        /// <summary>
        /// 計測が開始できる状態か？
        /// </summary>
        bool _ReadyToBeginCount
        {
            get{ return _DefaultClockValue == _countStateClock;}
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public LEStopWatch()
        {
            Win32.Kernel32.QueryPerformanceFrequency( ref _SystemConterFrequency );
        }



        #region Tick => 変換関数

        /// <summary>
        /// ミリ秒に変換
        /// </summary>
        static public float TicksToMilliSec( long ticks )
        {
            float miliSec = (float)ticks / (float)_SystemConterFrequency;
            return miliSec * 1000.0f;
        }

        #endregion 変換関数

        #region 時間計測
        /// <summary>
        /// 時間計測開始
        /// </summary>
        public void BeginCount()
        {
            // 多重呼び出しは想定されていません。
            Debug.Assert( _ReadyToBeginCount );
            Win32.Kernel32.QueryPerformanceCounter( ref _countStateClock );
        }

        /// <summary>
        /// 計測開始からのクロック
        /// </summary>
        public long GetCurrentTick()
        {
            long count = 0;
            Win32.Kernel32.QueryPerformanceCounter( ref count );

            return count - _countStateClock;
        }

        /// <summary>
        /// 時間をミリ秒で取得します。
        /// </summary>
        public long EndCount()
        {
            long currentTick = GetCurrentTick();
            _countStateClock = _DefaultClockValue;
            return currentTick;
        }

        #endregion 時間計測
    }
}
