﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_CONFIG_PLATFORM_H_
#define NW_CONFIG_PLATFORM_H_

#define NW_FROM_TOOL
#define NW_DEBUG

#if !defined(NW_DEBUG) && !defined(NW_DEVELOP) && !defined(NW_RELEASE)
#error "Build target is not defined."
#endif

#if defined( NW_PLATFORM_RVL )
    #include <nw/config/platform/rvl.h>
#elif defined( NW_PLATFORM_TWL )
    #include <nw/config/platform/twl.h>
#elif defined( _WIN32 )
    #include <nw/config/platform/win32.h>
#elif defined( NW_PLATFORM_CTR )
    #include <nw/config/platform/ctr.h>
#elif defined( CAFE )
    #include <nw/config/platform/cafe.h>
#else

#error "Unknown platform"

#endif

// TODO: 今からの変更は影響が大きいが、 TARGET と PLATFORM の名前の用途が逆の方がよいかも。

// ByteOrder Macro
#define NW_ENDIAN_LITTLE    (0)
#define NW_ENDIAN_BIG       (1)


// NW_PLATFORM_ENDIAN (ターゲットとなるプラットフォームのバイトオーダー) の決定
#if defined( NW_LITTLE_ENDIAN )
    #define NW_PLATFORM_ENDIAN NW_ENDIAN_LITTLE
    #define NW_CPU_ENDIAN      NW_ENDIAN_LITTLE
#else
    #define NW_PLATFORM_ENDIAN NW_ENDIAN_BIG
    #define NW_CPU_ENDIAN      NW_ENDIAN_BIG
#endif

/* NW_CONFIG_PLATFORM_H_ */
#endif
