﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_CONFIG_MACROS_H_
#define NW_CONFIG_MACROS_H_

#include <nw/config/compiler.h>

#define NW_MACRO_STRING_I_(text)    #text

#if defined( NW_COMPILER_CWCC )

#define NW_MACRO_STRING_(text)         NW_MACRO_STRING_O_((text))
#define NW_MACRO_STRING_O_(params)     NW_MACRO_STRING_I_ ## params

#define NW_MACRO_CAT_(a, b)            NW_MACRO_CAT_O_((a, b))
#define NW_MACRO_CAT_O_(params)        NW_MACRO_CAT_I_ ## params
#define NW_MACRO_CAT_I_(a, b)          a ## b

#elif defined( NW_COMPILER_MSVC )

#define NW_MACRO_STRING_(text)         NW_MACRO_STRING_O_((text))
#define NW_MACRO_STRING_O_(params)     NW_MACRO_STRING_I_ params

#define NW_MACRO_CAT_(a, b)            NW_MACRO_CAT_I_(a, b)
#define NW_MACRO_CAT_I_(a, b)          NW_MACRO_CAT_II_(a ## b)
#define NW_MACRO_CAT_II_(text)         text

#else // RVCT もこれでOK

#define NW_MACRO_STRING_(text)         NW_MACRO_STRING_I_(text)

#define NW_MACRO_CAT_I_(a, b)          a ## b
#define NW_MACRO_CAT_(a, b)            NW_MACRO_CAT_I_(a, b)

#endif

#define NW_ADAPTIVE_HEADER(prefix, target)        <NW_MACRO_CAT_(prefix, target)>
#define NW_ADAPTIVE_HEADER_LOCAL(prefix, target)  NW_MACRO_STRING_(NW_MACRO_CAT_(prefix, target))

#endif // NW_CONFIG_MACROS_H_
