﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;

namespace NW4R.ColorPicker
{
    /// <summary>
    /// カレントカラー表示コントロールクラス。
    /// </summary>
    public sealed class ColorBox : Panel
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public ColorBox()
        {
            // ちらつきの防止用
            this.DoubleBuffered = true;
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override void OnSizeChanged(EventArgs e)
        {
            if (this.DesignMode)
            {
                if (this.Parent != null)
                {
                    this.Parent.Invalidate();
                }
            }
            base.OnSizeChanged(e);
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override void OnPaint(PaintEventArgs e)
        {
            if (this.Enabled)
            {
                e.Graphics.Clear(Color.FromArgb(255, this.BackColor));
            }
            else
            {
                e.Graphics.Clear(SystemColors.Control);
            }
        }
    }
}
