﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NintendoWare.Font
{
    /// <summary>
    /// Cafe実機フォント読み取りクラス
    /// </summary>
    public class GenericFontReader : NitroFontReader
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public GenericFontReader(string inputFile)
            : base(inputFile)
        {

        }

        /// <summary>
        /// CTR用のフォントランタイムで使用するテクスチャフォーマット値から
        /// GlyphImageFormatを取得します。
        /// </summary>
        /// <param name="format">CTR用のフォントランタイムで使用するテクスチャフォーマット値</param>
        /// <returns>GlyphImageFormatを返します。</returns>
        /// <summary>
        /// CTR用のフォントランタイムで使用するテクスチャフォーマット値から
        /// GlyphImageFormatを取得します。
        /// </summary>
        /// <param name="format">CTR用のフォントランタイムで使用するテクスチャフォーマット値</param>
        /// <returns>GlyphImageFormatを返します。</returns>
        protected override GlyphImageFormat GetGlyphImageFormat(ushort format, bool isPackedFont) // 分離
        {
            switch ((TextureFormatGeneric)format)
            {
                case TextureFormatGeneric.BC4: return isPackedFont ? GlyphImageFormat.LA4PackedPassThrough : GlyphImageFormat.A8;
                case TextureFormatGeneric.BC5: return GlyphImageFormat.LA8;
                case TextureFormatGeneric.LA8: return GlyphImageFormat.LA8;
                case TextureFormatGeneric.BC1: return GlyphImageFormat.RGB565;
                case TextureFormatGeneric.BC3: return GlyphImageFormat.RGB5A3;
                case TextureFormatGeneric.RGBA8: return GlyphImageFormat.RGBA8;
                case TextureFormatGeneric.BC1_SRGB: return GlyphImageFormat.RGB565_SRGB;
                case TextureFormatGeneric.BC3_SRGB: return GlyphImageFormat.RGB5A3_SRGB;
                case TextureFormatGeneric.RGBA8_SRGB: return GlyphImageFormat.RGBA8_SRGB;
                case TextureFormatGeneric.A8: return isPackedFont ? GlyphImageFormat.LA4PackedNoCompressPassThrough : GlyphImageFormat.A8;
                default: throw new InvalidOperationException("unsupported format. " + format);
            }
        }

        /// <summary>
        ///
        /// </summary>
        protected override void ConvertFormat(RgbImage sheet, byte[] image, GlyphImageFormat gif, Runtime.FontTextureGlyph tg)
        {
            // 何もしません。
            // 注意：
            // Cafe での実機フォント読み取りは、画像フォーマットや xlor 抽出のためだけに利用されます。
            // 非圧縮形式フォントについては、対応が可能です。ユーザからの要望があれば対応します。
        }
    }
}
