﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.Font
{
    using System;
    using System.Windows.Media;

    [Serializable]
    public class OutImageSettings
    {
        public OutImageSettings()
        {
            this.OrderFile = "cp1252.xlor";
            this.IsImageCenter = true;
            this.IsDrawGrid = true;
            this.OutImageFormat = ImageFileFormat.Ext;
            this.BackgroundColor = FB.BackgroundColor;
            this.GridColor = FB.GridColor;
            this.MarginColor = FB.MarginColor;
            this.WidthBarColor = FB.WidthBarColor;
            this.NullBlockColor = FB.NullBlockColor;
        }

        public StringList FilePaths { get; set; }

        public string OrderFile { get; set; }

        public bool IsSizeOffsetSpec { get; set; }

        public int CellSizeWidth { get; set; }

        public int CellSizeHeight { get; set; }

        public int CellSizeLeft { get; set; }

        public int CellSizeTop { get; set; }

        public int CellMarginLeft { get; set; }

        public int CellMarginTop { get; set; }

        public int CellMarginRight { get; set; }

        public int CellMarginBottom { get; set; }

        public bool IsImageCenter { get; set; }

        public bool IsDrawGrid { get; set; }

        /// <summary>
        /// 画像データ出力では、常にカーニング情報ファイルを出力します。
        /// </summary>
        public bool IsOutKerningData { get { return true; } }

        public ImageFileFormat OutImageFormat { get; set; }

        public Color GridColor { get { return (Color)ColorConverter.ConvertFromString(_GridColor); } set { _GridColor = value.ToString(); } }

        public Color MarginColor { get { return (Color)ColorConverter.ConvertFromString(_MarginColor); } set { _MarginColor = value.ToString(); } }

        public Color WidthBarColor { get { return (Color)ColorConverter.ConvertFromString(_WidthBarColor); } set { _WidthBarColor = value.ToString(); } }

        public Color NullBlockColor { get { return (Color)ColorConverter.ConvertFromString(_NullBlockColor); } set { _NullBlockColor = value.ToString(); } }

        public Color BackgroundColor { get { return (Color)ColorConverter.ConvertFromString(_BackgroundColor); } set { _BackgroundColor = value.ToString(); } }

        /// <summary>
        /// Color型のままではシリアライズ出来ないので文字列で保持します。
        /// </summary>
        private string _GridColor;
        private string _MarginColor;
        private string _WidthBarColor;
        private string _NullBlockColor;
        private string _BackgroundColor;
    }
}
