﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.Font.Win32
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Runtime.InteropServices;
    using UINT = System.UInt32;
    using DWORD = System.UInt32;

    /// <summary>
    /// Code Page Default Values.
    /// </summary>
    public class CodePage
    {
        public const int    ACP         = 0,          // default to ANSI code page
                            OEMCP       = 1,          // default to OEM  code page
                            MACCP       = 2,          // default to MAC  code page
                            ThreadACP   = 3,          // current thread's ANSI code page
                            Symbol      = 42,         // SYMBOL translations

                            UTF7        = 65000,      // UTF-7 translation
                            UTF8        = 65001;      // UTF-8 translation
    }

    /// <summary>
    /// MBCS and Unicode Translation Flags.
    /// </summary>
    public class MBChar
    {
        public const int    Precomposed     = 0x00000001,   // use precomposed chars
                            Composite       = 0x00000002,   // use composite chars
                            UseGlyphChars   = 0x00000004,   // use glyph chars, not ctrl chars
                            ErrInvalidChars = 0x00000008;   // error for invalid chars
    }

    /// <summary>
    /// MBCS and Unicode Translation Flags.
    /// </summary>
    public class WideChar
    {
        public const int    CompositeCheck  = 0x00000200,   // convert composite to precomposed
                            DiscardNS       = 0x00000010,   // discard non-spacing chars
                            SeparateChars   = 0x00000020,   // generate separate chars
                            DefaultChar     = 0x00000040,   // replace w/ default char

                            NoBestFitChars  = 0x00000400;   // do not use best fit chars
    }

    public class Kernel
    {
        const string DllName = "Kernel32.dll";

        // int WINAPI WideCharToMultiByte(UINT CodePage, DWORD dwFlags, LPCWSTR lpWideCharStr, int cchWideChar,
        //     LPSTR lpMultiByteStr, int cbMultiByte, LPCSTR lpDefaultChar, LPBOOL lpUsedDefaultChar);
        [DllImport(DllName, SetLastError = true)]
        public static extern int WideCharToMultiByte(UINT CodePage, DWORD dwFlags, [In] ushort[] wideCharStr, int cchWideChar,
            [Out] byte[] lpMultiByteStr, int cbMultiByte, [In] byte[] lpDefaultChar, [MarshalAs(UnmanagedType.Bool)] out bool lpUsedDefaultChar);

        // int WINAPI MultiByteToWideChar(UINT CodePage, DWORD dwFlags, LPCSTR lpMultiByteStr, int cbMultiByte, LPWSTR lpWideCharStr, int cchWideChar);
        [DllImport(DllName, SetLastError = true)]
        public static extern int MultiByteToWideChar(UINT CodePage, DWORD dwFlags, [In] byte[] lpMultiByteStr, int cbMultiByte, [Out] ushort[] lpWideCharStr, int cchWideChar);

    }
}
