﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.Font.Win32
{
    using System;
    using System.Runtime.InteropServices;
    using UINT = System.UInt32;
    using DWORD = System.UInt32;
    using HWND = System.IntPtr;
    using WPARAM = System.IntPtr;
    using LPARAM = System.IntPtr;
    using UINT_PTR = System.UIntPtr;

    [Flags]
    public enum ColorChooseFlag : int
    {
        RgbInit                 = 0x00000001,
        FullOpen                = 0x00000002,
        PreventFullOpen         = 0x00000004,
        ShowHelp                = 0x00000008,
        EnableHook              = 0x00000010,
        EnableTemplate          = 0x00000020,
        EnableTemplateHandle    = 0x00000040,
        SolidColor              = 0x00000080,
        AnyColor                = 0x00000100,
    }

    // typedef UINT_PTR (CALLBACK *LPCCHOOKPROC) (HWND, UINT, WPARAM, LPARAM);
    public delegate UINT_PTR CCHOOKPROC(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);

    [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
    public class CHOOSECOLOR
    {
        public DWORD lStructSize;
        public HWND hwndOwner;
        public HWND hInstance;
        public COLORREF rgbResult;
        public IntPtr lpCustColors;     // COLORREF* lpCustColors;
        public ColorChooseFlag Flags;
        public LPARAM lCustData;

        [MarshalAs(UnmanagedType.FunctionPtr)]
        public CCHOOKPROC lpfnHook;

        [MarshalAs(UnmanagedType.LPTStr)]
        public string lpTemplateName;
    }

    public class CommonDialog
    {
        const string DllName = "Comdlg32.dll";

        // WINCOMMDLGAPI BOOL APIENTRY ChooseColor(LPCHOOSECOLOR);
        [DllImport(DllName, CharSet = CharSet.Unicode)]
        public static extern bool ChooseColor([In, Out] CHOOSECOLOR cc);
    }
}
