﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.Font
{
    using System.Collections.Generic;
    using NintendoWare.Font.Runtime;

    public class NnsData
    {
        private readonly BlockMap blocks = new BlockMap();

        private BinaryFileHeader header;

        public NnsData()
        {
        }

        protected BlockMap Blocks
        {
            get { return this.blocks; }
        }

        protected BinaryFileHeader Header
        {
            get { return this.header; }
        }

        public void SetHeader(BinaryFileHeader header)
        {
            this.header = header;
        }

        public GeneralBinaryBlockInfo GetBlock(Signature32 id, int no)
        {
            BlockList value;

            if (this.blocks.TryGetValue(id, out value))
            {
                if (no < value.Count)
                {
                    return value[no];
                }
            }

            return null;
        }

        public int GetNumBlock(Signature32 id)
        {
            BlockList value;
            var found = this.blocks.TryGetValue(id, out value);
            return found ? value.Count : 0;
        }

        public void SetBlock(Signature32 id, IBinarizable body)
        {
            GeneralBinaryBlockInfo bbi = new GeneralBinaryBlockInfo();

            bbi.Kind = id;
            bbi.Body = body;

            this.AddBlock(id, bbi);
        }

        public GeneralBinaryBlockInfo GetBlock(Signature32 id)
        {
            return this.GetBlock(id, 0);
        }

        protected GeneralBinaryBlockInfo GetBlockItnl(Signature32 id, int no)
        {
            BlockList value;
            if (this.blocks.TryGetValue(id, out value))
            {
                if (no < value.Count)
                {
                    return value[no];
                }
            }

            return null;
        }

        protected GeneralBinaryBlockInfo GetBlockItnl(Signature32 id)
        {
            return this.GetBlockItnl(id, 0);
        }

        private void AddBlock(Signature32 id, GeneralBinaryBlockInfo bbi)
        {
            BlockList value;
            BlockList list;

            if (!this.blocks.TryGetValue(id, out value))
            {
                list = new BlockList();
                this.blocks.Add(id, list);
            }
            else
            {
                list = value;
            }

            list.Add(bbi);
        }

        public class GeneralBinaryBlockInfo
        {
            public Signature32 Kind { get; set; }

            public IBinarizable Body { get; set; }

            public int Get4AlignedBlockSize(int blockOffset)
            {
                var bodyOffset = blockOffset + BinaryBlockHeader.Length;
                var contentsSize = GlCm.ROUND_UP(this.Body.GetBlockContentsSize(bodyOffset), 4);
                return BinaryBlockHeader.Length + contentsSize;
            }
        }

        protected class BlockList : List<GeneralBinaryBlockInfo>
        {
        }

        protected class BlockMap : Dictionary<Signature32, BlockList>
        {
        }
    }
}
