﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.Font
{
    using System;
    using System.IO;

    /// <summary>
    ///
    /// </summary>
    public abstract class FontIO
    {
        /// <summary>
        /// DTD によるバリデーションを有効にするかどうか？
        /// </summary>
        public bool UseDtdValidation { get; set;}

        /// <summary>
        ///
        /// </summary>
        public static void ValidateOrderFile(string file, bool useDtdValidation)
        {
            if (!IsFileExists(file))
            {
                throw GlCm.ErrMsg(ErrorType.Parameter, Strings.IDS_ERR_FILE_NOT_EXISTS, file);
            }

            // 試しに読んでみる
            GlyphOrder order = new GlyphOrder();

            order.Load(file, useDtdValidation);

            if (order.GetHNum() < 0)
            {
                throw GlCm.ErrMsg(ErrorType.Xml, Strings.IDS_ERR_INVALID_ORDER_WIDTH, order.GetHNum());
            }

            if (order.GetVNum() < 0)
            {
                throw GlCm.ErrMsg(ErrorType.Xml, Strings.IDS_ERR_INVALID_ORDER_HEIGHT, order.GetVNum());
            }
        }

        /// <summary>
        ///
        /// </summary>
        public static void ValidateOutputPath(string file)
        {
            if (file == string.Empty)
            {
                throw GlCm.ErrMsg(ErrorType.Parameter, Strings.IDS_ERR_FILE_NOT_SPECIFIED);
            }

            if (Directory.Exists(file))
            {
                throw GlCm.ErrMsg(ErrorType.Parameter, Strings.IDS_ERR_FILE_IS_DIRECTORY, file);
            }

            // ファイルの存在をチェック
            if (File.Exists(file))
            {
                // ファイルが書き込み可能かチェック
                if (!IsFileWritable(file))
                {
                    throw GlCm.ErrMsg(ErrorType.Parameter, Strings.IDS_ERR_FILE_IS_READONLY, file);
                }
            }
            else
            {
                var dir = Path.GetDirectoryName(file);

                // カレントディレクトリ
                if (dir == string.Empty)
                {
                }
                else
                {
                    // ディレクトリの存在をチェック
                    if (!Directory.Exists(dir))
                    {
                        throw GlCm.ErrMsg(ErrorType.Parameter, Strings.IDS_ERR_DIRECTORY_NOT_EXISTS, dir);
                    }
                }
            }
        }

        /// <summary>
        ///
        /// </summary>
        public abstract void ValidateInput();

        /// <summary>
        ///
        /// </summary>
        protected static bool IsFileExists(string file)
        {
            if (file.Length == 0)
            {
                throw GlCm.ErrMsg(ErrorType.Parameter, Strings.IDS_ERR_FILE_NOT_SPECIFIED);
            }

            return File.Exists(file);
        }

        /// <summary>
        ///
        /// </summary>
        protected static bool IsFileWritable(string file)
        {
            try
            {
                var attr = File.GetAttributes(file);
                return (attr & FileAttributes.ReadOnly) == 0;
            }
            catch (IOException)
            {
            }
            catch (NotSupportedException)
            {
            }

            return false;
        }

        /// <summary>
        ///
        /// </summary>
        protected class ArrangeInfo
        {
            public int Width { get; set; }

            public int Ascent { get; set; }

            public int Descent { get; set; }

            public int BaselinePos { get; set; }
        }
    }
}
