﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.Font
{
    /// <summary>
    /// ProgressBarコントロール用ViewModelです。
    /// </summary>
    public class ProgressBarViewModel : ViewModelBase
    {
        private int value;
        private int min;
        private int max;

        /// <summary>
        /// 現在の位置を取得または設定します。
        /// </summary>
        public int Value
        {
            get
            {
                return this.value;
            }

            set
            {
                if (value == this.value)
                {
                    return;
                }

                this.value = value;
                this.OnPropertyChanged("Value");
            }
        }

        /// <summary>
        /// 範囲の最小値を取得または設定します。
        /// </summary>
        public int Minimum
        {
            get
            {
                return this.min;
            }

            set
            {
                if (value == this.value)
                {
                    return;
                }

                this.min = value;
                this.OnPropertyChanged("Minimum");
            }
        }

        /// <summary>
        /// 範囲の最大値を取得または設定します。
        /// </summary>
        public int Maximum
        {
            get
            {
                return this.max;
            }

            set
            {
                if (value == this.value)
                {
                    return;
                }

                this.max = value;
                this.OnPropertyChanged("Maximum");
            }
        }
    }
}
