﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/gfx/util/gfx_DebugFontTextWriter.h>
#include <nns/gfx/gfx_PrimitiveRenderer.h>


void _DrawMeter( nn::gfx::CommandBuffer* pCommandBuffer, nn::gfx::util::DebugFontTextWriter* pTextWriter, nns::gfx::PrimitiveRenderer::Renderer* pPrimitiveRenderer,
                                            const char* pString, int parameter, int maxParameter, float x, float y, float w, float h, int align, nn::util::Color4u8 groundColor, bool percentDraw = false ) NN_NOEXCEPT;

// メータに表示するアイテム
struct MeterItem
{
    int                 value;
    nn::util::Color4u8  color;
};

// MeterItem を引数にとりメーターを表示する
void _DrawMeter( nn::gfx::CommandBuffer* pCommandBuffer, nn::gfx::util::DebugFontTextWriter* pTextWriter, nns::gfx::PrimitiveRenderer::Renderer* pPrimitiveRenderer,
                                            const char* pString, MeterItem* meterItemArray, int meterItemCount, int maxValue, float x, float y, float w, float h, int align, nn::util::Color4u8 groundColor, bool percentDraw = false ) NN_NOEXCEPT;


// "pString(%s)"
void _DrawTextBox( nn::gfx::CommandBuffer* pCommandBuffer, nn::gfx::util::DebugFontTextWriter* pTextWriter, nns::gfx::PrimitiveRenderer::Renderer* pPrimitiveRenderer,
                                            const char* pString, float x, float y, float w, float h, int align, nn::util::Color4u8 groundColor ) NN_NOEXCEPT;

// "parameter(%n)"
void _DrawTextBox( nn::gfx::CommandBuffer* pCommandBuffer, nn::gfx::util::DebugFontTextWriter* pTextWriter, nns::gfx::PrimitiveRenderer::Renderer* pPrimitiveRenderer,
                                           const char* pString, size_t parameter, float x, float y, float w, float h, int align, nn::util::Color4u8 groundColor ) NN_NOEXCEPT;

// "parameter(%f)"
void _DrawTextBox( nn::gfx::CommandBuffer* pCommandBuffer, nn::gfx::util::DebugFontTextWriter* pTextWriter, nns::gfx::PrimitiveRenderer::Renderer* pPrimitiveRenderer,
                                           const char* pString, float parameter, float x, float y, float w, float h, int align, nn::util::Color4u8 groundColor ) NN_NOEXCEPT;

// "parameter(%n)"
void _DrawTextBox( nn::gfx::CommandBuffer* pCommandBuffer, nn::gfx::util::DebugFontTextWriter* pTextWriter, nns::gfx::PrimitiveRenderer::Renderer* pPrimitiveRenderer,
                                            int parameter, float x, float y, float w, float h, int align, nn::util::Color4u8 groundColor ) NN_NOEXCEPT;

// "pString(%s) parameter(%n)"
void _DrawTextBox( nn::gfx::CommandBuffer* pCommandBuffer, nn::gfx::util::DebugFontTextWriter* pTextWriter, nns::gfx::PrimitiveRenderer::Renderer* pPrimitiveRenderer,
                                            const char* pString, int parameter, float x, float y, float w, float h, int align, nn::util::Color4u8 groundColor ) NN_NOEXCEPT;

// "parameter(%f) pString(%s)"
void _DrawTextBox( nn::gfx::CommandBuffer* pCommandBuffer, nn::gfx::util::DebugFontTextWriter* pTextWriter, nns::gfx::PrimitiveRenderer::Renderer* pPrimitiveRenderer,
                                            float parameter, const char* pString, float x, float y, float w, float h, nn::util::Color4u8 groundColor ) NN_NOEXCEPT;

// "parameter(%f) / parameterMax(%f)"
void _DrawTextBox( nn::gfx::CommandBuffer* pCommandBuffer, nn::gfx::util::DebugFontTextWriter* pTextWriter, nns::gfx::PrimitiveRenderer::Renderer* pPrimitiveRenderer,
                                            const char* pString, float parameter, float parameterMax, float x, float y, float w, float h, int align, nn::util::Color4u8 groundColor ) NN_NOEXCEPT;
