﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace EffectMaker.UIControls.EffectBrowser.Controls.FileListView.Base
{
    using System.Linq;
    using System.Windows.Forms;

    /// <summary>
    /// The eb file list view.
    /// </summary>
    public partial class EBFileListView
    {
        #region Methods

        /// <summary>
        /// The on item drag.
        /// </summary>
        /// <param name="e">
        /// イベント引数
        /// </param>
        protected override void OnItemDrag(ItemDragEventArgs e)
        {
            base.OnItemDrag(e);

            var dataObject = new DataObject(
                DataFormats.FileDrop,
                this.SelectedFiles.Select(x => x.FileFullPath).ToArray());

            this.DoDragDrop(dataObject, DragDropEffects.Copy | DragDropEffects.Move);
        }

        #endregion
    }
}
