﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace EffectMaker.UIControls.EffectBrowser.Controls
{
    using System;
    using System.Drawing;
    using System.Windows.Forms;

    using EffectMaker.UIControls.EffectBrowser.Controls.Basic;
    using EffectMaker.UIControls.EffectBrowser.Data;

    /// <summary>
    /// The eb label color combo box.
    /// </summary>
    public class EBLabelColorComboBox : EBComboBox
    {
        #region Constructors and Destructors

        /// <summary>
        /// Initializes a new instance of the <see cref="EBLabelColorComboBox"/> class.
        /// </summary>
        public EBLabelColorComboBox()
        {
            this.DrawMode = DrawMode.OwnerDrawFixed;
            this.DropDownStyle = ComboBoxStyle.DropDownList;
            this.ItemHeight = 20;

            foreach (var e in Enum.GetValues(typeof(LabelColorType)))
            {
                this.Items.Add(e);
            }
        }

        #endregion

        #region Methods

        /// <summary>
        /// The on draw item.
        /// </summary>
        /// <param name="e">
        /// イベント引数
        /// </param>
        protected override void OnDrawItem(DrawItemEventArgs e)
        {
            base.OnDrawItem(e);

            e.DrawBackground();
            e.DrawFocusRectangle();

            if (e.Index == -1)
            {
                return;
            }

            var x = 2;
            var labelColor = (LabelColorType)this.Items[e.Index];

            // 色四角
            using (var brush = new SolidBrush(Constants.LabelColorColors[labelColor]))
            {
                const int Margin = 2;

                var size = e.Bounds.Height - (Margin * 2) - 1;

                x += Margin + 1;
                var iconRect = new Rectangle(x, e.Bounds.Y + Margin, size, size);
                e.Graphics.FillRectangle(brush, iconRect);
                e.Graphics.DrawRectangle(Pens.LightGray, iconRect);

                x += size;
            }

            {
                // 名前
                x += 2;
                const TextFormatFlags LeftFlag = TextFormatFlags.Left | TextFormatFlags.VerticalCenter;

                var rect = new Rectangle(x, e.Bounds.Y, e.Bounds.Width - x, e.Bounds.Height);
                var name = string.Format(Properties.Resources.Color_Name, (int)labelColor);

                TextRenderer.DrawText(e.Graphics, name, this.Font, rect, e.ForeColor, LeftFlag);
            }
        }

        #endregion
    }
}
