﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace EffectMaker.UIControls.EffectBrowser.Controls.Basic
{
    using System.Drawing;
    using System.Windows.Forms;

    using EffectMaker.UIControls.EffectBrowser.Utilities;

    /// <summary>
    /// The eb image button.
    /// </summary>
    public class EBImageButton : EBButton
    {
        #region Fields

        /// <summary>
        /// The mouse down image.
        /// </summary>
        private Image mouseDownImage;

        /// <summary>
        /// The mouse over image.
        /// </summary>
        private Image mouseOverImage;

        /// <summary>
        /// The normal image.
        /// </summary>
        private Image normalImage;

        #endregion

        #region Constructors and Destructors

        /// <summary>
        /// Initializes a new instance of the <see cref="EBImageButton"/> class.
        /// </summary>
        public EBImageButton()
        {
            this.BackColor = Color.Transparent;
            this.FlatAppearance.BorderColor = Color.FromArgb(0, 255, 255, 255);
            this.FlatAppearance.BorderSize = 0;
            this.FlatAppearance.CheckedBackColor = Color.Transparent;
            this.FlatAppearance.MouseDownBackColor = Color.Transparent;
            this.FlatAppearance.MouseOverBackColor = Color.Transparent;
            this.FlatStyle = FlatStyle.Flat;

            this.Image = this.NormalImage;

            this.MouseDown += (s, e) => { this.Image = this.MouseDownImage; };
            this.MouseUp += (s, e) => { this.Image = this.NormalImage; };

            this.MouseEnter += (s, e) =>
                {
                    if (this.MouseOverImage != null)
                    {
                        this.Image = this.MouseOverImage;
                    }
                };

            this.MouseLeave += (s, e) => { this.Image = this.NormalImage; };
        }

        #endregion

        #region Public Properties

        /// <summary>
        /// Gets or sets the back color.
        /// </summary>
        public override sealed Color BackColor
        {
            get
            {
                return base.BackColor;
            }

            set
            {
                base.BackColor = value;
            }
        }

        /// <summary>
        /// Gets or sets the mouse down image.
        /// </summary>
        public Image MouseDownImage
        {
            get
            {
                return this.mouseDownImage;
            }

            set
            {
                this.mouseDownImage = value;
                this.Invalidate();
            }
        }

        /// <summary>
        /// Gets or sets the mouse over image.
        /// </summary>
        public Image MouseOverImage
        {
            get
            {
                return this.mouseOverImage;
            }

            set
            {
                this.mouseOverImage = value;
                this.Invalidate();
            }
        }

        /// <summary>
        /// Gets or sets the normal image.
        /// </summary>
        public Image NormalImage
        {
            get
            {
                return this.normalImage;
            }

            set
            {
                this.normalImage = value;
                this.Size = new Size(
                    value.Width + this.Padding.Left + this.Padding.Right,
                    value.Height + this.Padding.Top + this.Padding.Bottom);
                this.Invalidate();
            }
        }

        #endregion

        #region Properties

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override bool CanRaiseEvents
        {
            get
            {
                return !ControlEventSuppressBlock.Enabled && base.CanRaiseEvents;
            }
        }

        #endregion
    }
}
