﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.ComponentModel;
using EffectMaker.UIControls.EffectBrowser.Controls.AddressBar.DirBreadcrumbList;

namespace EffectMaker.UIControls.EffectBrowser.Controls.AddressBar
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Windows.Forms;

    using AddressBar.DirBreadcrumbList;
    using EffectMaker.UIControls.EffectBrowser.Controls.Basic;
    using EffectMaker.UIControls.EffectBrowser.Controls.Interfaces;
    using EffectMaker.UIControls.EffectBrowser.Utilities;

    /// <summary>
    /// The eb dir history text box.
    /// </summary>
    public class EBDirHistoryTextBox : EBTextBox, IHasDirectory
    {
        #region Fields

        /// <summary>
        /// The history arrow.
        /// </summary>
        private readonly EBDirBreadcrumbListHistoryArrow historyArrow = new EBDirBreadcrumbListHistoryArrow
                                                                             {
                                                                                 Dock =
                                                                                     DockStyle
                                                                                     .Right
                                                                             };

        #endregion

        #region Constructors and Destructors

        /// <summary>
        /// Initializes a new instance of the <see cref="EBDirHistoryTextBox"/> class.
        /// </summary>
        public EBDirHistoryTextBox()
        {
            {
                // テキストボックス用履歴ボタン
                this.historyArrow.MenuClicked += (ss, ee) => this.Directory = ((ToolStripMenuItem)ss).Tag as string;

                this.Controls.Add(this.historyArrow);
            }
        }

        #endregion

        #region Public Events

        /// <summary>
        /// The directory changed.
        /// </summary>
        public event EventHandler DirectoryChanged;

        #endregion

        #region Public Properties

        /// <summary>
        /// Gets or sets the directory.
        /// </summary>
        public string Directory
        {
            get
            {
                return this.Text;
            }

            set
            {
                this.Text = value;
                this.UpdateHistory();

                if (ControlEventSuppressBlock.Enabled == false)
                {
                    if (this.DirectoryChanged != null)
                    {
                        this.DirectoryChanged(this, EventArgs.Empty);
                    }
                }
            }
        }

        /// <summary>
        /// Gets or sets the get directory history.
        /// </summary>
        public Func<IEnumerable<string>> GetDirectoryHistory
        {
            get
            {
                return this.historyArrow.GetDirectoryHistory;
            }

            set
            {
                this.historyArrow.GetDirectoryHistory = value;
                this.UpdateHistory();
            }
        }

        /// <summary>
        /// ヒストリー表示ボタンのツールチップテキストを取得または設定します。
        /// </summary>
        [Category("Appearance"), Description("Specifies the tool-tip of text on history button.")]
        public string HistoryButtonToolTipText
        {
            get { return this.historyArrow.ToolTipText; }
            set { this.historyArrow.ToolTipText = value; }
        }

        #endregion

        #region Methods

        /// <summary>
        /// The on visible changed.
        /// </summary>
        /// <param name="e">
        /// イベント引数
        /// </param>
        protected override void OnVisibleChanged(EventArgs e)
        {
            base.OnVisibleChanged(e);

            this.UpdateHistory();
        }

        /// <summary>
        /// The update history.
        /// </summary>
        private void UpdateHistory()
        {
            if (this.DesignMode)
            {
                return;
            }

            this.historyArrow.Enabled = (this.GetDirectoryHistory != null) && this.GetDirectoryHistory().Any();
        }

        #endregion
    }
}
