﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Windows.Forms;

namespace EffectMaker.UIDialogs.MessageDialogs
{
    /// <summary>
    /// 名前入力ダイアログクラスです。
    /// </summary>
    public partial class NameInputDialog : Form
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public NameInputDialog()
        {
            this.InitializeComponent();

            // ボタンに表示する文字を設定
            this.btnOk.Text = Properties.Resources.ControlsDialogResultOk;
            this.btnCancel.Text = Properties.Resources.ControlsDialogResultCancel;
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="caption">キャプション</param>
        /// <param name="defaultName">デフォルトの名前</param>
        public NameInputDialog(string caption, string defaultName)
        {
            this.InitializeComponent();

            // ボタンに表示する文字を設定
            this.btnOk.Text = Properties.Resources.ControlsDialogResultOk;
            this.btnCancel.Text = Properties.Resources.ControlsDialogResultCancel;

            // キャプション, デフォルト名を設定
            this.Caption = caption;
            this.tbInputedName.Text = defaultName;
        }

        /// <summary>
        /// キャプションを取得または設定します。
        /// </summary>
        public string Caption
        {
            get
            {
                return this.Text;
            }

            set
            {
                this.Text = value;
            }
        }

        /// <summary>
        /// 入力した名前を取得または設定します。
        /// </summary>
        public string InputedName
        {
            get
            {
                return this.tbInputedName.Text;
            }

            set
            {
                this.tbInputedName.Text = value;
            }
        }
    }
}
