﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Collections.Generic;
using EffectMaker.Foundation.Interfaces;
using EffectMaker.UIControls.Behaviors;

namespace EffectMaker.UIControls
{
    /// <summary>
    /// UI コントロールのインターフェースです。
    /// </summary>
    public interface IControl : IBindable
    {
        /// <summary>
        /// コントロールの名前を取得します。
        /// </summary>
        string Name { get; }

        /// <summary>
        /// ビヘイビアのコレクションを取得します。
        /// </summary>
        BehaviorCollection Behaviors { get; }

        /// <summary>
        /// チャイルドコントロールのコレクションを取得します。
        /// </summary>
        IIndexableCollection<ILogicalTreeElement> Controls { get; }

        /// <summary>
        /// リソースデータのディクショナリを取得します。
        /// </summary>
        IDictionary<string, object> Resources { get; }
    }
}
