﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Windows.Forms.VisualStyles;
using EffectMaker.Foundation.Interfaces;
using EffectMaker.UIControls.BaseControls;
using EffectMaker.UIControls.EventArguments;
using EffectMaker.UIControls.Extensions;
using EffectMaker.UIControls.Input;

namespace EffectMaker.UIControls.Focus
{
    /// <summary>
    /// A manager class that manages the control focus.
    /// </summary>
    public class ControlFocusManager
    {
        /// <summary>
        /// Get or set the control that has the global tab focus.
        /// </summary>
        public static Control GlobalTabFocusControl { get; set; }

        /// <summary>
        /// Initialize the manager.
        /// </summary>
        public static void Initialize()
        {
            GlobalKeyEventHandler.PreFilterKeyDown += (s, e) =>
            {
                if (GlobalKeyEventHandler.IsKeyPressed(Keys.Escape) &&
                    GlobalKeyEventHandler.PressedKeyCount == 1)
                {
                    FocusTabItemOrSubTabItem();
                    e.Filter = true;
                }
            };
        }

        /// <summary>
        /// Find the focused child control in the specified control.
        /// </summary>
        /// <param name="parent">The parent control to start searching.</param>
        /// <returns>The focused child control or null if nothing is focused.</returns>
        public static Control FindFocusedControl(Control parent)
        {
            foreach (Control control in parent.Controls)
            {
                if (control.Focused == true)
                {
                    return control;
                }

                Control focusedControl = FindFocusedControl(control);
                if (focusedControl != null)
                {
                    return focusedControl;
                }
            }

            return null;
        }

        /// <summary>
        /// タブアイテムにフォーカスを当てます。当たっている場合はサブタブアイテムにフォーカスを当てます。
        /// </summary>
        public static void FocusTabItemOrSubTabItem()
        {
            if (GlobalTabFocusControl == null)
            {
                return;
            }

            var tabpage = GlobalTabFocusControl as UITabPage;
            if (tabpage == null)
            {
                return;
            }

            var tabCtl = tabpage.Parent as UITabControl;
            if (tabCtl == null)
            {
                return;
            }

            if (!tabCtl.Focused)
            {
                tabCtl.Focus();
            }
            else
            {
                var subTab = GlobalTabFocusControl.Controls.OfType<TabControl>().FirstOrDefault();
                if (subTab != null)
                {
                    subTab.Focus();
                }
            }
        }
    }
}
