﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace EffectMaker.UIControls.Debug
{
    /// <summary>
    /// An extended ListViewItem that represent a form.
    /// </summary>
    public class FormListViewItem : ListViewItem
    {
        /// <summary>
        /// Initializes the FormListViewItem instance.
        /// </summary>
        /// <param name="form">The form represented by this list view item.</param>
        public FormListViewItem(Form form)
        {
            if (form == null)
            {
                throw new ArgumentNullException("form");
            }

            this.Form = form;

            this.SubItems[0].Text = form.Text;
            this.SubItems.Add(form.Name);
            this.SubItems.Add(form.GetType().FullName);
        }

        /// <summary>
        /// Gets the form represented by this list view item.
        /// </summary>
        public Form Form { get; private set; }
    }
}
