﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using EffectMaker.UIControls.Extensions;

namespace EffectMaker.UIControls.Core
{
    /// <summary>
    /// Suspends drawing of a control anfd child controls until disposed.
    /// </summary>
    public class DrawingSuspender : IDisposable
    {
        /// <summary>
        /// Stores the control to suspend the drawing.
        /// </summary>
        private Control control;

        /// <summary>
        /// Suspends the drawing of the given control.
        /// </summary>
        /// <param name="control">The control to suspend the drawing.</param>
        public DrawingSuspender(Control control)
        {
            this.control = control;

            if (control != null)
            {
                control.SuspendDrawing();
            }
        }

        /// <summary>
        /// Resumes the drawing of the control.
        /// </summary>
        public void Dispose()
        {
            if (this.control == null)
            {
                return;
            }

            this.control.ResumeDrawing();
            this.control = null;
        }
    }
}
