﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using EffectMaker.Foundation.Interfaces;
using EffectMaker.UIControls.Behaviors;
using EffectMaker.UIControls.DataBinding;
using EffectMaker.UIControls.Extenders;

namespace EffectMaker.UIControls.BaseControls
{
    /// <summary>
    /// Extended ToolStripDropDownItem class.
    /// </summary>
    public class UIToolStripDropDownItem : ToolStripDropDownItem, IControl
    {
        /// <summary>
        /// Backing field for the LogicalTreeElementExtender property.
        /// </summary>
        private LogicalTreeElementExtender logicalTreeElementExtender;

        /// <summary>
        /// Backing field for the Behavior property.
        /// </summary>
        private BehaviorCollection behaviors;

        /// <summary>
        /// Backing field for the Bindings property.
        /// </summary>
        private BindingContainer bindings;

        /// <summary>
        /// Backing field for the Children property.
        /// </summary>
        private ToolStripDropDownItemCollectionWrapper children;

        /// <summary>
        /// Backing field for the Resources property.
        /// </summary>
        private IDictionary<string, object> resources = new Dictionary<string, object>();

        /// <summary>
        /// Initializes the UIToolStripDropDownItem instance.
        /// </summary>
        public UIToolStripDropDownItem()
        {
            this.logicalTreeElementExtender = new LogicalTreeElementExtender(this);
            this.bindings = new BindingContainer(this);
            this.behaviors = new BehaviorCollection(this);
            this.children = new ToolStripDropDownItemCollectionWrapper(this);
        }

        /// <summary>
        /// Raised when the value of a property on this control changed.
        /// </summary>
#pragma warning disable 67
        public event PropertyChangedEventHandler PropertyChanged;
#pragma warning restore 67

        /// <summary>
        /// Gets the resources.
        /// </summary>
        public IDictionary<string, object> Resources
        {
            get { return this.resources; }
        }

        /// <summary>
        /// Gets the behavior collection.
        /// </summary>
        public BehaviorCollection Behaviors
        {
            get { return this.behaviors; }
        }

        /// <summary>
        /// Gets the control collection.
        /// </summary>
        public IIndexableCollection<ILogicalTreeElement> Controls
        {
            get { return this.children; }
        }

        /// <summary>
        /// Gets the binding collection.
        /// </summary>
        public BindingContainer Bindings
        {
            get { return this.bindings; }
        }

        /// <summary>
        /// Gets the LogicalTreeElementExtender instance.
        /// </summary>
        public LogicalTreeElementExtender LogicalTreeElementExtender
        {
            get { return this.logicalTreeElementExtender; }
        }

        /// <summary>
        /// Gets or sets the data context.
        /// </summary>
        [DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public object DataContext
        {
            get
            {
                return this.logicalTreeElementExtender.DataContext;
            }

            set
            {
                this.logicalTreeElementExtender.DataContext = value;
            }
        }

        /// <summary>
        /// Gets the logical tree parent.
        /// </summary>
        public new ILogicalTreeElement Parent
        {
            get
            {
                return base.Parent as ILogicalTreeElement;
            }
        }

        /// <summary>
        /// Gets the logical tree children.
        /// </summary>
        public IIndexableCollection<ILogicalTreeElement> Children
        {
            get { return this.Controls; }
        }

        /// <summary>
        /// Clears the data context.
        /// </summary>
        public void ClearDataContext()
        {
            this.logicalTreeElementExtender.ClearDataContext();
        }
    }
}
