﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace EffectMaker.UIControls.Specifics.TableEditor
{
    /// <summary>
    /// The table editor data grid text box column.
    /// </summary>
    public class TableEditorColumn : DataGridViewTextBoxColumn
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="TableEditorColumn"/> class.
        /// </summary>
        public TableEditorColumn()
        {
            this.HeaderCell.Style.Alignment = DataGridViewContentAlignment.MiddleCenter;
            this.DefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleCenter;
            this.SortMode = DataGridViewColumnSortMode.NotSortable;
        }

        /// <summary>
        /// Gets or sets the default cell value.
        /// </summary>
        public float DefaultCellValue { get; set; }

        /// <summary>
        /// Gets or sets the maximum cell value.
        /// </summary>
        public float MaxCellValue { get; set; }

        /// <summary>
        /// Gets or sets the minimum cell value.
        /// </summary>
        public float MinCellValue { get; set; }
    }
}
