﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using EffectMaker.Foundation.Interfaces;

namespace EffectMaker.UIControls.Specifics.Sliders.ValueTransforms
{
    /// <summary>
    /// Represent an uniform value transformation.
    /// </summary>
    public class UniformValueTransform : IValueTransform<float[]>
    {
        /// <summary>
        /// Stores the index used to lead the transformation of the other values.
        /// </summary>
        private int leadingIndex;

        /// <summary>
        /// Initializes the UniformValueTransform instance.
        /// </summary>
        /// <param name="leadingIndex">The index that lead the transformation
        /// of the other values.</param>
        public UniformValueTransform(int leadingIndex)
        {
            if (leadingIndex < 0)
            {
                throw new ArgumentOutOfRangeException("leadingIndex");
            }

            this.leadingIndex = leadingIndex;
        }

        /// <summary>
        /// Initializes the IValueTransform with initial values.
        /// </summary>
        /// <param name="initialValue">The initial values.</param>
        public void Initialize(float[] initialValue)
        {
        }

        /// <summary>
        /// Produces output values based on the leading input value.
        /// </summary>
        /// <param name="value">The input values.</param>
        /// <returns>Returns values all set to the leading input value.</returns>
        public float[] TransformValue(float[] value)
        {
            if (this.leadingIndex >= value.Length)
            {
                throw new ArgumentOutOfRangeException("leadingIndex");
            }

            return Enumerable.Repeat(value[this.leadingIndex], value.Length).ToArray();
        }
    }
}
