﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using EffectMaker.Foundation.Interfaces;

namespace EffectMaker.UIControls.Specifics.Sliders.ValueTransforms
{
    /// <summary>
    /// Represent a value transformation that does nothing.
    /// </summary>
    public class PassThroughValueTransform : IValueTransform<float[]>
    {
        /// <summary>
        /// Initializes the value transform.
        /// Does nothing.
        /// </summary>
        /// <param name="initialValue">The initial values.</param>
        public void Initialize(float[] initialValue)
        {
        }

        /// <summary>
        /// Let the input values to pass through.
        /// </summary>
        /// <param name="value">The input values.</param>
        /// <returns>Returns the input values as is.</returns>
        public float[] TransformValue(float[] value)
        {
            return value;
        }
    }
}
