﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace EffectMaker.UIControls.Specifics.CurveEditor.RenderingElements
{
    /// <summary>
    /// カーブエディタのビューポート上での描画要素であることを表すインタフェースです。
    /// </summary>
    internal interface IRenderingElement
    {
        /// <summary>
        /// 表示します。
        /// 既に表示済みにビューポートならば一旦削除して描画順を最後にします。
        /// </summary>
        /// <param name="viewports">表示するビューポート</param>
        void Show(LayeredViewports viewports);

        /// <summary>
        /// 非表示にします。
        /// </summary>
        /// <param name="viewports">非表示にするビューポート</param>
        void Hide(LayeredViewports viewports);
    }
}
