﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.ComponentModel;
using EffectMaker.Foundation.Utility;
using EffectMaker.UIControls.BaseControls;
using EffectMaker.UIControls.Behaviors;
using EffectMaker.UILogic.ViewModels;

namespace EffectMaker.UIControls.Specifics.Behaviors
{
    /// <summary>
    /// カラーページの交換ボタン押下時の振る舞い
    /// </summary>
    public class EmitterColorExchangeBehavior : Behavior<UIButton>, INotifyPropertyChanged
    {
        /// <summary>
        /// カラー要素
        /// </summary>
        private ColorElementType kind;

        /// <summary>
        /// Raised when the value of a property changes.
        /// </summary>
        public new event PropertyChangedEventHandler PropertyChanged;

        /// <summary>
        /// カラー要素
        /// </summary>
        public ColorElementType Kind
        {
            get
            {
                return this.kind;
            }

            set
            {
                this.kind = value;

                var handler = this.PropertyChanged;
                if (handler != null)
                {
                    handler(this, new PropertyChangedEventArgs("Kind"));
                }
            }
        }

        /// <summary>
        /// UIButtonにアタッチするときの処理を行います。
        /// </summary>
        protected override void OnAttached()
        {
            this.AssociatedObject.Click += this.OnClicked;
        }

        /// <summary>
        /// UIButtonからデタッチするときの処理を行います。
        /// </summary>
        protected override void OnDetaching()
        {
            this.AssociatedObject.Click -= this.OnClicked;
        }

        /// <summary>
        /// ボタンが押されたときの処理を行います。
        /// </summary>
        /// <param name="sender">sender</param>
        /// <param name="e">event</param>
        private void OnClicked(object sender, EventArgs e)
        {
            var particleVm = DataContext as EmitterColorSettingsViewModel;
            if (particleVm != null)
            {
                particleVm.ExchangeData(this.Kind);
                return;
            }

            var emitterVm = DataContext as EmitterColorColorViewModel;
            if (emitterVm != null)
            {
                emitterVm.ExchangeData(this.Kind);
                return;
            }

            System.Diagnostics.Debug.Assert(false, "ビヘイビアとビューモデルが対応していない。");
        }
    }
}
