﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Xml.Serialization;
using EffectMaker.Foundation.Serialization;

namespace EffectMaker.ObsoleteUserDataConverter.ObsoleteUserData
{
    /// <summary>
    /// The root definition of a custom shader definition.
    /// </summary>
    [Serializable]
    [XmlRoot("UserShaderUIDefinition")]
    public class CustomShaderDefinition : GroupDefinition
    {
        /// <summary>
        /// Default constructor.
        /// </summary>
        public CustomShaderDefinition() :
            base()
        {
        }

        /// <summary>
        /// Get or set the vertex shader paths.
        /// </summary>
        [XmlArrayItem("ShaderPath")]
        public List<string> VertexShaderPaths { get; set; }

        /// <summary>
        /// Get or set the fragment shader paths.
        /// </summary>
        [XmlArrayItem("ShaderPath")]
        public List<string> FragmentShaderPaths { get; set; }

        /// <summary>
        /// Deserializes from the given XML node.
        /// </summary>
        /// <param name="context">The data context needed for the deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            if (base.ReadXml(context) == false)
            {
                return false;
            }

            this.VertexShaderPaths = this.ReadListElement<string>(
                context,
                "VertexShaderPaths",
                this.VertexShaderPaths);

            this.FragmentShaderPaths = this.ReadListElement<string>(
                context,
                "FragmentShaderPaths",
                this.FragmentShaderPaths);

            return true;
        }
    }
}
