﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.ToolDevelopmentKit.Xml.Complex
{
    using System.IO;

    /// <summary>
    /// 複数種類のリソースが格納されたデータを、XML文章に書き出すクラスです。
    /// </summary>
    public interface IXmlComplexWriter
    {
        /// <summary>
        /// ファイルにデータ構造を、XML文章として書き出します。
        /// </summary>
        /// <param name="document">書き出し対象となるデータ構造です。</param>
        /// <param name="path">ファイルパスです。</param>
        /// <param name="mode">ファイルモードです。</param>
        void Write(IXmlComplexDocument document, string path, FileMode mode);

        /// <summary>
        /// ストリームにデータ構造を、XML文章として書き出します。
        /// </summary>
        /// <param name="document">書き出し対象となるデータ構造です。</param>
        /// <param name="stream">書き出し先ストリームです。</param>
        void Write(IXmlComplexDocument document, Stream stream);

        /// <summary>
        /// ストリームにデータ構造を、XML文章として書き出します。
        /// </summary>
        /// <param name="document">書き出し対象となるデータ構造です。</param>
        /// <param name="textWriter">書き出し先ストリームです。</param>
        void Write(IXmlComplexDocument document, TextWriter textWriter);

        /// <summary>
        /// データ構造を、XML文章として書き出します。
        /// </summary>
        /// <param name="document">書き出し対象となるデータ構造です。</param>
        /// <returns>XML文章です。</returns>
        string CreateString(IXmlComplexDocument document);
    }
}
