﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.ToolDevelopmentKit.Xml.Complex
{
    using System;
    using System.ComponentModel;
    using System.Xml;
    using NintendoWare.ToolDevelopmentKit;

    /// <summary>
    /// XML コンテンツのインターフェースです。
    /// </summary>
    public interface IXmlContent : ICloneable, INotifyPropertyChanged, ISettable
    {
        /// <summary>
        /// XML文章 を設定または取得します。
        /// </summary>
        string Xml { get; set; }

        /// <summary>
        /// XmlWriterに内容を書き出します。
        /// </summary>
        /// <param name="writer">XmlWriterです。</param>
        void Export(XmlWriter writer);
    }
}
