﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Xml.Serialization;
using NintendoWare.ToolDevelopmentKit;
using NintendoWare.ToolDevelopmentKit.Conversion;
using NintendoWare.ToolDevelopmentKit.Xml;
using NW4F.DataModel;

namespace NW4F.Viewer.Xml
{
    /// <summary>
    /// コンバーター用スクリプトファイル
    /// </summary>
    [XmlRoot("SEADPtclConverterArg")]
    public class SEADPtclConverterArgXml
    {
        #region 子クラス

        /// <summary>
        /// EmitterSet用
        /// </summary>
        [XmlType("EmitterSet")]
        public class EmitterSetInfo
        {
            /// <summary>
            /// コンストラクタ
            /// </summary>
            public EmitterSetInfo()
            {
                this.dir = ".";
                this.file = null;
            }

            /// <summary>
            /// コンストラクタ
            /// </summary>
            public EmitterSetInfo(string dir)
            {
                this.dir = dir;
            }

            /// <summary>
            /// ディレクトリー
            /// </summary>
            public string dir
            {
                get;
                set;
            }

            /// <summary>
            /// ファイル指定
            /// </summary>
            public string file
            {
                get;
                set;
            }
        }

        #endregion

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public SEADPtclConverterArgXml()
        {
            this.name = ".";
            this.EmitterSetList = new List<EmitterSetInfo>();
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public SEADPtclConverterArgXml(string name)
            :this()
        {
            this.name = name;
        }

        /// <summary>
        /// デフォルト設定をします。
        /// </summary>
        public void SetDefault()
        {
            this.EmitterSetList.Add(
                new NW4F.Viewer.Xml.SEADPtclConverterArgXml.EmitterSetInfo());
        }

        /// <summary>
        /// 表示用の名前
        /// </summary>
        public string name
        {
            get;
            set;
        }

        /// <summary>
        /// EmitterSetList
        /// </summary>
        [XmlArrayItem("EmitterSet")]
        public List<EmitterSetInfo> EmitterSetList
        {
            get;
            set;
        }
    }
}
