﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using EffectMaker.Foundation.Core;

namespace EffectMaker.Foundation.Log
{
    /// <summary>
    /// ログの出力設定を行うクラスです。
    /// </summary>
    public class LogSettings : IDisposable
    {
        /// <summary>
        /// The previous log level.
        /// </summary>
        private LogLevels prevLogLevel;

        /// <summary>
        /// The previous destination.
        /// </summary>
        private string prevLogDestination;

        /// <summary>
        /// Constructor.
        /// </summary>
        /// <param name="logLevel">The log level.</param>
        /// <param name="destination">The log destination.</param>
        public LogSettings(LogLevels logLevel, string destination)
        {
            // Set the new log settings.
            this.prevLogLevel = Logger.DefaultLogLevel;
            this.prevLogDestination = Logger.DefaultLogDestination;

            // Save the previous log settings.
            Logger.DefaultLogLevel = logLevel;
            Logger.DefaultLogDestination = destination;
        }

        /// <summary>
        /// Implement IDisposable.
        /// </summary>
        public void Dispose()
        {
            // Restore the log settings.
            Logger.DefaultLogLevel = this.prevLogLevel;
            Logger.DefaultLogDestination = this.prevLogDestination;
        }
    }
}
