﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Xml.Serialization;

using EffectMaker.Foundation.Core;

namespace EffectMaker.Foundation.Interfaces
{
    /// <summary>
    /// Interface for primitives.
    /// </summary>
    public interface IPrimitive : IXmlSerializable,
                                  ICloneable,
                                  ISettable,
                                  IEquatable<object>
    {
        /// <summary>
        /// Get the number of values the primitive contains.
        /// </summary>
        int Count { get; }

        /// <summary>
        /// Get the type of the values the primitive contains.
        /// </summary>
        ValueTypes ValueType { get; }

        /// <summary>
        /// Gets or sets the value at a certain index.
        /// </summary>
        /// <param name="index">Index of component value to get or set.</param>
        /// <returns>The value.</returns>
        object this[int index] { get; set; }

        /// <summary>
        /// Set all the values of the primitive to zero.
        /// </summary>
        void SetZero();

        /// <summary>
        /// Set all the values of the primitive to one.
        /// </summary>
        void SetOne();
    }
}
